/**
 * Copyright zahir ( http://wonderfl.net/user/zahir )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9GEP
 */

package
{
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Matrix3D;
    import flash.geom.Utils3D;
    import flash.geom.Vector3D;
    
    public class Triangles_test extends Sprite
    {
        
        private var vertices:Vector.<Number>;
        private var indices:Vector.<int>;
        private var uv:Vector.<Number>;
        
        private var rot:Number = 0;
        
        private var bd:BitmapData;
        
        public function Triangles_test()
        {
            vertices = new <Number>[50,50,50, 100,100,100, -50,100,0];
            indices = new <int>[];
            uv = new <Number>[0,0, 0,1, 2,2];
            
            bd = new BitmapData(128,128, false, 0);
            for( var b:int = 0; b <= 128; b++)
            {
                for( var g:int = 0; g <= 128; g++)
                {
                    bd.setPixel( g,b, ((g*2) << 8) | (b*2));
                }
            }
            
            addEventListener(Event.ENTER_FRAME, onEnter);
        }
        private function onEnter(e:Event):void
        {
            rot++;
            var m:Matrix3D = new Matrix3D();
            m.appendRotation( rot, Vector3D.Y_AXIS);
            m.appendTranslation( 232, 0, 0 );
            var pv:Vector.<Number> = new Vector.<Number>();
            Utils3D.projectVectors(m, vertices, pv, new <Number>[] );
            
            graphics.clear();
            graphics.lineStyle( 1, 0xFF0000 );
            graphics.beginBitmapFill( bd );
            graphics.drawTriangles(pv, null, uv);
            graphics.endFill();
        }
    }
}