/**
 * Copyright actionscriptbible ( http://wonderfl.net/user/actionscriptbible )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9G9t
 */

package {
  import flash.display.*;
  import flash.events.*;
  import flash.media.*;
  import flash.system.*;
  import flash.text.*;
  import flash.ui.Keyboard;
  public class ch33ex3 extends Sprite {
    protected var mic:Microphone;
    protected var levelMeter:Shape;
    protected var peak:Shape;
    protected var gainTF:TextField;
    public function ch33ex3() {
      mic = Microphone.getMicrophone();
      //you can't see any activity without loopback being on
      mic.setLoopBack(true);
      //but loopback is annoying, so mute it!
      mic.soundTransform = new SoundTransform(0);

      gainTF = new TextField();
      gainTF.autoSize = TextFieldAutoSize.LEFT;
      gainTF.defaultTextFormat = new TextFormat("_typewriter", 12, 0);
      addChild(gainTF); gainTF.x = gainTF.y = 10;
      levelMeter = new Shape();
      levelMeter.graphics.beginFill(0x0000ff, 1);
      levelMeter.graphics.drawRect(0, 0, 80, -220);
      addChild(levelMeter); levelMeter.x = 10; levelMeter.y = 220 + 30; 
      var s:Shape = new Shape();
      s.graphics.lineStyle(2, 0, 1, true, null, null, JointStyle.BEVEL);
      s.graphics.drawRect(0, 0, 80, 220);
      addChild(s); s.x = 10; s.y = 30;
      peak = new Shape();
      peak.graphics.beginFill(0xff0000, 1);
      peak.graphics.drawCircle(0, 0, 8);
      addChild(peak); peak.x = 120; peak.y = 30;
      
      addEventListener(Event.ENTER_FRAME, onEnterFrame);
      stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
    }
    protected function onKeyDown(event:KeyboardEvent):void {
      switch (event.keyCode) {
        case Keyboard.ESCAPE:
        case Keyboard.SPACE:
            Security.showSettings(SecurityPanel.MICROPHONE); break;
        case Keyboard.UP: mic.gain += 1; break;
        case Keyboard.DOWN: mic.gain -= 1; break;
      }
    }
    protected function onEnterFrame(event:Event):void {
      levelMeter.scaleY = mic.activityLevel / 100;
      gainTF.text = mic.gain.toFixed(1);
      if (mic.activityLevel >= 100) {
        peak.alpha += 0.33;
      } else {
        peak.alpha *= 0.7;
      }
    }
  }
}