/**
 * Copyright ohisama ( http://wonderfl.net/user/ohisama )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9G9I
 */

package
{
    import flash.net.*;
    import flash.events.Event;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.system.Security;
    public class FlashTest extends Sprite
    {
        private var bvh : BVH;
        private var txt : TextField;
        private var oX : int = 200;
        private var oY : int = 400;
        private var SCALE : int = 2;
        private var m_tree : Array = new Array;
        private var draw_DATA : Array =
        [
            [0, 1], [1, 2], [2, 3], [3, 4], [3, 5], [5, 6], [6, 7], [7, 8], [3, 9], [9, 10], [10, 11], [11, 12],
            [0, 13], [13, 14], [14, 15], [0,16], [16, 17], [17, 18], [0, 0], [0, 0]
        ];       
        private var m_build : Array =
        [
            [0, 1, 2, 3, 4],
            [0, 13, 14, 15],
            [0, 16, 17, 18],
            [3, 5, 6, 7, 8],
            [3, 9, 10, 11, 12]
        ];
        private var m_Vertices : Array = new Array;
        private var m_r : Array = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
        private var m_Phi : Number = 0;
        private var m_Theta : Number = 0;
        private var m_Frame : Number = 0;
        private var bvh_DATA : Array;
        public function FlashTest()
        {
            m_tree[0] = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18];
            m_tree[1] = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12];
            m_tree[2] = [2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12];
            m_tree[3] = [3, 4, 5, 6, 7, 8, 9, 10, 11, 12];
            m_tree[4] = [4];
            m_tree[5] = [5, 6, 7, 8];
            m_tree[6] = [6, 7, 8];
            m_tree[7] = [7, 8];
            m_tree[8] = [8];
            m_tree[9] = [9, 10, 11, 12];
            m_tree[10] = [10, 11, 12];
            m_tree[11] = [11, 12];
            m_tree[12] = [12];
            m_tree[13] = [13, 14, 15];
            m_tree[14] = [14, 15];
            m_tree[15] = [15];
            m_tree[16] = [16, 17, 18];
            m_tree[17] = [17, 18];
            m_tree[18] = [18];
            m_tree[19] = [19];
            bvh = new BVH();
            txt = new TextField();
            var tf : TextFormat = new TextFormat();
            tf.size = 10;
            txt.autoSize = TextFieldAutoSize.LEFT;
            txt.width = 300;
            txt.height = 300;
            txt.defaultTextFormat = tf;
            //txt.text = "ok\nok";
            txt.x = 100;
            addChild(txt);
            var bvhData : String;
            Security.loadPolicyFile('http://p.jsapp.us/crossdomain.xml');
            var request : URLRequest = new URLRequest('http://p.jsapp.us/proxy/' + "http://www5b.biglobe.ne.jp/~pengin1/mqo/drunk1.bvh");
            var ul : URLLoader = new URLLoader(request);
            ul.addEventListener(Event.COMPLETE, function (e : Event) : void
            {
                var i : int;
                bvhData = ul.data;
                bvh.parse(bvhData);
                bvh_DATA = bvh.mdata;
                for (i = 0; i < 20; i++)
                {
                    var v : Array = bvh.off[i];
                    m_Vertices.push(new Vertex(v[0], v[1], v[2]));
                }
                for (i = 0; i < 20; i++)
                {
                    var c : String = String(bvh.off[i]) + "\n";
                    txt.appendText(c); 
                }
                //txt.text = bvh.res;                
                addEventListener(Event.ENTER_FRAME, onEnterFrameHandler);
            });
        } 
        private function onEnterFrameHandler(e : Event) : void
        {
            graphics.beginFill(0xf0f0f0, 1);
            graphics.drawCircle(230, 200, 190);
            m_Theta = 0;
            m_Phi = 0;            
            m_Frame += 1;
            if (m_Frame > (bvh_DATA.length - 2))
            {
                m_Frame = 0;
            }
            rotate(m_Frame);
            kumitate(m_Frame);
            move(m_Frame);
            touei();
            graphics.lineStyle(2, 0x0000ff);
            var i : int;
            for (i = 0; i < 19; i++)
            { 
                var v0 : Vertex = m_Vertices[draw_DATA[i][0]];
                var v1 : Vertex = m_Vertices[draw_DATA[i][1]];
                graphics.moveTo(v0.rx * SCALE + oX , -v0.ry * SCALE + oY);
                graphics.lineTo(v1.rx * SCALE + oX, -v1.ry * SCALE + oY);
            }
            //txt.text = String(m_Frame);
        }
        private function touei() : void
        {
            var i : int;
            for (i = 0; i < 19; i++)
            {
                var v : Vertex = m_Vertices[i]
                var st : Number = Math.sin(m_Theta);
                var ct : Number = Math.cos(m_Theta);
                var sp : Number = Math.sin(m_Phi);
                var cp : Number = Math.cos(m_Phi);
                v.rx = v.x1 * ct + v.z1 * st;
                v.ry = v.x1 * sp * st + v.y1 * cp - v.z1 * sp * ct;
            }
        } 
        private function move(m : int) : void
        {
            var i : int;
            var b : Array = bvh_DATA[m];
            for (i = 0; i < 19; i++)
            {
                var v : Vertex = m_Vertices[i]
                v.x1 = v.x1 + b[0];
                v.y1 = v.y1 + b[1];
                v.z1 = v.z1 + b[2];
            }
        }
        private function kumitate(m : int) : void
        {
            var i : int;
            var j : int;
            var b : Array = bvh_DATA[m];
            for (i = 0; i < 5; i++)
            {
                var g : Array = m_build[i];
                for (j = 0; j < g.length; j++)
                {
                    var v : Vertex = m_Vertices[g[j]];
                    var ax : Number = m_r[g[j] * 3] / 57;
                    var ay : Number = m_r[g[j] * 3 + 1] / 57;
                    var az : Number = m_r[g[j] * 3 + 2] / 57;
                    if (j == 0)
                    {
                        var y1 : Number = v.y;
                        var x1 : Number = v.x * Math.cos(ay) + v.z * Math.sin(ay);
                        var z1 : Number = v.z * Math.cos(ay) - v.x * Math.sin(ay);
                        var x2 : Number = x1;
                        var y2 : Number = y1 * Math.cos(ax) - z1 * Math.sin(ax);
                        var z2 : Number = z1 * Math.cos(ax) + y1 * Math.sin(ax);
                        v.x1 = x2 * Math.cos(az) - y2 * Math.sin(az);
                        v.y1 = y2 * Math.cos(az) + x2 * Math.sin(az);
                        v.z1 = z2;
                        var xx : Number = v.x1;
                        var yy : Number = v.y1;
                        var zz : Number = v.z1;
                    } 
                    else 
                    {
                        y1 = v.y;
                        x1 = v.x * Math.cos(ay) + v.z * Math.sin(ay);
                        z1 = v.z * Math.cos(ay) - v.x * Math.sin(ay);
                        x2 = x1;
                        y2 = y1 * Math.cos(ax) - z1 * Math.sin(ax);
                        z2 = z1 * Math.cos(ax) + y1 * Math.sin(ax);
                        v.x1 = x2 * Math.cos(az) - y2 * Math.sin(az);
                        v.y1 = y2 * Math.cos(az) + x2 * Math.sin(az);
                        v.z1 = z2;
                        xx = v.x1 = v.x1 + xx; 
                        yy = v.y1 = v.y1 + yy;
                        zz = v.z1 = v.z1 + zz;
                    }
                }
            }
        }
        private function rotate(m : int) : void
        {
            var i : int;
            var j : int;
            var b : Array = bvh_DATA[m];
            m_r = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            for (i = 0; i < 19; i++)
            {
                var tree1 : Array = m_tree[i];
                for (j = 0; j < tree1.length; j++)
                {
                    m_r[tree1[j] * 3] = m_r[tree1[j] * 3] + b[3 + i * 3];
                    m_r[tree1[j] * 3 + 1] = m_r[tree1[j] * 3 + 1] + b[4 + i * 3];
                    m_r[tree1[j] * 3 + 2] = m_r[tree1[j] * 3 + 2] + b[5 + i * 3];
                }
            }
        }
    }
}
class Vertex
{
    public var rx : Number;
    public var ry : Number;
    public var rz : Number;
    public var x1 : Number;
    public var y1 : Number;
    public var z1 : Number;
    public var x : Number;
    public var y : Number;
    public var z : Number;
    function Vertex(x : Number, y : Number, z : Number)
    {
         this.x = x;
         this.y = y;
         this.z = z;   
    }
}
import flash.utils.*;
import flash.text.*;
import org.ascollada.utils.StringUtil;
class BVH   
{
    private var name : Object = 
    {
        "HIP" : 0, "ABDOMEN" : 1, "CHEST2" : 1, "CHEST" : 1, "NECKDUMMY" : 3, "NECK" : 2, "HEAD" : 4, "FIGUREHAIR" : 4,
        "LCOLLAR" : 5, "LEFTCOLLAR" : 5, "LSHLDR" : 6, "LEFTUPARM" : 6, "LEFTSHOULDER" : 6,
        "LFOREARM" : 7, "LEFTLOWARM" : 7, "LEFTELBOW" : 7, "LHAND" : 8, "LEFTHAND" : 8, "LEFTWRIST" : 8,
        "RCOLLAR" : 9, "RIGHTCOLLAR" : 9, "RSHLDR" : 10, "RIGHTUPARM" : 10, "RIGHTSHOULDER" : 10,
        "RFOREARM" : 11, "RIGHTLOWARM" : 11, "RIGHTELBOW" : 11, "RHAND" : 12, "RIGHTHAND" : 12, "RIGHTWRIST" : 12,
        "LTHIGH" : 13, "LEFTUPLEG" : 13, "LEFTHIP" : 13, "LSHIN" : 14, "LEFTLOWLEG" : 14, "LEFTKNEE" : 14,
        "LFOOT" : 15, "LEFTFOOT" : 15, "LEFTANKLE" : 15,
        "RTHIGH" : 16, "RIGHTUPLEG" : 16, "RIGHTHIP" : 16, "RSHIN" : 17, "RIGHTLOWLEG" : 17, "RIGHTKNEE" : 17,
        "RFOOT" : 18, "RIGHTFOOT" : 18, "RIGHTANKLE" : 18
    };
    public var sampleRate : Number; 
    private var _frames : Array; 
    public var _numFrames : uint;
    private var _currentFrame : uint;
    public var res : String = "";
    public var tikan : Array = [0, 0, 0, 3, 4, 5, 0, 0, 0, 9, 10, 11, 10, 11, 9];
    public var off : Array =
    [
        [0, 1, 2], [3, 4, 5], [7, 8, 9], [0, 0, 0], 
        [0, 1, 3], [4, 1, 5], [8, 0, 1], [0, 2, 2],
        [0, 1, 6], [7, 1, 8], [1, 2, 3], [1, 5, 6],
        [3, 5, 0], [6, 7, 8], [7, 7, 7], [1, 5, 3],
        [3, 9, 0], [1, 1, 1], [1, 1, 2], [3, 3, 3]
    ];
    private var ff : int = 0;
    private var fc : int = 0;
    private var ss : int = 0;
    public var mdata : Array = new Array;
    public function BVH()
    {
    }
    public function parse(data : String) : void
    {
        var lines : Array = data.split("\n");
        var line : String;
        var parts : Array;
        var cmd : String;
        var i : int, j : int;
        var bn : int = 0;
        for (i = 0; i < lines.length; i++)
        {
            line = StringUtil.trim(lines[i]);
            parts = line.split(/\s+/);
            cmd = parts[0];
            switch (cmd) 
            {
            case "ROOT" :
                bn = 0;
                //res += cmd + "\n";
            break;
            case "JOINT" :
                //res += parts[1].toUpperCase() + "\n";
                var k : String = parts[1].toUpperCase();
                bn = name[k];
                res += String(bn) + " ";
            break;
            case "OFFSET":
                //res += parts[1] + "\n";
                off[bn][0] = Number(parts[1]);
                off[bn][1] = Number(parts[2]);
                off[bn][2] = Number(parts[3]);
            break;
            case "CHANNELS" :
                //res += parts[2].toUpperCase() + "\n";
                if (bn == 0)
                {
                    for (j = 0; j < 6; j++)
                    {
                        switch (parts[2 + j].toUpperCase())
                        { 
                        case "XPOSITION":
                            tikan[0] = j;
                        break;
                        case "YPOSITION":
                            tikan[1] = j;
                        break;
                        case "ZPOSITION":
                            tikan[2] = j;
                        break;
                        case "XROTATION":
                            tikan[3] = j;
                        break;
                        case "YROTATION":
                            tikan[4] = j;
                        break;
                        case "ZROTATION":
                            tikan[5] = j;
                        break;
                        }
                    }
                }
                else
                {
                    for (j = 0; j < 3; j++)
                    {
                        switch (parts[2 + j].toUpperCase())
                        {
                        case "XROTATION":
                            tikan[bn * 3 + 3] = bn * 3 + j + 3;
                        break;
                        case "YROTATION":
                            tikan[bn * 3 + 4]= bn * 3 + j + 3;
                        break;
                        case "ZROTATION":
                            tikan[bn * 3 + 5] = bn * 3 + j + 3;
                        break;
                        }
                    }
                }
                //res += cmd + "\n";
            break;
            case "{" :
            case "}" :
            break;    
            case "Frames:" :
                ff = Number(parts[1]);
                //res += parts[1] + "\n";
            break; 
            case "Frame" :
                ss = 1;
                //res += cmd + "\n";
            break;
            default : 
                if (ss == 1 && fc < ff)
                {
                    var stack : Array = new Array;
                    for (j = 0; j < 60; j++)
                    {
                        stack.push(Number(parts[tikan[j]]));
                    } 
                    mdata.push(stack);
                    fc++;
                    //res += parts[0] + "\n";
                }
                //res += cmd + "\n";
            break;
            }
        }
    }
}
    