/**
 * Copyright JohnBrookes ( http://wonderfl.net/user/JohnBrookes )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9G7H
 */

package
{
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.ui.Mouse;
    import gs.TweenMax;
    import org.papervision3d.events.InteractiveScene3DEvent;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.view.BasicView;
    //import uk.co.shrewballooba.pv.objects.special.Gimble;
   
    public class PVUnfoldCube2 extends BasicView
    {
        private var frontpivot:DisplayObject3D;
        private var backpivot:DisplayObject3D;
        private var leftpivot:DisplayObject3D;
        private var rightpivot:DisplayObject3D;
        private var toppivot:DisplayObject3D;
       
        private var CUBEWIDTH:Number = 200;
        private var CUBEHEIGHT:Number = 200;
        private var CUBEDEPTH:Number = 200;
       
        private var bottomPlanematerial:ColorMaterial;
        private var frontPlanematerial:ColorMaterial;
        private var backPlanematerial:ColorMaterial;
        private var leftPlanematerial:ColorMaterial;
        private var rightPlanematerial:ColorMaterial;
        private var topPlanematerial:ColorMaterial;
       
        private var vr:Number = .05;
        private var isDown : Boolean = false;
        private var drag:Boolean;
        private var _x : Number;
        private var _y : Number;
       
        private var _vx : Number = 0;
        private var _vy : Number = 0;
       
        private var cubeHolder:DisplayObject3D;
        private var topPlane:Plane;
        public function PVUnfoldCube2():void
        {
            createCube();
            viewport.interactive = true;
           
            singleRender();
            addEventListener(Event.ENTER_FRAME, tick);
           
            stage.addEventListener(MouseEvent.MOUSE_DOWN, downHandler);
            stage.addEventListener(MouseEvent.MOUSE_UP, upHandler);
        }
       
        private function createCube():void
        {
           
            cubeHolder = new DisplayObject3D();
            scene.addChild(cubeHolder);
           
            // ------------------------------------------------------------------------
            //    BOTTOM
            // ------------------------------------------------------------------------
            bottomPlanematerial= new ColorMaterial(0xff0000)
            var bottomPlane:Plane = new Plane(bottomPlanematerial, CUBEWIDTH, CUBEDEPTH);
            bottomPlane.y = -100;
            bottomPlane.pitch(-90);
            cubeHolder.addChild(bottomPlane);
           
            /*
            var axis:Gimble = new Gimble();
            bottomPlane.addChild(axis);
            axis.useOwnContainer = true;
            */
           
            // ------------------------------------------------------------------------
            //    FRONT
            // ------------------------------------------------------------------------
            frontpivot = new DisplayObject3D();
            frontpivot.y = CUBEDEPTH/2;
            bottomPlane.addChild(frontpivot);
           
            frontPlanematerial= new ColorMaterial(0x00ff00)
            var frontPlane:Plane = new Plane(frontPlanematerial, CUBEWIDTH, CUBEHEIGHT);
            frontPlane.z = CUBEHEIGHT/2;
            frontPlane.pitch(90);
            frontpivot.addChild(frontPlane);
           
           
            // ------------------------------------------------------------------------
            //    BACK
            // ------------------------------------------------------------------------
            backpivot = new DisplayObject3D();
            backpivot.y = -CUBEDEPTH/2;
            bottomPlane.addChild(backpivot);
           
            backPlanematerial= new ColorMaterial(0xffff00)
            var backPlane:Plane = new Plane(backPlanematerial, CUBEWIDTH, CUBEHEIGHT);
            backPlane.z = CUBEHEIGHT/2;
            backPlane.pitch(-90);
            backpivot.addChild(backPlane);
           
            // ------------------------------------------------------------------------
            //    LEFT
            // ------------------------------------------------------------------------
            leftpivot = new DisplayObject3D();
            leftpivot.x = CUBEWIDTH/2;
            bottomPlane.addChild(leftpivot);
           
            leftPlanematerial= new ColorMaterial(0x0000ff)
            var leftPlane:Plane = new Plane(leftPlanematerial, CUBEHEIGHT, CUBEDEPTH);
            leftPlane.z = CUBEHEIGHT/2;
            leftPlane.yaw(-90);
            leftpivot.addChild(leftPlane);
           
           
            // ------------------------------------------------------------------------
            //    RIGHT
            // ------------------------------------------------------------------------
            rightpivot = new DisplayObject3D();
            rightpivot.x = -CUBEWIDTH/2;
            bottomPlane.addChild(rightpivot);
           
            rightPlanematerial= new ColorMaterial(0x000000)
            var rightPlane:Plane = new Plane(rightPlanematerial, CUBEHEIGHT, CUBEDEPTH);
            rightPlane.z = CUBEHEIGHT/2;
            rightPlane.yaw(90);
            rightpivot.addChild(rightPlane);
           
            // ------------------------------------------------------------------------
            //    TOP
            // ------------------------------------------------------------------------
            toppivot = new DisplayObject3D();
            toppivot.y = CUBEHEIGHT/2;
            frontPlane.addChild(toppivot);
           
            topPlanematerial = new ColorMaterial(0x5E3A6D);
            topPlanematerial.interactive = true;
            topPlane = new Plane(topPlanematerial, CUBEWIDTH,CUBEDEPTH);
            topPlane.z = CUBEDEPTH/2;
            topPlane.pitch(90);
            toppivot.addChild(topPlane);
           
            topPlane.addEventListener(InteractiveScene3DEvent.OBJECT_CLICK, opencube, false, 0, true);
            topPlane.addEventListener(InteractiveScene3DEvent.OBJECT_OVER, mouseIcon, false, 0, true);
            topPlane.addEventListener(InteractiveScene3DEvent.OBJECT_OUT, mouseIcon, false, 0, true);
           
        }
       
        private function mouseIcon(e:InteractiveScene3DEvent):void
        {
            if (e.type == "mouseOver")
            {
                this.buttonMode = true;
            }
            else
            {
                this.buttonMode = false;
            }
        }
       
        private function opencube(e:InteractiveScene3DEvent):void
        {
            bottomPlanematerial.doubleSided = true;
            frontPlanematerial.doubleSided = true;
            backPlanematerial.doubleSided = true;
            leftPlanematerial.doubleSided = true;
            rightPlanematerial.doubleSided = true;
            topPlanematerial.doubleSided = true;
           
            TweenMax.to(frontpivot, 3, { localRotationX:"90", onStart:onStartTween  } );
            TweenMax.to(backpivot, 3, { localRotationX:"-90" } );
            TweenMax.to(leftpivot, 3, { localRotationY:"-90" } );
            TweenMax.to(rightpivot, 3, { localRotationY:"90" } );
            TweenMax.to(toppivot, 3, { localRotationX:"90", onComplete:onEndTween } );
           
            e.target.removeEventListener(InteractiveScene3DEvent.OBJECT_CLICK, opencube);
            e.target.removeEventListener(InteractiveScene3DEvent.OBJECT_OVER, mouseIcon);
        }
       
        private function onStartTween():void
        {
           
        }
       
        private function onEndTween():void
        {
            TweenMax.to(frontpivot, 3, { localRotationX:"-90" } );
            TweenMax.to(backpivot, 3, { localRotationX:"90" } );
            TweenMax.to(leftpivot, 3, { localRotationY:"90" } );
            TweenMax.to(rightpivot, 3, { localRotationY:"-90" } );
            TweenMax.to(toppivot, 3, { localRotationX:"-90", onComplete:onEndTween2} );
        }
       
        private function onEndTween2():void
        {
            bottomPlanematerial.doubleSided = false;
            frontPlanematerial.doubleSided = false;
            backPlanematerial.doubleSided = false;
            leftPlanematerial.doubleSided = false;
            rightPlanematerial.doubleSided = false;
            topPlanematerial.doubleSided = false;
           
            topPlane.addEventListener(InteractiveScene3DEvent.OBJECT_CLICK, opencube, false, 0, true);
            topPlane.addEventListener(InteractiveScene3DEvent.OBJECT_OVER, mouseIcon, false, 0, true);
        }
       
        // camera orbit easing
        private function downHandler(event : MouseEvent) : void {
            _x = mouseX;
            _y = mouseY;
            isDown = true;
            stage.addEventListener(MouseEvent.MOUSE_MOVE, moveHandler);
        }
       
        private function upHandler(event : MouseEvent) : void {
            isDown = false;
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, moveHandler);
        }
       
        private function moveHandler(event : MouseEvent) : void {
            _vx = (mouseX - _x) * .4;
            _vy = (mouseY - _y) * .2;
            _x = mouseX;
            _y = mouseY;
           
            cubeHolder.rotationX  -= _vy;
            cubeHolder.rotationY -= _vx;
           
        }
       
        private function tick(e:Event):void
        {
            //easing
            if(!isDown) {
                if(_vx != 0 || _vy != 0) {
                    _vx *= .9;
                    _vy *= .9;
                    if(Math.abs(_vx) < .1) {
                        _vx = 0;
                    }
                    if(Math.abs(_vy) < .1) {
                        _vy = 0;
                    }
                    cubeHolder.rotationX -= _vy;
                    cubeHolder.rotationY -= _vx;
                }
            }
            singleRender();
        }
    }
}