/**
 * Copyright 9re ( http://wonderfl.net/user/9re )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9G1X
 */

package {
/*
   function set x or y of Sprite is not called even if
   x or y is changed by dragging the Sprite instance.
   So you cannot rectrict the drag area by overriding
   these functions. Pass the second argument of startDrag()
   instead!
*/
    import flash.display.MovieClip;
    import flash.text.TextField;
    
    public class FlashTest extends MovieClip {
        public function FlashTest() {
            graphics.beginFill(0x0000ff, 0.1);
            graphics.drawRect(225, 20, 15, 425);
            graphics.endFill();
            
            var tf:TextField = new TextField();
            addChild(tf);
			
            var bar:Bar = new Bar();
            bar.logTarget = tf;
            bar.x = 225;
            bar.minPos = bar.y = 20;
            bar.maxPos = 395;
            bar.graphics.beginFill(0x0000ff, 0.1);
            bar.graphics.drawRect(0, 0, 15, 50);
            bar.graphics.endFill();
            bar.tabEnabled = false;
            bar.buttonMode = true;
            addChild(bar);
            
        }
    }
}

import flash.display.Sprite;
import flash.events.*;
import flash.geom.Rectangle;
import flash.text.TextField;
class Bar extends Sprite {
    public var minPos:int;
    public var maxPos:int;
    private var _init:Boolean = false;
    private var _x:Number;
    private var _logTarget:TextField;
    
    public function Bar() {
        addEventListener(Event.ADDED_TO_STAGE, stageHandler);
    }
    
    public function set logTarget(value:TextField):void {
        _logTarget = value;
    }
    
    // this function isn't called while startDrag()
    override public function set x(value:Number):void 
    {
        if (!_init) {
            _init = true;
            _x = value;
        }
        _logTarget.appendText("set x:" + value + "\n");
        super.x = value;
    }
    
    // this function isn't called while startDrag()
    override public function set y(value:Number):void {
        _logTarget.appendText("set y:" + value + "\n");
        super.y = value;
    }
    
    private function stageHandler(e:Event):void {
        addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
        stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
    }    
  
    private function mouseDownHandler(e:MouseEvent):void {
        startDrag(true, new Rectangle(_x, minPos, 0, maxPos - minPos));
    }
    
    private function mouseUpHandler(e:MouseEvent):void {
        stopDrag();
    }
    
    private function get timestamp():String {
        return (new Date()).time.toString();
    }
}
