/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9Fx1
 */

package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
 
	public class Main extends Sprite
	{
		private var charaChip:BitmapData;
		private const C_WIDTH:int = 32;
		private const C_HEIGHT:int = 48;
 
		private var frame:int = 0;
		private var cx:int = 1;
		private var cy:int = 0;
		private var prevcy:int = 0;
		private var chara:BitmapData;
 
		private var left:Boolean = false;
		private var right:Boolean = false;
		private var top:Boolean = false;
		private var bottom:Boolean = false;
		private var player:Bitmap;
 
		private const SPEED:int = 4;
		private var isMoving:Boolean = false;
		private var vx:int = 0;
		private var vy:int = 0;
		private const CHIPSIZE:int = 32;
 
		public function Main()
		{
			var loader:Loader = new Loader();
			loader.contentLoaderInfo.addEventListener(Event.INIT, initHandler);
			loader.load(new URLRequest("http://assets.wonderfl.net/images/related_images/3/33/3384/3384200b2dc435c82a6c311375c2e26b81bc80e2"), new LoaderContext(true));
		}
 
		private function initHandler(event:Event):void
		{
			for (var y:int = 0; y < Map.height; y++)
			{
				for (var x:int = 0; x < Map.width; x++)
				{
					if (Map.data[y][x]) graphics.beginFill(0x0);
					else graphics.lineStyle(2.0);
 
					graphics.drawRect(x * CHIPSIZE, y * CHIPSIZE, CHIPSIZE, CHIPSIZE);
					graphics.endFill();
				}
			}
 
			var loader:Loader = event.currentTarget.loader;
			charaChip = new BitmapData(loader.width, loader.height, true, 0x0);
			charaChip.draw(loader);
			charaChip.threshold(charaChip, charaChip.rect, new Point(), "==", 0x78c380, 0x0, 0xFFFFFF);
 
			chara = new BitmapData(C_WIDTH, C_HEIGHT, true, 0x0);
			player = new Bitmap(chara);
			addChild(player);
 
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
			stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
		}
 
		private function onEnterFrame(event:Event = null):void
		{
			if (isMoving)
			{
				player.x += vx;
				player.y += vy;
 
				if ((vx && player.x % CHIPSIZE == 0) || (vy && player.y % CHIPSIZE == 0))
				{
					isMoving = false;
					if (!left && !right && !top && !bottom) cx = 1;
				}
			}
			else
			{
				vx = vy = 0;
 
				if (left) vx = -SPEED, cy = 1;
				else if (right) vx = SPEED, cy = 2;
				else if (top) vy = -SPEED, cy = 3;
				else if (bottom) vy = SPEED, cy = 0;
 
				if (vx || vy)
				{
					var px:int = player.x / CHIPSIZE;
					var py:int = player.y / CHIPSIZE;
					py += vy / SPEED;
					px += vx / SPEED;
					if (0 <= py && py < Map.height &&
						0 <= px && px < Map.width  &&
						Map.data[py][px] == 0)
					{
						isMoving = true;
						onEnterFrame();
					}
				}
			}
 
			if (prevcy != cy || frame++ % 5 == 0)
			{
				chara.copyPixels(charaChip, new Rectangle(C_WIDTH * (cx + 6), C_HEIGHT * cy, C_WIDTH, C_HEIGHT), new Point());
				if (isMoving) cx = (cx + 1) % 3;
				prevcy = cy;
			}
		}
 
		private function onKeyDown(event:KeyboardEvent):void
		{
			if (event.keyCode == 37) left = true;
			if (event.keyCode == 39) right = true;
			if (event.keyCode == 38) top = true;
			if (event.keyCode == 40) bottom = true;
		}
 
		private function onKeyUp(event:KeyboardEvent):void
		{
			if (event.keyCode == 37) left = false;
			if (event.keyCode == 39) right = false;
			if (event.keyCode == 38) top = false;
			if (event.keyCode == 40) bottom = false;
		}
	}
}
 
class Map
{
	public static var width:int = 5;
	public static var height:int = 5;
 
	public static var data:Array = 
	[
		[0, 0, 0, 0, 0],
		[0, 1, 1, 1, 0],
		[0, 0, 0, 1, 0],
		[0, 0, 0, 1, 0],
		[0, 0, 0, 0, 0]
	];
}
