/**
 * Copyright paq ( http://wonderfl.net/user/paq )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9Fu7
 */

package
{
	import com.actionsnippet.qbox.QuickBox2D;
	
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	
	[SWF(width = 465, height = 465, frameRate = 60)]
	public class ConnectTheDots extends MovieClip
	{
		private var qbox:QuickBox2D;
		private var circles:Array;
		private var softbody:SoftBody;
		
		public function ConnectTheDots()
		{
			// init

			// quickbox2d			
			qbox = new QuickBox2D(this);
			qbox.setDefault({fillAlpha:0, lineAlpha:0});
			qbox.createStageWalls();
			qbox.setDefault({fillAlpha:0, lineColor:0});
			qbox.mouseDrag();
			qbox.start();
			
			softbody = new SoftBody(qbox, { x:7, y:7, lineAlpha:0, fillColor:0xFFFFFF * Math.random(), radius:4 } );
			addChild(softbody);
			
			addEventListener(Event.ENTER_FRAME, onLoop);
		}
		
		// private methods
		private function onLoop(evt:Event):void
		{
			softbody.update();
		}
	}
}

import Box2D.Common.Math.b2Vec2;

import com.actionsnippet.qbox.QuickBox2D;
import com.actionsnippet.qbox.QuickObject;
import com.actionsnippet.qbox.objects.CircleObject;

import flash.display.Sprite;

class Anchor extends CircleObject
{
	private var vx:Number = 0;
	private var vy:Number = 0;
	private var spring:Number = 2;
	private var friction:Number = 0.1;
	private var vec:b2Vec2;
	public var target:QuickObject;
	private var rot:Number;
	
	public function Anchor(qbox:QuickBox2D, params:Object, target:QuickObject = null, rot:Number = 0)
	{
		super(qbox, params);
		this.target = target;
		this.rot = rot;
		vec = new b2Vec2();
	}
	
	public function update():void
	{
		if (!target) return;
		var targetPos:b2Vec2 = target.body.GetPosition();
		var thisPos:b2Vec2 = body.GetPosition();
		var dx:Number = Math.sin(rot * Math.PI / 180)*2 + targetPos.x - thisPos.x;
		var dy:Number = Math.cos(rot * Math.PI / 180)*2 + targetPos.y - thisPos.y;
		var ax:Number = dx * spring;
		var ay:Number = dy * spring;
		vx += ax;
		vy += ay;
		vec.x = vx;
		vec.y = vy;
		body.ApplyForce(vec, thisPos);
		vx *= friction;
		vy *= friction;
	}
}

class SoftBody extends Sprite
{
	public var params:Object;
	private var _anchor:/*Anchor*/Array = [];
	private var qbox:QuickBox2D;
	
	public function SoftBody(qbox:QuickBox2D, params:Object)
	{
		this.params = params;
		this.qbox = qbox;
		if (this.params.lineColor == null) this.params.lineColor = 1;
		if (this.params.lineAlpha == null) this.params.lineAlpha = 1;
		if (this.params.fillColor == null) this.params.fillColor = 0;
		if (this.params.fillAlpha == null) this.params.fillAlpha = 1;
		if (this.params.radius == null) this.params.radius = 1;
		
		create();
	}
	
	private function create():void
	{
		var rot:Number = 0;
		for (var i:int = 0; i < 16; i++) 
		{
			rot+=22.5;
			_anchor[i] = new Anchor(qbox, { x:Math.sin(rot * Math.PI / 180) * params.radius + params.x, y:Math.cos(rot * Math.PI / 180) * params.radius + params.y, radius:0.1 }, _anchor[i - 1], rot);
			_anchor[i].shape.m_radius = 0.1 * params.radius;
			if (i != 0) qbox.addJoint( { type:QuickBox2D.DISTANCE, a:_anchor[i-1].body, b:_anchor[i].body } );
		}
		
		qbox.addJoint( { type:QuickBox2D.DISTANCE, a:_anchor[0].body, b:_anchor[_anchor.length-1].body } );
	}
	
	public function update():void 
	{
		// render
		graphics.clear();
		graphics.lineStyle(0,0);
		var len:uint = _anchor.length;
		for (var i:int = 0; i < len; i++)
		{
			var a:Anchor = _anchor[i];
			a.update();
			for (var j:int = i+1; j < len; j++)
			{
				var b:Anchor = _anchor[j];
				
//				graphics.drawCircle(a.x*30, a.y*30, 10);
				graphics.moveTo(a.x*30, a.y*30);
				graphics.lineTo(b.x*30, b.y*30);
			}
		}
//		graphics.drawCircle(a.x*30, a.y*30, 10);
	}
}