/**
 * Copyright Fake ( http://wonderfl.net/user/Fake )
 * GNU General Public License, v3 ( http://www.gnu.org/licenses/quick-guide-gplv3.html )
 * Downloaded from: http://wonderfl.net/c/9Erb
 */

/*
FlashPlayer10.1から追加された、RTMFPのピアアシストネットワークを使用して、
P2Pクラスタを構成して共有ホワイトボード
Stratus(Cirrus)への接続は私のものを使用していますので、forkされる場合は各自変更お願いします。
既にホワイトボードにデータがある場合、P2Pでデータを取得するので、結構時間がかかります。
全員がネットワークから切断した時に、ホワイトボードのデータはクリアされます。
誰か一人でも残っていると、データがずっと残ります。
NetGroup.postは、データの配信が保証されないようなので、情報の伝達に齟齬が生じる可能性があります。
*/

package {
    import flash.display.Shape;
    import flash.events.NetStatusEvent;
    import flash.net.*;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextField;

    public class NetCanvas extends Sprite {
        private var debugout:TextField;
        private var ar:Array;
        private var logar:Array;
        private var gs:GroupSpecifier;
        private var nc:NetConnection;
        private var group:NetGroup;
        private var reqflg:Boolean;
        
        private var NETCANVAS_CMD_1LINE:String = "1line";

        public function NetCanvas() {
            // init debugout
            debugout = new TextField();
            debugout.x = 50;
            debugout.y = 50;
            debugout.autoSize = TextFieldAutoSize.LEFT;
            debugout.background = true;
            debugout.border = true;
            debugout.backgroundColor = 0x000000;
            debugout.textColor = 0x0000FF;
//            addChild(debugout);
            // init rtmfp group spec
            gs = new GroupSpecifier("net.wonderfl.fake.netcanvas.test");
            gs.postingEnabled = true;
            gs.ipMulticastMemberUpdatesEnabled = true;
            gs.multicastEnabled = true;
            gs.objectReplicationEnabled = true;
            gs.routingEnabled = true;
            gs.serverChannelEnabled = true;
            // init rtmfp connection
            nc = new NetConnection();
            nc.addEventListener(NetStatusEvent.NET_STATUS, procNetStatus);
            nc.connect("rtmfp://p2p.rtmfp.net/445d9931dfac67103408ae5f-ad98e28e2386/");
            
            logar = new Array();
            reqflg = false;
        }
        
        private function initCanvas():void {
            // init canvas
            graphics.beginFill(0xFFFFFF);
            graphics.drawRect(0, 0, stage.x, stage.y);
            graphics.endFill();
            graphics.lineStyle(2, 0x000000);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
            stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
        }
        
        private function onMouseDown(e:MouseEvent):void {
            ar = new Array();
            ar.push(e.stageX);
            ar.push(e.stageY);
            graphics.moveTo(e.stageX, e.stageY);
        }
        private function onMouseMove(e:MouseEvent):void {
            if (e.buttonDown) {
                ar.push(e.stageX);
                ar.push(e.stageY);
                graphics.lineTo(e.stageX, e.stageY);
            }
        }
        private function onMouseUp(e:MouseEvent):void {
            group.post({cmd: NETCANVAS_CMD_1LINE, msg: ar});
            logar.push(ar);
            ar = null;
            if (!reqflg) {
                group.addHaveObjects(0, 0);
            }
        }
        
        private function procNetStatus(e:NetStatusEvent):void {
//            debugout.appendText(e.info.code + "\n");
            var i:int;
            var j:int;
            switch (e.info.code) {
                case "NetConnection.Connect.Success":
                    group = new NetGroup(nc, gs.groupspecWithAuthorizations());
                    group.addEventListener(NetStatusEvent.NET_STATUS, procNetStatus);
                    break;
                case "NetGroup.Connect.Success":
                    initCanvas();
                    break;
                case "NetGroup.Neighbor.Connect":
                    if (logar.length == 0) {
                        reqflg = true;
                        group.addWantObjects(0, 0);
                    }
                    break;
                case "NetGroup.Posting.Notify":
                    var obj:Object = e.info.message;
                    var ar1:Array = obj.msg;
                    var cmd:String = obj.cmd;
                    logar.push(ar1);
                    group.addHaveObjects(0, 0);
                    if (cmd == NETCANVAS_CMD_1LINE) {
                        var shape:Shape = new Shape();
                        shape.graphics.lineStyle(2, 0x000000);
                        shape.graphics.moveTo(ar1[0], ar1[1]);
                        for (j = 2; j < ar1.length; j += 2) {
                            shape.graphics.lineTo(ar1[j], ar1[j+1]);
                        }
                        addChild(shape);
                    }
                    break;
                case "NetGroup.Replication.Request":
                    if (e.info.index == 0) {
                        group.writeRequestedObject(e.info.requestID, {log: logar});
                    }
                    break;
                case "NetGroup.Replication.Fetch.Result":
                    if (e.info.index == 0) {
                        reqflg = false;
                        logar = e.info.object.log;
                        group.addHaveObjects(0, 0);
                        var shape0:Shape = new Shape();
                        shape0.graphics.lineStyle(2, 0x000000);
                        for (i = 0; i < logar.length; ++i) {
                            var ar:Array = logar[i];
                            shape0.graphics.moveTo(ar[0], ar[1]);
                            for (j = 2; j < ar.length; j += 2) {
                                shape0.graphics.lineTo(ar[j], ar[j+1]);
                            }
                        }
                        addChild(shape0);
                    }
                    break;
            }
        }
    }
}