/**
 * Copyright civet ( http://wonderfl.net/user/civet )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9ESp
 */

// forked from civet's Fall Slasher
// 2010-04-24 22:30:38
package {
    import flash.display.*;
    import flash.events.*;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.Quad;
    import org.libspark.betweenas3.events.TweenEvent;
    import org.libspark.betweenas3.tweens.ITween;
    import org.libspark.betweenas3.tweens.ITweenGroup;
        
    public class Main extends Sprite
    {
            private var numSwords:int = 16;
            private var swords:Vector.<Sword>;
            private var tweens:ITweenGroup;
        
        public function Main() {
                stage.scaleMode = StageScaleMode.NO_SCALE;
                stage.align = StageAlign.TOP_LEFT;
            
            var bg:Shape = new Shape();
            bg.graphics.beginFill(0);
            bg.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            bg.graphics.endFill();
            this.addChild(bg);
            init();
        }
        
        private function init():void
        {
                swords = new Vector.<Sword>();
               stage.addEventListener(MouseEvent.CLICK, onClick);
        }
        
        private function shoot(mx:Number, my:Number):void
           {
               var groups1:Array = [];
               var groups0:Array = [];
               
               var len:int = numSwords;
               var i:int = numSwords * Math.random();
               for(; i < len; ++i)
               {
                   var sword:Sword = getSword();
                   sword.addEventListener(Event.REMOVED, onSwordRemoved);
                   
                   sword.x = mx + 100 * Math.cos(360/numSwords * Math.PI/180 * i);
                    sword.y = my + 100 * Math.sin(360/numSwords * Math.PI/180 * i);
                   sword.rotation = Math.atan2(my - sword.y, mx - sword.x) * 180 / Math.PI - 90;
                   
                   var ox:Number = sword.x;
                   var oy:Number = sword.y;
                    var a:Number = sword.rotation + 90;
                    
                    var group1:ITweenGroup = BetweenAS3.serial(
                    BetweenAS3.to(sword, {x: ox + Math.cos(a * Math.PI/180) * 400, y: oy + Math.sin(a * Math.PI/180) * 400}, 1.5),
                    BetweenAS3.removeFromParent(sword)
                );
                groups1.push(group1);
                
                var group0:ITweenGroup = BetweenAS3.serial(
                    BetweenAS3.addChild(sword, this),
                    BetweenAS3.tween(sword, {alpha: 1}, {alpha: 0}, 0.1)
                );
                groups0.push(group0);
               }
               
               var tween0:ITweenGroup = BetweenAS3.serialTweens(groups0);
               var tween1:ITweenGroup = BetweenAS3.parallelTweens(groups1);
               tweens = BetweenAS3.serial(tween0, tween1);
               tweens.play();
           }
        
        private function onClick(e:Event):void
        {
                shoot(mouseX, mouseY);
            }
            
            private function onSwordRemoved(e:Event):void
            {
                var s:Sword = e.currentTarget as Sword;
                s.removeEventListener(Event.REMOVED, onSwordRemoved);
                swords.push(s);
            }
                           
            private function getSword():Sword
            {
                if(swords.length > 0) return swords.pop();
                return new Sword();
            }
    }
}


//Sword from: http://wonderfl.net/c/tk1s by:夏天的树人
import flash.display.Sprite;
import flash.display.Graphics;

class Sword extends Sprite
{
    private var pen:Graphics;
    private var array:Array=[ [55,0],
        [55,45],
        [30,50],
        [30,60],
        [50,60],
        [50,120],
        [60,180],
        [70,120],
        [70,60],
        [90,60],
        [90,50],
        [65,45],
        [65,0],
        [55,0]
    ];
    public function Sword()
    {
        pen = this.graphics;
        pen.moveTo(array[0][0]-60, array[0][1]-50);
        pen.beginFill(0xffffff);
        var len:int = array.length;
        for (var i:int=0; i<len; i++)
        {
            pen.lineTo(array[i][0]-60, array[i][1]-50);
        }
        pen.endFill();
        
        pen.beginFill(0xffffff);
        pen.drawCircle(0, -50, 9);
        pen.endFill();
        
        this.scaleX = this.scaleY = 0.3;
    }
}