/**
 * Copyright 178ep3 ( http://wonderfl.net/user/178ep3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9DAH
 */

package
{
	import flash.display.BlendMode;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.TimerEvent;
	import flash.filters.BlurFilter;
	import flash.utils.Timer;

	public class Drop extends Sprite
	{
		private var _list:Array = [];
		private var _top:Shape;
		private var _stg:Sprite;
		
		public function Drop()
		{
                        this.graphics.beginFill(0x000000);
                        this.graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);
                        this.graphics.endFill();
			init();
			
			var timer:Timer = new Timer(250);
			timer.addEventListener(TimerEvent.TIMER,create);
			timer.start();
			
			addEventListener(Event.ENTER_FRAME,loop);
		}
		
		private function init():void
		{
			
			_stg = addChild(new Sprite()) as Sprite;
			_stg.filters = [new BlurFilter(20,20,2)];
			
			_top = _stg.addChild(new Shape()) as Shape;
			with(_top.graphics)
			{
				beginFill(0xffffff);
				drawRect(-40,-20,stage.stageWidth+80,80);
				endFill();
			}
			_top.blendMode = BlendMode.ADD;
			
			
			var _btm:Shape = _stg.addChild(new Shape()) as Shape;
			_btm.y = stage.stageHeight-40;
			with(_btm.graphics)
			{
				beginFill(0xffffff);
				drawRect(-40,0,stage.stageWidth+80,50);
				endFill();
			}
			_btm.blendMode = BlendMode.ADD;
		}
		
		private function create(e:TimerEvent):void
		{
			var o:One = new One(stage);
			_stg.addChild(o);
			_list.push(o);
		}
		
		private function loop(e:Event):void
		{
			var len:uint = _list.length-1;
			for(var i:int = len; i>-1; i--)
			{
				if(!_list[i].Move())
				{
					_stg.removeChild(_list[i]);
					_list[i] = null; 
                    _list.splice(i, 1);
				}
			}
		}
	}
}
	import flash.display.Shape;
	import flash.display.Stage;
	import flash.display.BlendMode;
	

class One extends Shape
{
	private var _stage:Stage;
	private var _grav:Number = 0.1;
	private var _x:uint = Math.random()*20+10;
	private var _y:uint = _x * (Math.random()*0.5+1);
	
	public function One(stg:Stage)
	{
		_stage = stg;
		this.graphics.beginFill(0xffffff);
		this.graphics.drawEllipse(-_x,-_y,_x*2,_y*2);
		this.graphics.endFill();
		
		this.blendMode = BlendMode.ADD;
		this.x = _stage.stageWidth * Math.random();
		this.y = Math.random() * 30;
	}
	
	public function Move():Boolean
	{
		this.y += _grav;

		if(this.y<50+this.height/2)_grav *= 1.01;
		else if(this.y>_stage.stageHeight-65)_grav = 2;
		else  _grav +=3;
		
		if(this.y > _stage.stageHeight + this.width)return false;
		
		return true;
	}
}
