/**
 * Copyright madflash ( http://wonderfl.net/user/madflash )
 * GNU General Public License, v3 ( http://www.gnu.org/licenses/quick-guide-gplv3.html )
 * Downloaded from: http://wonderfl.net/c/9D83
 */

/*
    created by madflash
    特徴：
    getter/setterを活用し、どの変数を更新しても全体が連動して更新される。
    つまり一度Dateでの初期化を行えば、あとは自由な基準とタイミングでの更新が可能になる。
    init()を呼び出す事で、任意のタイミングでのリセットも可能。
*/

package {
    import flash.display.Sprite;
    public class InlineUpdate extends Sprite {
        /* properties */
        private static var _year:uint=0;
        private static var _month:uint=0;
        private static var _day:uint=0;
        private static var _hour:uint=0;
        private static var _minute:uint=0;
        private static var _second:uint=0;
        
        /* optional */
        private static var _daymax:uint=0;
        
        /* capsule logics */
        public function set year(val:uint):void{ _year=val };
        public function get year():uint{ return _year };
        public function set month(val:uint):void{ if(val>12){val=1;year++;_daymaxUpdate();}_month=val };
        public function get month():uint{ return _month };
        public function set day(val:uint):void{ if(val>_daymax){val=(val-_daymax);month++;}_day=val };
        public function get day():uint{ return _day };
        public function set hour(val:uint):void{ if(val>24){val=(val%24);day++;}_hour=val };
        public function get hour():uint{ return _hour };
        public function set minute(val:uint):void{ if(val>60){val=(val%60);hour++;}_minute=val };
        public function get minute():uint{ return _minute };
        public function set second(val:uint):void{ if(val>60){val=(val%60);minute++;}_second=val };
        public function get second():uint{ return _second };
        
        /* tracer */
        private var trace:Tracer = new Tracer();
        
        /* constructor */
        public function InlineUpdate() {
            // init
            init();
            // tracer standby
            trace.property( { x:20, y:20 } );
            trace.isDevelop = true; 
            addChild( trace.create );
            // test
            trace.push(month);
            trace.show();
        }
        //init
        public function init():void {
            var date:Date = new Date();
            year = date.fullYear;
            month = date.month;
            day = date.day;
            hour = date.hours;
            minute = date.minutes;
            second = date.milliseconds;
        }
        //setting maxday
        private function _daymaxUpdate():void {
            //未実装、そのうち。
        }
    }
}


/* Tracer */
import flash.system.IME;
import flash.display.*;
import flash.text.*;

class Tracer extends Sprite
{
    public var format:TextFormat;
    public var txt:TextField;
    private static const NEWLINE:String = "\n";
    private var _log:String = "";
    private var _isDev:Boolean = false;
    
    public function get create() :TextField { return txt }; //getter
    public function get log() :String { return _log };
    public function get isDevelop() :Boolean { return _isDev };
    public function set isDevelop(bool:Boolean) :void { _isDev = bool };
    
    public function Tracer(format_:TextFormat = null)
    {
        format = new TextFormat();
        txt = new TextField();
        //format
        var ref:* = (format_) ? format_ : {color:0x000000, size:12, font:'MS Gothic'};
        PropertyScan( format, ref );
        //prop
        var prop:Object = { x:0, y:0, autoSize:TextFieldAutoSize.LEFT };
        PropertyScan( txt, prop );
        //format done
        txt.defaultTextFormat = format;
    }
    // function has 4 params. implement dynamic param nomber.
    // x, y, width, height or Object/Array
    public function property(...args):void
    {
        const properties:Array = new Array('x','y','width','height');
        var isArray:Boolean = (args[0] is Array) ? true : false;
        var params:* = isArray ? args[0] : args;
        var Q:uint = params.length; //Queue
        
        if (isArray || (Q<=4 && !(params is Object)) ) for (var i:uint=0; i<Q; i++) txt[properties[i]] = params[i];
        else PropertyScan(txt, args[0]);
    }
    public function push(...args) :void { _log += Roller(args) + NEWLINE };
    public function show() :void { txt.htmlText = _log };
    public function dev(...args) :void
    {
        if (_isDev) _log += ("<b><font color='#ff0000'>" + Roller(args) + "</font></b>" + NEWLINE) ;
    }
    /* static functions, logic designed by madflash */
    private static function Roller(...args) :String
    {
        var str:String = "";
        if ( args.length <= 1 ) str += String(args);
        else for each(var e:Object in args){str += (String(e) + " ")};
        
        return str;
    }
    private static function PropertyScan(target:*, ref:*) :void
    {
        if (target is Object && ref is Object)
            for(var key:String in ref) target[key] = ref[key];   
    }
}