/**
 * Copyright siouxcitizen ( http://wonderfl.net/user/siouxcitizen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9Ce9h
 */

// forked from siouxcitizen's 前回ソースの散る葉をサクラから楓＆紅葉に変更してみました
//
//前回ソースから少々エディターっぽくできないか試してみました
//
//「リセット」ボタンで床を初期化(全ての床を緑色の床に戻します)
//「楓・紅葉」ボタンで降り注ぐ楓・紅葉にみたてた3DPlaneが落ちてきます
//「月夜」ボタンでバックグラウンド黒と3D月の表示で夜を表現します
//「ライトアップ」ボタンでBlurFilter効果ピクセルによるライトアップ効果を設定します
//「エディット」ボタンで3DPlaneフィールド上に貼り付ける「地面」と「木」を選択できます
//
//エディット画面でのカメラ視点移動
//Wボタンでカメラ視点上移動
//Sボタンでカメラ視点下移動
//Aボタンでカメラ視点が操作矢印を中心に左周り
//Dボタンでカメラ視点が操作矢印を中心に右周り
//Fボタンでカメラ距離変更
//タイトル画面に一度戻ってからエディット画面再表示で操作矢印とカメラ視点を初期化
//
//
//自分作成の以下のコードからいろいろ使いまわしました
//
//Winter05 少々エディターっぽくできないか試してみました
//http://wonderfl.net/c/hDkl
//前回ソースからキャプチャ機能つけてエディターっぽいものに戻しました
//http://wonderfl.net/c/tbWc
//
package {
    import flash.display.*;
    import flash.events.*;
    import flash.text.*;
    import flash.filters.GlowFilter;
    import flash.filters.BlurFilter;
    import flash.display.Loader;
    import flash.system.LoaderContext;
    import flash.net.URLRequest;

    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.objects.primitives.Arrow;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.objects.primitives.Cylinder;
    import org.papervision3d.objects.primitives.Cone;
    import org.papervision3d.objects.primitives.Sphere;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.materials.WireframeMaterial;
    import org.papervision3d.materials.BitmapMaterial;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.events.InteractiveScene3DEvent;

    import org.papervision3d.materials.special.Letter3DMaterial;
    import org.papervision3d.typography.Text3D;
    import org.papervision3d.typography.fonts.HelveticaBold;

    import org.papervision3d.core.effects.BitmapLayerEffect;
    import org.papervision3d.core.effects.utils.BitmapClearMode;
    import org.papervision3d.core.geom.Pixels;
    import org.papervision3d.core.geom.renderables.Pixel3D;
    import org.papervision3d.view.layer.BitmapEffectLayer;
    [SWF(width="500", height="500", backgroundColor="#0055FF")]
    public class Autumn extends Sprite {
        private var goLandScrnBtn : SimpleButton;//エディット画面への遷移ボタン 

        private var resetBtn : SimpleButton;//リセットボタン
        private var fallBtn : SimpleButton;//「楓・紅葉」ボタン
        private var fallState : Boolean = false; //「楓・紅葉」ボタン状態管理用
        private var nightBtn : SimpleButton;//「月夜」ボタン
        private var nightState : Boolean = false; //「月夜」ボタン状態管理用
        private var lightUpBtn : SimpleButton;//「ライトアップ」ボタン
        private var lightUpState : Boolean = false; //「ライトアップ」ボタン状態管理用
        private var editBtn : SimpleButton;//「エディット」ボタン
        private var editState : Boolean = false; //「エディット」ボタン状態管理用
        private var goTitleScrnBtn : SimpleButton;//タイトル画面への遷移ボタン
        private var forwardBtn : SimpleButton;//前進ボタン
        private var leftRotBtn : SimpleButton;//左回転ボタン
        private var rightRotBtn : SimpleButton;//右回転ボタン
        private var backwardBtn : SimpleButton;//後退ボタン
        private var bDashBtn : SimpleButton;//Bダッシュボタン
        private var forwardState : Boolean = false; //操作矢印「前進」制御用
        private var backwardState : Boolean = false; //操作矢印「後退」制御用
        private var bDashState : Boolean = false; //操作矢印「Bダッシュ」制御用
        private var leftRotState : Boolean = false; //操作矢印「左回転」制御用
        private var rightRotState : Boolean = false; //操作矢印「右回転」制御用

        private var txtField:Object=new Object(); //テキストフィールド用
        private var txtFormat:Object=new Object();//テキストフォーマット用

        private var screenId : int = 0;  //0:クエスト画面 1:エディット画面
        private const TITLE_SCREEN_ID : int = 0;  //クエスト画面ID
        private const LAND_SCREEN_ID : int = 1;  //エディット画面ID

        //3D表示用
        private var container : Sprite;
        private var viewport : Viewport3D;
        private var scene : Scene3D;
        private var camera : Camera3D;
        private var material : ColorMaterial;
        private var planeObj : Plane; 
        private var arrow : Arrow //操作用オブジェクト
        private var crystalBoxCube : Cube //透明キューブ　飾り用クリスタル役
        private var moonSphere : Sphere //月スフェア
        private var renderer : BasicRenderEngine;
        private var materialList : MaterialsList = new MaterialsList();

        private var cameraPitch: int = 90; //カメラのX軸回転の値　
        private var cameraYaw : int = 270; //カメラのY軸回転の値　
        private var cameraDistStat: int = 1; //カメラ設置場所の距離種類　0～2

        private var title3DText : Text3D //タイトル3D文字
        private var letterformat : Letter3DMaterial; //タイトル3D文字フォーマット
        private var tempPlaneName : String;
        private var Objs : Object = new Object(); //3Dオブジェクト保持用

        private var filterList : Array;
        private var pixels : Pixels;

        private var greenGroundBtn : SimpleButton;//緑色地面ボタン
        private var yellowGroundBtn : SimpleButton;//黄色地面ボタン
        private var redGroundBtn : SimpleButton;//赤色地面ボタン
        private var greenGroundAndGreenTreeBtn : SimpleButton;//緑地＋木ボタン
        private var yellowGroundAndGreenTreeBtn : SimpleButton;//黄地＋木ボタン
        private var redGroundAndGreenTreeBtn : SimpleButton;//赤地＋木ボタン
        private var greenGroundAndYellowTreeBtn : SimpleButton;//緑地＋黄木ボタン
        private var yellowGroundAndYellowTreeBtn : SimpleButton;//黄地＋黄木ボタン
        private var redGroundAndYellowTreeBtn : SimpleButton;//赤地＋黄木ボタン
        private var greenGroundAndRedTreeBtn : SimpleButton;//緑地＋赤木ボタン
        private var yellowGroundAndRedTreeBtn : SimpleButton;//黄地＋赤木ボタン
        private var redGroundAndRedTreeBtn : SimpleButton;//赤地＋赤木ボタン
        private var quitEditBtn : SimpleButton;//エディットコマンド終了ボタン
        private var editCommandPanelContena : Sprite = new Sprite(); //「エディット」コマンド用パネル入れ物
        private var editCommandPanel : Shape = new Shape(); //「エディット」コマンド用テキスト
        private var plane3DFieldType : int = 1; //3DPlaneによるフィールドタイプを設定
        private const GREEN_GROUND : int = 0;  //フィールドタイプ0　「緑色地面」
        private const YELLOW_GROUND : int = 1;  //フィールドタイプ1　「黄色地面」
        private const RED_GROUND : int = 2;  //フィールドタイプ2　「赤色地面」
        private const GREEN_GROUND_AND_GREEN_TREE : int = 3;  //フィールドタイプ3　「緑色地面＋緑色木」
        private const YELLOW_GROUND_AND_GREEN_TREE : int = 4;  //フィールドタイプ4　「黄色地面＋緑色木」
        private const RED_GROUND_AND_GREEN_TREE : int = 5;  //フィールドタイプ5　「赤色地面＋緑色木」
        private const GREEN_GROUND_AND_YELLOW_TREE : int = 6;  //フィールドタイプ6　「緑色地面＋黄色木」
        private const YELLOW_GROUND_AND_YELLOW_TREE : int = 7;  //フィールドタイプ7　「黄色地面＋黄色木」
        private const RED_GROUND_AND_YELLOW_TREE : int = 8;  //フィールドタイプ8　「赤色地面＋黄色木」
        private const GREEN_GROUND_AND_RED_TREE : int = 9;  //フィールドタイプ9　「緑色地面＋赤色木」
        private const YELLOW_GROUND_AND_RED_TREE : int = 10;  //フィールドタイプ10　「黄色地面＋赤色木」
        private const RED_GROUND_AND_RED_TREE : int = 11;  //フィールドタイプ11　「赤色地面＋赤色木」

        private var loader : Loader;
        private var bmp : Bitmap;
        private var bmd : BitmapData;
        private var imgLoadingCount : int = 0;    //読み込んだ画像数
        private var images : Array;    // 読み込んだBitmap画像保持用配列
        private const IMAGE_URL:Array =
        [
            "http://assets.wonderfl.net/images/related_images/2/2b/2b27/2b2786cdf19f4c69bf6ab81fe1f2b144eab834f7", //furl
            "http://assets.wonderfl.net/images/related_images/e/e5/e541/e54190ff73f718a4fac555ddde64b0d7fcf396c0"  //burl
        ]; //Bitmap画像URL配列
        private var imgLoadingState : Boolean = false; //イメージ読み込み判定用
        private var pixelArr        :Array  = [];     // パーティクルを格納する配列
        private const PIXEL_NUM : int = 5;     // 縦・横のピクセル数
        private const PLANE_SIZE : int = 200;//Planeオブジェクト1辺の長さ
        private const PLANE_SEGMENT   : int = 1;  //面の分割数
        private var leafTempName : String = "";

        public function Autumn() {
            //情報表示用テキストフィールドを初期化
            txtFieldInit();

            //3D空間を初期化
            init3DSpace();

            //タイトル画面を初期化
            initTitleScrnBtn();
            //エディット画面を初期化
            initLandScrnBtn();

            //ふきだしを初期化
            initFukidashi();
        }

        //テキストフィールドの初期化処理
        private function txtFieldInit():void{
            //テキストフィールド(ラベル)の生成
            txtField["titleScrnInfo"]=Util.makeTxtField(10,10,10,10);//タイトル画面表示用のテキストを設定
            txtField["landScrnInfo"]=Util.makeTxtField(10,10,300,40);//エディット画面表示用のテキストを設定
            txtField["editStatusInfo"]=Util.makeTxtField(10,130,390,30);//「エディット」パネル用のテキストを設定
            //テキストフォーマットの生成
            txtFormat["titleScrnInfo"]=Util.makeTextFormat(15,0x000000);
            txtFormat["landScrnInfo"]=Util.makeTextFormat(15,0x000000);
            txtFormat["editStatusInfo"]=Util.makeTextFormat(15,0xEEEEEE);
        }
        //テキストフィールドの編集
        private function editLabel(key:String,text:String):void {
            txtField[key].text=text;
            txtField[key].setTextFormat(txtFormat[key]);        
        }

        //タイトル画面情報テキストを設定
        public function addTitleScrnTxt():void {
            addChild(txtField["titleScrnInfo"]); //タイトル画面のテキストを表示(今回は使用せず)
            var titleScrnInfoTxt : String = "Now Loading..." + "\n";
            editLabel("titleScrnInfo", titleScrnInfoTxt);
        }
        //タイトル画面情報テキストを設定解除
        public function removeTitleScrnTxt():void {
            editLabel("titleScrnInfo", "");
            removeChild(txtField["titleScrnInfo"]); //タイトル画面のテキストを非表示(今回は使用せず)
        }
        //エディット画面情報テキストを設定
        private function addLandScrnTxt():void {
            addChild(txtField["landScrnInfo"]);
            var landScrnInfoTxt : String = "エディット選択後床クリックでフィールド変化" + "\n"
                                         + "A,W,S,D,Fボタンで視点変更します" + "\n";
            editLabel("landScrnInfo",landScrnInfoTxt);
        }
        //エディット画面情報テキストを設定解除
        private function removeLandScrnTxt():void {
            editLabel("landScrnInfo", "");
            removeChild(txtField["landScrnInfo"]);
        }
//■■■ふきだし初期化スタート■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
        //ふきだしを初期化設定
        private function initFukidashi():void {
            //「緑色地面」ボタン
            greenGroundBtn = new CustomButton("緑色地面",GREEN_GROUND);
            greenGroundBtn.addEventListener(MouseEvent.CLICK,onGroundSelectionBtnDown);
            greenGroundBtn.addEventListener(MouseEvent.MOUSE_OVER,overGroundSelectionBtn);
            greenGroundBtn.x = 10;
            greenGroundBtn.y = 15;
            //「黄色地面」ボタン
            yellowGroundBtn = new CustomButton("黄色地面",YELLOW_GROUND);
            yellowGroundBtn.addEventListener(MouseEvent.CLICK,onGroundSelectionBtnDown);
            yellowGroundBtn.addEventListener(MouseEvent.MOUSE_OVER,overGroundSelectionBtn);
            yellowGroundBtn.x = 10;
            yellowGroundBtn.y = 45;
            //「赤色地面」ボタン
            redGroundBtn = new CustomButton("赤色地面",RED_GROUND);
            redGroundBtn.addEventListener(MouseEvent.CLICK,onGroundSelectionBtnDown);
            redGroundBtn.addEventListener(MouseEvent.MOUSE_OVER,overGroundSelectionBtn);
            redGroundBtn.x = 10;
            redGroundBtn.y = 75;

            //「緑色地面&木」ボタン
            greenGroundAndGreenTreeBtn = new CustomButton("緑地&木",GREEN_GROUND_AND_GREEN_TREE);
            greenGroundAndGreenTreeBtn.addEventListener(MouseEvent.CLICK,onGroundSelectionBtnDown);
            greenGroundAndGreenTreeBtn.addEventListener(MouseEvent.MOUSE_OVER,overGroundSelectionBtn);
            greenGroundAndGreenTreeBtn.x = 120;
            greenGroundAndGreenTreeBtn.y = 15;
            //「黄色地面&木」ボタン
            yellowGroundAndGreenTreeBtn = new CustomButton("黄地&木",YELLOW_GROUND_AND_GREEN_TREE);
            yellowGroundAndGreenTreeBtn.addEventListener(MouseEvent.CLICK,onGroundSelectionBtnDown);
            yellowGroundAndGreenTreeBtn.addEventListener(MouseEvent.MOUSE_OVER,overGroundSelectionBtn);
            yellowGroundAndGreenTreeBtn.x = 120;
            yellowGroundAndGreenTreeBtn.y = 45;
            //「赤色地面&木」ボタン
            redGroundAndGreenTreeBtn = new CustomButton("赤地&木",RED_GROUND_AND_GREEN_TREE);
            redGroundAndGreenTreeBtn.addEventListener(MouseEvent.CLICK,onGroundSelectionBtnDown);
            redGroundAndGreenTreeBtn.addEventListener(MouseEvent.MOUSE_OVER,overGroundSelectionBtn);
            redGroundAndGreenTreeBtn.x = 120;
            redGroundAndGreenTreeBtn.y = 75;

            //「緑色地面&黄木」ボタン
            greenGroundAndYellowTreeBtn = new CustomButton("緑地&黄木",GREEN_GROUND_AND_YELLOW_TREE);
            greenGroundAndYellowTreeBtn.addEventListener(MouseEvent.CLICK,onGroundSelectionBtnDown);
            greenGroundAndYellowTreeBtn.addEventListener(MouseEvent.MOUSE_OVER,overGroundSelectionBtn);
            greenGroundAndYellowTreeBtn.x = 230;
            greenGroundAndYellowTreeBtn.y = 15;
            //「黄色地面&黄木」ボタン
            yellowGroundAndYellowTreeBtn = new CustomButton("黄地&黄木",YELLOW_GROUND_AND_YELLOW_TREE);
            yellowGroundAndYellowTreeBtn.addEventListener(MouseEvent.CLICK,onGroundSelectionBtnDown);
            yellowGroundAndYellowTreeBtn.addEventListener(MouseEvent.MOUSE_OVER,overGroundSelectionBtn);
            yellowGroundAndYellowTreeBtn.x = 230;
            yellowGroundAndYellowTreeBtn.y = 45;
            //「赤色地面&黄木」ボタン
            redGroundAndYellowTreeBtn = new CustomButton("赤地&黄木",RED_GROUND_AND_YELLOW_TREE);
            redGroundAndYellowTreeBtn.addEventListener(MouseEvent.CLICK,onGroundSelectionBtnDown);
            redGroundAndYellowTreeBtn.addEventListener(MouseEvent.MOUSE_OVER,overGroundSelectionBtn);
            redGroundAndYellowTreeBtn.x = 230;
            redGroundAndYellowTreeBtn.y = 75;

            //「緑色地面&赤木」ボタン
            greenGroundAndRedTreeBtn = new CustomButton("緑地&赤木",GREEN_GROUND_AND_RED_TREE);
            greenGroundAndRedTreeBtn.addEventListener(MouseEvent.CLICK,onGroundSelectionBtnDown);
            greenGroundAndRedTreeBtn.addEventListener(MouseEvent.MOUSE_OVER,overGroundSelectionBtn);
            greenGroundAndRedTreeBtn.x = 340;
            greenGroundAndRedTreeBtn.y = 15;
            //「黄色地面&赤木」ボタン
            yellowGroundAndRedTreeBtn = new CustomButton("黄地&赤木",YELLOW_GROUND_AND_RED_TREE);
            yellowGroundAndRedTreeBtn.addEventListener(MouseEvent.CLICK,onGroundSelectionBtnDown);
            yellowGroundAndRedTreeBtn.addEventListener(MouseEvent.MOUSE_OVER,overGroundSelectionBtn);
            yellowGroundAndRedTreeBtn.x = 340;
            yellowGroundAndRedTreeBtn.y = 45;
            //「赤色地面&赤木」ボタン
            redGroundAndRedTreeBtn = new CustomButton("赤地&赤木",RED_GROUND_AND_RED_TREE);
            redGroundAndRedTreeBtn.addEventListener(MouseEvent.CLICK,onGroundSelectionBtnDown);
            redGroundAndRedTreeBtn.addEventListener(MouseEvent.MOUSE_OVER,overGroundSelectionBtn);
            redGroundAndRedTreeBtn.x = 340;
            redGroundAndRedTreeBtn.y = 75;


            //エディットコマンド終了ボタン
            quitEditBtn = new CustomButton("終了");
            quitEditBtn.addEventListener(MouseEvent.CLICK,onQuitEditBtnDown);
            //quitEditBtn.addEventListener(MouseEvent.MOUSE_OVER,overTempBtnDown);
            quitEditBtn.x = 340;
            quitEditBtn.y = 215;

            editCommandPanelContena.x = 10;
            editCommandPanelContena.y = 115;
            //「エディット」状態コマンド用パネル
            editCommandPanel.graphics.beginFill(0x444444, 1.0);
            editCommandPanel.graphics.drawRoundRect(0, 0, 485, 250, 10, 10);
            editCommandPanel.graphics.endFill();
            //「エディット」状態コマンド用パネルの設定
            editCommandPanelContena.addChild(editCommandPanel);
            editCommandPanelContena.addChild(greenGroundBtn);
            editCommandPanelContena.addChild(yellowGroundBtn);
            editCommandPanelContena.addChild(redGroundBtn);
            editCommandPanelContena.addChild(greenGroundAndGreenTreeBtn);
            editCommandPanelContena.addChild(yellowGroundAndGreenTreeBtn);
            editCommandPanelContena.addChild(redGroundAndGreenTreeBtn);
            editCommandPanelContena.addChild(greenGroundAndYellowTreeBtn);
            editCommandPanelContena.addChild(yellowGroundAndYellowTreeBtn);
            editCommandPanelContena.addChild(redGroundAndYellowTreeBtn);
            editCommandPanelContena.addChild(greenGroundAndRedTreeBtn);
            editCommandPanelContena.addChild(yellowGroundAndRedTreeBtn);
            editCommandPanelContena.addChild(redGroundAndRedTreeBtn);
            editCommandPanelContena.addChild(quitEditBtn);
        }
//■■■ふきだし初期化エンド■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
//■■■タイトル画面ボタン初期化スタート■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
        //タイトル画面ボタンを初期化する
        public function initTitleScrnBtn():void {
            goLandScrnBtn = new CustomButton("エディット画面");
            goLandScrnBtn.x = 400;
            goLandScrnBtn.y = 280;
            goLandScrnBtn.addEventListener(MouseEvent.MOUSE_DOWN,goLandScrnBtnDown);
            addTitleScrnTxt(); //「Now Loading...」メッセージ表示
            addChild(goLandScrnBtn);
            hideTitleScrnBtn();
        }
        //タイトル画面ボタンを非表示にする
        public function hideTitleScrnBtn():void {
            goLandScrnBtn.visible = false;
        }
        //タイトル画面ボタンを表示する
        public function dispTitleScrnBtn():void {
            goLandScrnBtn.visible = true;
        }
//■■■タイトル画面ボタン初期化エンド■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
//■■■エディット画面ボタン初期化スタート■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
        //エディット画面ボタンを初期化する
        public function initLandScrnBtn():void {
            //「リセット」ボタン設定
            resetBtn = new CustomButton("リセット");
            resetBtn.x = 395;
            resetBtn.y = 0;
            resetBtn.addEventListener(MouseEvent.MOUSE_DOWN,onResetBtnDown);
            addChild(resetBtn);
            //「楓・紅葉」ボタン設定
            fallBtn = new CustomButton("楓・紅葉");
            fallBtn.x = 395;
            fallBtn.y = 30;
            fallBtn.addEventListener(MouseEvent.MOUSE_DOWN,onFallBtnDown);
            addChild(fallBtn);
            //「月夜」ボタン設定
            nightBtn = new CustomButton("月夜");
            nightBtn.x = 395;
            nightBtn.y = 60;
            nightBtn.addEventListener(MouseEvent.MOUSE_DOWN,onNightBtnDown);
            addChild(nightBtn);
            //「ライトアップ」ボタン設定
            lightUpBtn = new CustomButton("ライトアップ");
            lightUpBtn.x = 395;
            lightUpBtn.y = 90;
            lightUpBtn.addEventListener(MouseEvent.MOUSE_DOWN,onLightUpBtnDown);
            addChild(lightUpBtn);

            //「エディット」ボタン設定
            editBtn = new CustomButton("エディット");
            editBtn.x = 395;
            editBtn.y = 150;
            editBtn.addEventListener(MouseEvent.MOUSE_DOWN,onEditBtnDown);
            addChild(editBtn);

            //「クエスト画面」ボタン設定
            goTitleScrnBtn = new CustomButton("タイトル画面");
            goTitleScrnBtn.x = 395;
            goTitleScrnBtn.y = 280;
            goTitleScrnBtn.addEventListener(MouseEvent.MOUSE_DOWN,goTitleScrnBtnDown);
            addChild(goTitleScrnBtn);

            forwardBtn = new CustomButton("前進");
            forwardBtn.x = 200;
            forwardBtn.y = 410;
            leftRotBtn = new CustomButton("左回転");
            leftRotBtn.x = 90;
            leftRotBtn.y = 440;
            bDashBtn = new CustomButton("Bダッシュ");
            bDashBtn.x = 200;
            bDashBtn.y = 440;
            rightRotBtn = new CustomButton("右回転");
            rightRotBtn.x = 310;
            rightRotBtn.y = 440;
            backwardBtn = new CustomButton("後退");
            backwardBtn.x = 200;
            backwardBtn.y = 470;
            forwardBtn.addEventListener(MouseEvent.MOUSE_DOWN,onForwardBtnDown);
            forwardBtn.addEventListener(MouseEvent.MOUSE_UP,onForwardBtnUp);
            forwardBtn.addEventListener(MouseEvent.MOUSE_OUT,onForwardBtnOut);
            leftRotBtn.addEventListener(MouseEvent.MOUSE_DOWN,onLeftRotBtnDown);
            leftRotBtn.addEventListener(MouseEvent.MOUSE_UP,onLeftRotBtnUp);
            leftRotBtn.addEventListener(MouseEvent.MOUSE_OUT,onLeftRotBtnOut);
            bDashBtn.addEventListener(MouseEvent.MOUSE_DOWN,onBDashBtnDown);
            bDashBtn.addEventListener(MouseEvent.MOUSE_UP,onBDashBtnUp);
            bDashBtn.addEventListener(MouseEvent.MOUSE_OUT,onBDashBtnOut);
            rightRotBtn.addEventListener(MouseEvent.MOUSE_DOWN,onRightRotBtnDown);
            rightRotBtn.addEventListener(MouseEvent.MOUSE_UP,onRightRotBtnUp);
            rightRotBtn.addEventListener(MouseEvent.MOUSE_OUT,onRightRotBtnOut);
            backwardBtn.addEventListener(MouseEvent.MOUSE_DOWN,onBackwardBtnDown);
            backwardBtn.addEventListener(MouseEvent.MOUSE_UP,onBackwardBtnUp);
            backwardBtn.addEventListener(MouseEvent.MOUSE_OUT,onBackwardBtnOut);
            addChild(forwardBtn);
            addChild(leftRotBtn);
            addChild(bDashBtn);
            addChild(rightRotBtn);
            addChild(backwardBtn);

            //エディット画面に遷移するまでボタンを非表示
            hideLandScrnBtn();
        }
        //エディット画面ボタンを非表示
        private function hideLandScrnBtn():void {
            resetBtn.visible = false;
            fallBtn.visible = false;
            nightBtn.visible = false;
            lightUpBtn.visible = false;
            editBtn.visible = false;
            goTitleScrnBtn.visible = false;
            forwardBtn.visible = false;
            leftRotBtn.visible = false;
            rightRotBtn.visible = false;
            backwardBtn.visible = false;
            bDashBtn.visible = false;
        }
        //エディット画面ボタンを再表示
        private function dispLandScrnBtn():void {
            resetBtn.visible = true;
            fallBtn.visible = true;
            nightBtn.visible = true;
            lightUpBtn.visible = true;
            editBtn.visible = true;
            goTitleScrnBtn.visible = true;
            forwardBtn.visible = true;
            leftRotBtn.visible = true;
            rightRotBtn.visible = true;
            backwardBtn.visible = true;
            bDashBtn.visible = true;
        }
//■■■エディット画面ボタン初期化エンド■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
//■■■3D空間を初期化スタート■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
        //3D空間を初期化
        private function init3DSpace():void {
            //ビューポート生成
            viewport = new Viewport3D(500, 500, false, true);
            viewport.opaqueBackground = 0x0055FF;
            addChild(viewport);

            //シーン生成
            scene = new Scene3D();

            //レンダリングエンジン生成
            renderer = new BasicRenderEngine();

             //カメラ設定
            camera = new Camera3D();
            camera.y = 200;
            camera.target = DisplayObject3D.ZERO;

            //タイトル文字の設定　引数は色コード・透過度
            letterformat = new Letter3DMaterial(0xFF9999 , 0.9);
            letterformat.doubleSided = true
            title3DText = new Text3D("Autumn Fall" , new HelveticaBold() , letterformat);
            title3DText.y += 400;
            title3DText.scale = 1;
            Objs["title3DText"] = title3DText;
            scene.addChild(Objs["title3DText"], "title3DText");

            //最初のクエスト画面用に3Dオブジェクト初期化
            var tempBlueColorMaterial : ColorMaterial = new ColorMaterial(0x0000EE, 0.5);
            tempBlueColorMaterial.doubleSided = true;
            var tempRedColorMaterial : ColorMaterial = new ColorMaterial(0xEE0000, 0.5);
            tempRedColorMaterial.doubleSided = true;
            var tempGreenColorMaterial : ColorMaterial = new ColorMaterial(0x00EE00, 0.5);
            tempGreenColorMaterial.doubleSided = true;
            materialList.addMaterial(tempRedColorMaterial, "front");
            materialList.addMaterial(tempBlueColorMaterial, "back");
            materialList.addMaterial(tempGreenColorMaterial, "right");
            materialList.addMaterial(tempBlueColorMaterial, "left");
            materialList.addMaterial(tempRedColorMaterial, "top");
            materialList.addMaterial(tempGreenColorMaterial, "bottom");
            //飾り用3Dクリスタル表示
            crystalBoxCube = new Cube(materialList, 350, 350, 350);
            Objs["crystalBoxCube"] = crystalBoxCube;
            scene.addChild(Objs["crystalBoxCube"], "crystalBoxCube");

            //エディット画面土台Planeオブジェクト設定
            for (var xIndex:int = 0; xIndex < 10; xIndex++){
                for (var zIndex:int = 0; zIndex < 10; zIndex++){
                    //3DPlaneオブジェクトの設定
                    material = new ColorMaterial( 0x99FF00, 1 );
                    material.doubleSided = true;
                    material.smooth = true;
                    material.interactive = true;  
                    planeObj= new Plane(material, 290, 290, 1, 1); 
                    planeObj.addEventListener(InteractiveScene3DEvent.OBJECT_CLICK, mouseClickPlane);
                    planeObj.name = "planeX" + xIndex + "_Z" + zIndex;
                    planeObj.x = (300 * xIndex);
                    planeObj.z = 300 * zIndex;
                    planeObj.rotationX += 90;
                    planeObj.name = "green";
                    //Planeオブジェクトに名前を割り振り
                    //7行3列の場合の名前例："planeX7_Z3"
                    tempPlaneName = "planeX" + xIndex + "_Z" + zIndex;
                    Objs[tempPlaneName] = planeObj;
                }
            }

            //フィルターの準備
            filterList = new Array();
            var glowFilter : GlowFilter = new GlowFilter(0xFFFFFF, 1, 32, 32, 2, 1, false, false); 
            filterList.push(glowFilter);
            //Sphereによる月を設定
            var moonMaterial : ColorMaterial = new ColorMaterial(0xEEEE00, 0.7);
            moonSphere = new Sphere(moonMaterial, 80, 12, 9);
            moonSphere.useOwnContainer = true;
            moonSphere.filters = filterList; //フィルター使用のために設定
            moonSphere.y = 1000;
            moonSphere.x = 1350;
            moonSphere.z = 3000;
            Objs["moonSphere"] = moonSphere;

            //BlurFilter効果のついた光るピクセルを設定
            var layer:BitmapEffectLayer=new BitmapEffectLayer(viewport, 500, 500, true, 0, BitmapClearMode.CLEAR_PRE, true);
            viewport.containerSprite.addLayer(layer);
            layer.addEffect(new BitmapLayerEffect(new BlurFilter(8, 8, 4), false));
            pixels=new Pixels(layer);
            for(var x:Number=0; x < 20; x++){
                for(var z:Number=0; z < 20; z++){
                     for(var y:Number=0; y < 10; y++){
                         var p:Pixel3D=new Pixel3D((0xff << 24 | 0xff*Math.random() << 16 | 0xff << 8 | 0xff*Math.random()), 
                                                   x*150,
                                                   y*150,
                                                   z*150);
                         pixels.addPixel3D(p);
                     }
                }
            }
            pixels.rotationX -= 90;
            Objs["pixels"] = pixels;

            //操作用Arrowオブジェクト設定
            arrow = new Arrow(new WireframeMaterial(0x000000));
            Objs["arrow"] = arrow;

            //画像を読み込んで3DPlaneオブジェクトに貼り付け
            images = new Array(IMAGE_URL.length);
            for (var i:int = 0; i < IMAGE_URL.length; i++) {
                var loader:Loader = new Loader();
                loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onImgLoadingComplete);
                loader.load(new URLRequest(IMAGE_URL[i]), new LoaderContext(true));
                loader.name = i.toString();
            }

            //マウスイベント処理用リスナを設定
            stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
        }
//■■■楓・紅葉画像の貼りつけ処理スタート■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
        private function onImgLoadingComplete(e:Event):void {
            bmp = new Bitmap();
            bmd = new BitmapData(e.currentTarget.loader.width, e.currentTarget.loader.height, true, 0x000000)
            bmd.draw(e.currentTarget.loader);
            bmp.bitmapData = bmd;
            images[e.currentTarget.loader.name] = bmp;           
            if (++imgLoadingCount == IMAGE_URL.length) initPlaneWithBitmap();
        }
        //3DPlaneオブジェクトに紅葉画像を貼りつけ
        private function initPlaneWithBitmap():void { 
            var imgIndex : int = 0;
            for (var i:int = 0; i < PIXEL_NUM; i++) {
                for (var j:int = 0; j < PIXEL_NUM; j++ ) {
                    // Planeインスタンスを作成して画像をテクスチャとして貼りつけ
                    imgIndex = Math.random() * IMAGE_URL.length;
                    var textureBitmap:Bitmap = images[imgIndex];
                    var textureMaterial : BitmapMaterial = new BitmapMaterial(textureBitmap.bitmapData, true);
                    textureMaterial.doubleSided = true;

                    var o:Plane = new Plane(textureMaterial, PLANE_SIZE, PLANE_SIZE, PLANE_SEGMENT, PLANE_SEGMENT);
                    o.useOwnContainer = true; //フィルター使用のために設定
                    o.filters = filterList; //フィルター使用のために設定
                    
                    // 座標
                    o.x = Math.random()*3000;
                    o.y = Math.random()*1000;
                    o.z = Math.random()*3000;

                    //Planeオブジェクト取り出し用の名前を作成  7行3列の場合の名前例："leafIndex7_3" 
                    leafTempName = "leafIndex" + i + "_" + j;
                    Objs[leafTempName] = o;
                }
            }

            imgLoadingState = true;
            if (imgLoadingState) dispTitleScrnEditBtn();
            //if (imgLoadingState&&daeLoadingState) dispTitleScrnEditBtn();
        }
        //イメージファイルが読み込み終了後、タイトル画面に「エディット画面」ボタンを表示
        private function dispTitleScrnEditBtn():void {
            removeTitleScrnTxt(); //「Now Loading...」メッセージをリムーブ
            dispTitleScrnBtn(); //タイトル画面「エディット画面」ボタンを表示    
        }
//■■■楓・紅葉画像の貼りつけ処理エンド■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
//■■■イベント処理スタート■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
        //イベント処理
        private function onEnterFrame(e:Event):void{
            if (screenId == TITLE_SCREEN_ID) {
                title3DText.rotationX -= 10;
                crystalBoxCube.rotationX = viewport.mouseY; //飾り用クリスタルの座標をマウス座標から設定
                crystalBoxCube.rotationY = viewport.mouseX; //飾り用クリスタルの座標をマウス座標から設定
                setCameraForTitleScrn(); //カメラ視点設定
                renderer.renderScene(scene, camera, viewport);
            } else if (screenId == LAND_SCREEN_ID) {
                if (fallState == true) { pouringKaedeAndMomiji(); }//桜散る動きを設定
                calcArrowPos(); //操作用矢印座標を設定
                setCameraForLandScrn(); //カメラ視点設定
                renderer.renderScene(scene, camera, viewport);
            }
        }
        //エディット画面の操作用矢印座標を設定
        private function calcArrowPos():void{
            if (forwardState == true) {//前進
                arrow.moveForward(30);
            } else if (backwardState == true) {//後退
                arrow.moveForward(-30);
            } else if (leftRotState == true) {//左回転
                arrow.rotationY -= 10;
            } else if (rightRotState == true) {//右回転
                arrow.rotationY += 10;
            } else if (bDashState == true) {//Bダッシュ
                arrow.moveForward(60);
            }
        }
        //タイトル画面用カメラ視点設定
        private function setCameraForTitleScrn():void{
            var cameraDist : int = -1000; //デフォルトの距離、ステータスは1
            camera.x=cameraDist*Math.cos((90-crystalBoxCube.rotationY)*Math.PI/180)+crystalBoxCube.x;  
            camera.z=cameraDist*Math.sin((90-crystalBoxCube.rotationY)*Math.PI/180)+crystalBoxCube.z;
            camera.target.x=crystalBoxCube.x;
            camera.target.y=crystalBoxCube.y;
            camera.target.z=crystalBoxCube.z;
            cameraPitch = 90; //カメラのX軸回転の値　
            cameraYaw = 270; //カメラのY軸回転の値
            camera.orbit(cameraPitch, cameraYaw, true, crystalBoxCube);
        }
        //エディット画面用カメラ視点設定
        private function setCameraForLandScrn():void{
            var cameraDist : int = -1000; //デフォルトの距離、ステータスは1
            if (cameraDistStat == 0) {
                cameraDist = -500;
            } else if (cameraDistStat == 1) {
                cameraDist = -1000;
            } else if (cameraDistStat == 2) {
                cameraDist = -1500;
            }
            camera.x=cameraDist*Math.cos((90-arrow.rotationY)*Math.PI/180)+arrow.x;  
            camera.z=cameraDist*Math.sin((90-arrow.rotationY)*Math.PI/180)+arrow.z;
            camera.target.x=arrow.x;
            camera.target.y=arrow.y;
            camera.target.z=arrow.z;
            camera.orbit(cameraPitch, cameraYaw, true, arrow);
        }
        //楓・紅葉散る動き
        private function pouringKaedeAndMomiji():void
        {
            for (var i:int = 0; i < PIXEL_NUM; i++) {
                for (var j:int = 0; j < PIXEL_NUM; j++ ) {
                    var p:DisplayObject3D = pixelArr[i][j];
                    if (p.y > 0) {
                        p.rotationX += Math.random() * 10; 
                        p.rotationY += Math.random() * 10;
                        //p.y -= 10;
                        //p.y -= Math.random() * 10; 
                        p.y -= (Math.random() * 20 + 1) - (180 - (p.rotationX % 180)) * .008;
                    } else {
                        p.x = Math.random()*3000;
                        p.y = Math.random()*1000;
                        p.z = Math.random()*3000;
                    }
                }
            }
        }
        //キーボードイベント処理(押下時処理)
        private function onKeyDown(event:KeyboardEvent):void{
            if (screenId == TITLE_SCREEN_ID) {return;} //クエスト画面の場合は何も処理を行わない
            //Aボタン　操作オブジェクトを中心にカメラを左回り回転(Y軸回転)
            //4度づつ左回り回転  
            if (event.keyCode == 65) {
                cameraYaw = cameraYaw - 4;
                if(cameraYaw < 0) {cameraYaw = 360;}
            //Dボタン　操作オブジェクトを中心にカメラを右回り回転(Y軸回転)    
            //4度づつ右回り回転
            } else if (event.keyCode == 68) {
                cameraYaw = cameraYaw + 4;
                if(cameraYaw > 360) {cameraYaw = 0;}
            //Wボタン　操作オブジェクトを中心にカメラを上下移動(X軸回転)
            } else if (event.keyCode == 87) {        
                if(cameraPitch > 50) {cameraPitch = cameraPitch - 10;}
            //Sボタン　操作オブジェクトを中心にカメラを上下移動(X軸回転)
            } else if (event.keyCode == 83) {           
                if(cameraPitch < 100) {cameraPitch = cameraPitch + 10;}
            //Fボタン　カメラと操作オブジェクトの距離を変更
            } else if (event.keyCode == 70) {
                cameraDistStat -= 1;
                if(cameraDistStat < 0) {cameraDistStat = 2;}
            //Rボタン　カメラの設定をデフォルトにもどす
            } else if (event.keyCode == 82) {
                cameraDistStat = 1;
                cameraPitch = 80; //カメラのX軸回転の値　
                cameraYaw = 270; //カメラのY軸回転の値
            }
        }
        //エディット画面土台Planeオブジェクトクリック時処理　「エディット」パネルで選択された設定を3DPlaneオブジェクトに貼りつけ
        private function mouseClickPlane(e:InteractiveScene3DEvent):void {
            var tempPlane : Plane = (DisplayObject3D(e.target)) as Plane;
            var tempMaterial : ColorMaterial;
            var tempCylinder : Cylinder;
            var tempCone : Cone;
            switch (plane3DFieldType) {
                case GREEN_GROUND:
                    tempMaterial = new ColorMaterial( 0x99FF00, 1 );
                    tempMaterial.doubleSided = true;
                    tempMaterial.smooth = true;
                    tempMaterial.interactive = true; 
                    //クリックされたフィールドに3D木が存在している場合 
                    if (!((tempPlane.name == "normalGround")&&(tempPlane.name == "greenGround")&&(tempPlane.name == "snowGround"))) {
                        tempPlane.removeChildByName("planeTree");
                    }
                    tempPlane.material = tempMaterial;
                    tempPlane.name = "greenGround";
                    break;
                case YELLOW_GROUND:
                    tempMaterial = new ColorMaterial( 0xFFBB00, 1 );
                    tempMaterial.doubleSided = true;
                    tempMaterial.smooth = true;
                    tempMaterial.interactive = true;  
                    //クリックされたフィールドに3D木が存在している場合
                    if (!((tempPlane.name == "normalGround")&&(tempPlane.name == "greenGround")&&(tempPlane.name == "snowGround"))) {
                        tempPlane.removeChildByName("planeTree");
                    }
                    tempPlane.material = tempMaterial;
                    tempPlane.name = "normalGround";
                    break;
                case RED_GROUND:
                    tempMaterial = new ColorMaterial( 0xFF0000, 1 );
                    tempMaterial.doubleSided = true;
                    tempMaterial.smooth = true;
                    tempMaterial.interactive = true; 
                    //クリックされたフィールドに3D木が存在している場合
                    if (!((tempPlane.name == "normalGround")&&(tempPlane.name == "greenGround")&&(tempPlane.name == "snowGround"))) {
                        tempPlane.removeChildByName("planeTree");
                    }
                    tempPlane.material = tempMaterial;
                    tempPlane.name = "snowGround";
                    break;
                case GREEN_GROUND_AND_GREEN_TREE:
                    tempMaterial = new ColorMaterial( 0x99FF00, 1 );
                    tempMaterial.doubleSided = true;
                    tempMaterial.smooth = true;
                    tempMaterial.interactive = true;  
                    tempPlane.material = tempMaterial;
                    tempPlane.name = "greenGroundAndTree"
                    //木もどき3Dオブジェクト生成
                    tempCylinder = new Cylinder( new ColorMaterial( 0xFFEEAA, 1 ), 40, 200, 8, 8);
                    tempCylinder.z -= 100
                    tempCylinder.rotationX += 90;
                    tempCone = new Cone( new ColorMaterial( 0x99FF00, 1 ), 130, 200, 8, 8);
                    tempCone.y -= 100
                    tempCone.rotationX += 180;
                    tempCylinder.addChild(tempCone);
                    if (nightState == true) {//「月夜」モードのときはフィルター設定
                        tempCylinder.useOwnContainer = true; //フィルター使用のために設定
                        tempCylinder.filters = filterList;
                    }
                    tempPlane.addChild(tempCylinder, "planeTree");
                    break;
                case YELLOW_GROUND_AND_GREEN_TREE:
                    tempMaterial = new ColorMaterial( 0xFFBB00, 1 );
                    tempMaterial.doubleSided = true;
                    tempMaterial.smooth = true;
                    tempMaterial.interactive = true;  
                    tempPlane.material = tempMaterial;
                    tempPlane.name = "normalGroundAndTree"
                    //木もどき3Dオブジェクト生成
                    tempCylinder = new Cylinder( new ColorMaterial( 0xFFEEAA, 1 ), 40, 200, 8, 8);
                    tempCylinder.z -= 100
                    tempCylinder.rotationX += 90;
                    tempCone = new Cone( new ColorMaterial( 0x99FF00, 1 ), 130, 200, 8, 8);
                    tempCone.y -= 100
                    tempCone.rotationX += 180;
                    tempCylinder.addChild(tempCone);
                    if (nightState == true) {//「月夜」モードのときはフィルター設定
                        tempCylinder.useOwnContainer = true; //フィルター使用のために設定
                        tempCylinder.filters = filterList;
                    }
                    tempPlane.addChild(tempCylinder, "planeTree");
                    break;
                case RED_GROUND_AND_GREEN_TREE:
                    tempMaterial = new ColorMaterial( 0xFF0000, 1 );
                    tempMaterial.doubleSided = true;
                    tempMaterial.smooth = true;
                    tempMaterial.interactive = true;  
                    tempPlane.material = tempMaterial;
                    tempPlane.name = "snowGroundAndTree"
                    //木もどき3Dオブジェクト生成
                    tempCylinder = new Cylinder( new ColorMaterial( 0xFFEEAA, 1 ), 40, 200, 8, 8);
                    tempCylinder.z -= 100
                    tempCylinder.rotationX += 90;
                    tempCone = new Cone( new ColorMaterial( 0x99FF00, 1 ), 130, 200, 8, 8);
                    tempCone.y -= 100
                    tempCone.rotationX += 180;
                    tempCylinder.addChild(tempCone);
                    if (nightState == true) {//「月夜」モードのときはフィルター設定
                        tempCylinder.useOwnContainer = true; //フィルター使用のために設定
                        tempCylinder.filters = filterList;
                    }
                    tempPlane.addChild(tempCylinder, "planeTree");
                    break;
                case GREEN_GROUND_AND_YELLOW_TREE:
                    tempMaterial = new ColorMaterial( 0x99FF00, 1 );
                    tempMaterial.doubleSided = true;
                    tempMaterial.smooth = true;
                    tempMaterial.interactive = true;  
                    tempPlane.material = tempMaterial;
                    tempPlane.name = "greenGroundAndSnowTree"
                    //楓の木もどき3Dオブジェクト生成
                    tempCylinder = new Cylinder( new ColorMaterial( 0xFFEEAA, 1 ), 40, 200, 8, 8);
                    tempCylinder.z -= 100
                    tempCylinder.rotationX += 90;
                    tempCone = new Cone( new ColorMaterial( 0xFFBB00, 1 ), 130, 200, 8, 8);
                    tempCone.y -= 100
                    tempCone.rotationX += 180;
                    tempCylinder.addChild(tempCone);
                    if (nightState == true) {//「月夜」モードのときはフィルター設定
                        tempCylinder.useOwnContainer = true; //フィルター使用のために設定
                        tempCylinder.filters = filterList;
                    }
                    tempPlane.addChild(tempCylinder, "planeTree");
                    break;
                case YELLOW_GROUND_AND_YELLOW_TREE:
                    tempMaterial = new ColorMaterial( 0xFFBB00, 1 );
                    tempMaterial.doubleSided = true;
                    tempMaterial.smooth = true;
                    tempMaterial.interactive = true;  
                    tempPlane.material = tempMaterial;
                    tempPlane.name = "normalGroundAndSnowTree"
                    //楓の木もどき3Dオブジェクト生成
                    tempCylinder = new Cylinder( new ColorMaterial( 0xFFEEAA, 1 ), 40, 200, 8, 8);
                    tempCylinder.z -= 100
                    tempCylinder.rotationX += 90;
                    tempCone = new Cone( new ColorMaterial( 0xFFBB00, 1 ), 130, 200, 8, 8);
                    tempCone.y -= 100
                    tempCone.rotationX += 180;
                    tempCylinder.addChild(tempCone);
                    if (nightState == true) {//「月夜」モードのときはフィルター設定
                        tempCylinder.useOwnContainer = true; //フィルター使用のために設定
                        tempCylinder.filters = filterList;
                    }
                    tempPlane.addChild(tempCylinder, "planeTree");
                    break;
                case RED_GROUND_AND_YELLOW_TREE:
                    tempMaterial = new ColorMaterial( 0xFF0000, 1 );
                    tempMaterial.doubleSided = true;
                    tempMaterial.smooth = true;
                    tempMaterial.interactive = true;  
                    tempPlane.material = tempMaterial;
                    tempPlane.name = "snowGroundAndSnowTree"
                    //楓の木もどき3Dオブジェクト生成
                    tempCylinder = new Cylinder( new ColorMaterial( 0xFFEEAA, 1 ), 40, 200, 8, 8);
                    tempCylinder.z -= 100
                    tempCylinder.rotationX += 90;
                    tempCone = new Cone( new ColorMaterial( 0xFFBB00, 1 ), 130, 200, 8, 8);
                    tempCone.y -= 100
                    tempCone.rotationX += 180;
                    tempCylinder.addChild(tempCone);
                    if (nightState == true) {//「月夜」モードのときはフィルター設定
                        tempCylinder.useOwnContainer = true; //フィルター使用のために設定
                        tempCylinder.filters = filterList;
                    }
                    tempPlane.addChild(tempCylinder, "planeTree");
                    break;
                case GREEN_GROUND_AND_RED_TREE:
                    tempMaterial = new ColorMaterial( 0x99FF00, 1 );
                    tempMaterial.doubleSided = true;
                    tempMaterial.smooth = true;
                    tempMaterial.interactive = true;  
                    tempPlane.material = tempMaterial;
                    tempPlane.name = "normalGroundAndSnowTree"
                    //紅葉の木もどき3Dオブジェクト生成
                    tempCylinder = new Cylinder( new ColorMaterial( 0xFFEEAA, 1 ), 40, 200, 8, 8);
                    tempCylinder.z -= 100
                    tempCylinder.rotationX += 90;
                    tempCone = new Cone( new ColorMaterial( 0xFF0000, 1 ), 130, 200, 8, 8);
                    tempCone.y -= 100
                    tempCone.rotationX += 180;
                    tempCylinder.addChild(tempCone);
                    if (nightState == true) {//「月夜」モードのときはフィルター設定
                        tempCylinder.useOwnContainer = true; //フィルター使用のために設定
                        tempCylinder.filters = filterList;
                    }
                    tempPlane.addChild(tempCylinder, "planeTree");
                    break;
                case YELLOW_GROUND_AND_RED_TREE:
                    tempMaterial = new ColorMaterial( 0xFFBB00, 1 );
                    tempMaterial.doubleSided = true;
                    tempMaterial.smooth = true;
                    tempMaterial.interactive = true;  
                    tempPlane.material = tempMaterial;
                    tempPlane.name = "greenGroundAndSnowTree"
                    //紅葉の木もどき3Dオブジェクト生成
                    tempCylinder = new Cylinder( new ColorMaterial( 0xFFEEAA, 1 ), 40, 200, 8, 8);
                    tempCylinder.z -= 100
                    tempCylinder.rotationX += 90;
                    tempCone = new Cone( new ColorMaterial( 0xFF0000, 1 ), 130, 200, 8, 8);
                    tempCone.y -= 100
                    tempCone.rotationX += 180;
                    tempCylinder.addChild(tempCone);
                    if (nightState == true) {//「月夜」モードのときはフィルター設定
                        tempCylinder.useOwnContainer = true; //フィルター使用のために設定
                        tempCylinder.filters = filterList;
                    }
                    tempPlane.addChild(tempCylinder, "planeTree");
                    break;
                case RED_GROUND_AND_RED_TREE:
                    tempMaterial = new ColorMaterial( 0xFF0000, 1 );
                    tempMaterial.doubleSided = true;
                    tempMaterial.smooth = true;
                    tempMaterial.interactive = true;  
                    tempPlane.material = tempMaterial;
                    tempPlane.name = "snowGroundAndSnowTree"
                    //紅葉の木もどき3Dオブジェクト生成
                    tempCylinder = new Cylinder( new ColorMaterial( 0xFFEEAA, 1 ), 40, 200, 8, 8);
                    tempCylinder.z -= 100
                    tempCylinder.rotationX += 90;
                    tempCone = new Cone( new ColorMaterial( 0xFF0000, 1 ), 130, 200, 8, 8);
                    tempCone.y -= 100
                    tempCone.rotationX += 180;
                    tempCylinder.addChild(tempCone);
                    if (nightState == true) {//「月夜」モードのときはフィルター設定
                        tempCylinder.useOwnContainer = true; //フィルター使用のために設定
                        tempCylinder.filters = filterList;
                    }
                    tempPlane.addChild(tempCylinder, "planeTree");
                    break;
                dafault:
                    break
            }
        }
//■■■イベント処理エンド■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
//■■■3D空間を初期化エンド■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
//■■■ボタン処理スタート■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
//■■■画面遷移ボタン処理スタート■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
        //タイトル画面からエディット画面に遷移
        private function goLandScrnBtnDown(evt:MouseEvent):void {
            hideTitleScrnBtn(); //タイトル画面ボタンを非表示
            dispLandScrnBtn(); //エディット画面ボタンを表示

            //3Dオブジェクト表示・非表示処理
            removeTitleScrn3DObjs();
            addLandScrn3DObjs();

            addLandScrnTxt(); //エディット画面情報テキストを設定

            //スクリーンID設定
            screenId = LAND_SCREEN_ID;

            //エディット画面用のカメラ初期設定
            cameraDistStat = 1;
            cameraPitch = 80;
        }

        //エディット画面からタイトル画面に遷移
        private function goTitleScrnBtnDown(evt:MouseEvent):void {
            hideLandScrnBtn(); //エディット画面ボタンを非表示
            dispTitleScrnBtn(); //タイトル画面ボタンを表示

            //3Dオブジェクト表示・非表示処理
            removeLandScrn3DObjs();
            addTitleScrn3DObjs();

            removeLandScrnTxt(); //エディット画面情報テキストを設定解除

            //スクリーンID設定
            screenId = TITLE_SCREEN_ID;
        }

        //タイトル画面に3Dオブジェクトをセット
        private function addTitleScrn3DObjs():void {
            scene.addChild(Objs["title3DText"], "title3DText");
            scene.addChild(Objs["crystalBoxCube"], "crystalBoxCube");
        }
        //タイトル画面に3Dオブジェクトをリリース
        private function removeTitleScrn3DObjs():void {
            scene.removeChildByName("title3DText");
            scene.removeChildByName("crystalBoxCube");
        }
        //エディット画面に3Dオブジェクトをセット
        private function addLandScrn3DObjs():void {
            for (var xIndex:int = 0; xIndex < 10; xIndex++){
                for (var zIndex:int = 0; zIndex < 10; zIndex++){
                    //地面用3DPlaneオブジェクトを取り出す
                    //地面用3DPlaneオブジェクト取り出し用の名前を作成  7行3列の場合の名前例："planeX7_Z3" 
                    tempPlaneName = "planeX" + xIndex + "_Z" + zIndex;
                    scene.addChild(Objs[tempPlaneName], tempPlaneName);
                }
            }
            arrow = Objs["arrow"];
            //操作矢印を初期化
            arrow.y = 50;
            arrow.x = 1350; 
            arrow.z = 1350;
            arrow.rotationY = 0;
            scene.addChild(arrow, "arrow");

        }
        //エディット画面から3Dオブジェクトをリリース
        private function removeLandScrn3DObjs():void {
            //ランドマップ配列1行分の処理
            for (var xIndex:int = 0; xIndex < 10; xIndex++){
                //配列1行分の10列のデータを処理
                for (var zIndex:int = 0; zIndex < 10; zIndex++){
                    //3DPlaneオブジェクトをリリース
                    tempPlaneName = "planeX" + xIndex + "_Z" + zIndex;
                    scene.removeChildByName(tempPlaneName);
                }
            }
            scene.removeChildByName("arrow");
            for (var i:int = 0; i < PIXEL_NUM; i++) {
                for (var j:int = 0; j < PIXEL_NUM; j++ ) {
                    //楓・紅葉画像貼りつけ3DPlaneリムーブ用の名前を作成  7行3列の場合の名前例："leafIndex7_3" 
                    leafTempName = "leafIndex" + i + "_" + j;
                    scene.removeChildByName(leafTempName);   
                }
            }
            pixelArr = [];
            fallState = false;
        }
//■■■画面遷移ボタン処理エンド■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
//■■■エディット画面ボタン処理スタート(遷移ボタン以外)■■■■■■■■■■■■■■■■■■■■■■■■
        //リセット機能(ランド区画のみ初期化)
        private function onResetBtnDown(evt:MouseEvent):void {
            //ランド区画を初期化
            resetLandMap();
        }
        //リセット処理
        private function resetLandMap():void {
            var tempPlane : Plane;
            var tempMaterial : ColorMaterial;
            for (var xIndex:int = 0; xIndex < 10; xIndex++){
            for (var zIndex:int = 0; zIndex < 10; zIndex++){
                    //リセット処理
                    tempPlaneName = "planeX" + xIndex + "_Z" + zIndex;
                    tempPlane = (scene.getChildByName(tempPlaneName)) as Plane;
                    if(tempPlane != null) {
                        tempMaterial = new ColorMaterial( 0x00FF00, 1 );
                        tempMaterial.doubleSided = true;
                        tempMaterial.smooth = true;
                        tempMaterial.interactive = true;  
                        tempPlane.material = tempMaterial;
                        if (!((tempPlane.name == "normalGround")&&(tempPlane.name == "greenGround")&&(tempPlane.name == "snowGround"))) {
                            tempPlane.removeChildByName("planeTree");
                        }
                        tempPlane.name = "green"
                    }
                }
            }
        }
        //「楓・紅葉」機能
        private function onFallBtnDown(evt:MouseEvent):void {
            //落ちる雪に見立てたパーティクルをON・OFF
            if (fallState == false) {
                //パーティクル設定
                pixelArr = [];
                for (var i:int = 0; i < PIXEL_NUM; i++) {
                    pixelArr[i] = [];
                    for (var j:int = 0; j < PIXEL_NUM; j++ ) {
                        //楓・紅葉画像貼りつけ3DPlaneオブジェクトを取り出す
                        //Planeオブジェクト取り出し用の名前を作成  7行3列の場合の名前例："leafIndex7_3" 
                        leafTempName = "leafIndex" + i + "_" + j;
                        pixelArr[i][j] = Objs[leafTempName];
                        scene.addChild(Objs[leafTempName], leafTempName);            
                    }
                }
                fallState = true;
            } else {
                for (var i:int = 0; i < PIXEL_NUM; i++) {
                    for (var j:int = 0; j < PIXEL_NUM; j++ ) {
                        //楓・紅葉画像貼りつけ3DPlaneリムーブ用の名前を作成  7行3列の場合の名前例："leafIndex7_3" 
                        leafTempName = "leafIndex" + i + "_" + j;
                        scene.removeChildByName(leafTempName);   
                    }
                }
                fallState = false;
            } 
        }
        //「エディット」機能
        private function onEditBtnDown(evt:MouseEvent):void {
            //「エディット」コマンド用パネル設定
            addChild(editCommandPanelContena);
            var editStatusInfoTxt : String;
            editStatusInfoTxt = "3Dフィールド上に設定する3Dオブジェクトを選択できます" + "\n";
            editLabel("editStatusInfo",editStatusInfoTxt);
            editCommandPanelContena.addChild(txtField["editStatusInfo"]);
            editState = true;
        }
        //「エディット」コマンドパネル終了機能
        private function onQuitEditBtnDown(evt:MouseEvent):void {
            removeChild(editCommandPanelContena);
            editState = false;
        }
        //3Dフィールド選択ボタン上に
        private function overGroundSelectionBtn(evt:MouseEvent):void {
            var target : CustomButton;
            var tempOverGroundSelectionBtnNo : int; 
            target = CustomButton(evt.currentTarget);
            tempOverGroundSelectionBtnNo = target.getBtnNo();           
            var editStatusInfoTxt : String;
            switch (tempOverGroundSelectionBtnNo) {
                case GREEN_GROUND:
                    editStatusInfoTxt = "フィールドタイプは緑色の地面です";
                    break;
                case YELLOW_GROUND:
                    editStatusInfoTxt = "フィールドタイプは黄色の地面です";
                    break;
                case RED_GROUND:
                    editStatusInfoTxt = "フィールドタイプは赤色の地面です";
                    break;
                case GREEN_GROUND_AND_GREEN_TREE:
                    editStatusInfoTxt = "フィールドタイプは緑色地面+木です";
                    break;
                case YELLOW_GROUND_AND_GREEN_TREE:
                    editStatusInfoTxt = "フィールドタイプは黄色地面+木です";
                    break;
                case RED_GROUND_AND_GREEN_TREE:
                    editStatusInfoTxt = "フィールドタイプは赤色地面+木です";
                    break;
                case GREEN_GROUND_AND_YELLOW_TREE:
                    editStatusInfoTxt = "フィールドタイプは緑色地面+黄色木です";
                    break;
                case YELLOW_GROUND_AND_YELLOW_TREE:
                    editStatusInfoTxt = "フィールドタイプは黄色地面+黄色木です";
                    break;
                case RED_GROUND_AND_YELLOW_TREE:
                    editStatusInfoTxt = "フィールドタイプは赤色地面+黄色木です";
                    break;
                case GREEN_GROUND_AND_RED_TREE:
                    editStatusInfoTxt = "フィールドタイプは緑色地面+赤色木です";
                    break;
                case YELLOW_GROUND_AND_RED_TREE:
                    editStatusInfoTxt = "フィールドタイプは黄色地面+赤色木です";
                    break;
                case RED_GROUND_AND_RED_TREE:
                    editStatusInfoTxt = "フィールドタイプは赤色地面+赤色木です";
                    break;
                default:
                    editStatusInfoTxt = "フィールドタイプは緑地です";
                    break;
            }
            editLabel("editStatusInfo",editStatusInfoTxt);
            editCommandPanelContena.addChild(txtField["editStatusInfo"]);
        }
        //選択された3Dフィールドを設定
        private function onGroundSelectionBtnDown(evt:MouseEvent):void {
            var target : CustomButton;
            target = CustomButton(evt.currentTarget);
            plane3DFieldType = target.getBtnNo();
            removeChild(editCommandPanelContena);
            editState = false;
        }
        //「月夜ボタン」ボタン機能
        private function onNightBtnDown(evt:MouseEvent):void {
            //フィルターを使って雪月花を表現
            var tempPlane : Plane;
            var tempCylinder : Cylinder;
            var tempCone : Cone
            if (nightState == false) {//「月夜」表現を設定する
                viewport.opaqueBackground = 0x333333;
                moonSphere = Objs["moonSphere"];
                scene.addChild(moonSphere, "moonSphere");

                //3DPlaneオブジェクトによるフィールドにフィルターを設定
                for (var xIndex:int = 0; xIndex < 10; xIndex++){
                    for (var zIndex:int = 0; zIndex < 10; zIndex++){
                        //フィルター設定処理
                        tempPlaneName = "planeX" + xIndex + "_Z" + zIndex;
                        tempPlane = (scene.getChildByName(tempPlaneName)) as Plane;
                        if(tempPlane != null) {
                            //3Dツリーがある場合
                            if (!((tempPlane.name == "normalGround")&&(tempPlane.name == "greenGround")&&(tempPlane.name == "snowGround"))) {
                            //if (tempPlane.name == "sakura") {
                                tempCylinder = (tempPlane.getChildByName("planeTree")) as Cylinder;
                                if(tempCylinder != null) {
                                    tempCylinder.useOwnContainer = true; //フィルター使用のために設定
                                    tempCylinder.filters = filterList;
                                }
                            }
                        }
                    }
                }
                nightState = true;
            } else {//「月夜」表現を解除する(nightState == true)
                viewport.opaqueBackground = 0x0055FF;
                scene.removeChildByName("moonSphere");

                //3DPlaneオブジェクトによるフィールドのフィルターを解除
                for (var xIndex:int = 0; xIndex < 10; xIndex++){
                    for (var zIndex:int = 0; zIndex < 10; zIndex++){
                        //リセット処理
                        tempPlaneName = "planeX" + xIndex + "_Z" + zIndex;
                        tempPlane = (scene.getChildByName(tempPlaneName)) as Plane;
                        if(tempPlane != null) {
                            //3Dツリーがある場合
                            if (!((tempPlane.name == "normalGround")&&(tempPlane.name == "greenGround")&&(tempPlane.name == "snowGround"))) {
                            //if (tempPlane.name == "sakura") {
                                tempCylinder = (tempPlane.getChildByName("planeTree")) as Cylinder;
                                if(tempCylinder != null) {
                                    tempCylinder.useOwnContainer = false; //フィルター使用のための設定解除
                                    tempCylinder.filters = null;
                                }
                            }
                        }
                    }
                }
                nightState = false;
            }
        }
        //「ライトアップ」ボタン機能
        private function onLightUpBtnDown(evt:MouseEvent):void {
            //BlurFilter効果を使ってライトアップを表現
            var tempPlane : Plane;
            if (lightUpState == false) {//「ライトアップ」表現を設定する
                tempPlane = (scene.getChildByName("planeX0_Z0")) as Plane; //Objs["planeX0_Z0"];
                pixels = Objs["pixels"];
                tempPlane.addChild(pixels, "pixels");
                lightUpState = true;
            } else {//「ライトアップ」表現を解除する(lightUpState == true)
                tempPlane = (scene.getChildByName("planeX0_Z0")) as Plane;
                tempPlane.removeChildByName("pixels");
                lightUpState = false;
            }
        }
        //「」機能
        private function onTempBtnDown(evt:MouseEvent):void {
            
        }
        //前進ボタン押下時処理設定
        private function onForwardBtnDown(evt:MouseEvent):void {
            forwardState = true;
        }
        //前進ボタンリリース時処理設定1
        private function onForwardBtnUp(evt:MouseEvent):void {
            forwardState = false;
        }
        //前進ボタンリリース時処理設定2
        private function onForwardBtnOut(evt:MouseEvent):void {
            forwardState = false;
        }
        //後退ボタン押下時処理設定
        private function onBackwardBtnDown(evt:MouseEvent):void {
            backwardState = true;
        }
        //後退ボタンリリース時処理設定1
        private function onBackwardBtnUp(evt:MouseEvent):void {
            backwardState = false;
        }
        //後退ボタンリリース時処理設定2
        private function onBackwardBtnOut(evt:MouseEvent):void {
            backwardState = false;
        }
        //左回転ボタン押下時処理設定
        private function onLeftRotBtnDown(evt:MouseEvent):void {
            leftRotState = true;
        }
        //左回転ボタンリリース時処理設定1
        private function onLeftRotBtnUp(evt:MouseEvent):void {
            leftRotState = false;
        }
        //左回転ボタンリリース時処理設定2
        private function onLeftRotBtnOut(evt:MouseEvent):void {
            leftRotState = false;
        }
        //右回転ボタン押下時処理設定
        private function onRightRotBtnDown(evt:MouseEvent):void {
            rightRotState = true;
        }
        //右回転ボタンリリース時処理設定1
        private function onRightRotBtnUp(evt:MouseEvent):void {
            rightRotState = false;
        }
        //右回転ボタンリリース時処理設定2
        private function onRightRotBtnOut(evt:MouseEvent):void {
            rightRotState = false;
        }
        //Bダッシュボタン押下時処理設定
        private function onBDashBtnDown(evt:MouseEvent):void {
            bDashState = true;
        }
        //Bダッシュボタンリリース時処理設定1
        private function onBDashBtnUp(evt:MouseEvent):void {
            bDashState = false;
        }
        //Bダッシュボタンリリース時処理設定2
        private function onBDashBtnOut(evt:MouseEvent):void {
            bDashState = false;
        }
//■■■エディット画面ボタン処理エンド(遷移ボタン以外)■■■■■■■■■■■■■■■■■■■■■■■■■
//■■■ボタン処理エンド■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
    }
}
//■■■カスタムボタンクラス■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
import flash.display.*;
import flash.system.*;
import flash.text.*;
//カスタムボタン
class CustomButton extends SimpleButton {
        private var btnName : String = "";//ボタン名
        private var btnNo : int = 0;//ボタン番号
        //コンストラクタ    
        public function CustomButton(label:String="",no:int=0) {
            btnName = label;
            btnNo = no;
            //状態
            upState = makeSprite(label,0x999999);
            overState = upState;
            downState = makeSprite(label,0x0000FF);
            hitTestState = upState;
        }
        public function getBtnName():String {
            return btnName;
        }
        public function getBtnNo():int {
            return btnNo;
        }
        //ボタン用スプライト作成
        private function makeSprite(text:String,color:uint):Sprite{
            //ボタン用ラベル作成
            var label : TextField = new TextField();
            label.text = text;
            label.autoSize = TextFieldAutoSize.CENTER;
            label.selectable = false;
            //ボタン用スプライト作成
            var sp:Sprite = new Sprite();
            sp.graphics.beginFill(color);
            sp.graphics.drawRoundRect(0, 0, 100, 20, 15);
            sp.graphics.endFill();
            sp.alpha = 0.8;            
            sp.addChild(label);
            //ラベル用フォーマット設定
            var format:TextFormat=new TextFormat();
            format.font = "Courier New";
            format.bold = true;
            format.size = 13;
            label.setTextFormat(format);
            return sp;
        }
}
//■■■ユーティリティクラス■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
import flash.text.TextField;
import flash.text.TextFormat;
import flash.text.AntiAliasType;
import flash.text.TextFormatAlign;
//ユーティリティ
class Util
{
    //テキストフィールドの生成
    public static function makeTxtField(posX:int,posY:int,width:int,height:int):TextField {
        var label:TextField=new TextField();
        label.selectable=false;
        label.x       =posX;
        label.y       =posY;
        label.width   =width;
        label.height  =height;
        label.antiAliasType=AntiAliasType.ADVANCED;
        return label;
    }
    //テキストフォーマットの生成
    public static function makeTextFormat(size:uint,color:uint,
        align:String=TextFormatAlign.LEFT):TextFormat {
        var format:TextFormat=new TextFormat();
        format.font ="Courier New"; // 等幅フォント
        format.size =size;  
        format.color=color;
        format.bold =true;
        format.align=align;
        return format;
    }
}