/**
 * Copyright onedayitwillmake ( http://wonderfl.net/user/onedayitwillmake )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9CYz
 */

package {
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.errors.*;
    import flash.events.Event;
    import flash.filters.ColorMatrixFilter;
    import flash.net.URLRequest;
    
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.*;
    import org.libspark.betweenas3.tweens.ITween;
    
    [SWF(width='465', height='465', frameRate='120', backgroundColor='#000')]
        
    public class BetweenAS3ColorMatrix extends Sprite
     {
        private var _numImages    :int = 4
        private var _numLoaded    :int;
        
        private var _imageSet     :XML
        //private var _que          :Vector.<Loader> = new Vector.<Loader>(_numImages, false)
        private var _que          :Array = new Array();
        
        public function BetweenAS3ColorMatrix()
        {        
            Wonderfl.disable_capture();
            Wonderfl.capture_delay(2);
            
           _imageSet = new XML
            (
                <set>
                    <image url='http://farm3.static.flickr.com/2163/2097367776_f50af9e16a.jpg'>1</image>
                    <image url='http://farm4.static.flickr.com/3642/3556373834_3d37302602.jpg'>2</image>
                    <image url='http://farm4.static.flickr.com/3391/3260306876_c305ea046f.jpg'>3</image>
                    <image url='http://farm3.static.flickr.com/2483/3554309203_7295dde79a.jpg'>4</image>
                </set>
            )
             
            for each (var imageNode:XML in _imageSet..image)
            {
                var loader    :Loader = new Loader();
                    //trace(new Error(imageNode.@url))
                  //  trace(imageNode.@url)
                    loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onImageLoaded);
                    loader.load(new URLRequest(imageNode.@url.toString()));
                    _que.push(loader)
               
            }
          
        }
        
        private function onImageLoaded(e:Event):void
        {
            _numLoaded++
            _que.push(e.target as Loader)
            if(_numLoaded < _numImages) return
            
            onAllImagesLoaded();
        }
        
        private function onAllImagesLoaded():void
        {
            var i:int = 0;
            var loader:Loader
            var tList:Array = new Array();
            for each (var imageNode:XML in _imageSet..image)
          {  
            loader = _que[i] as Loader;
            loader.x = stage.stageWidth * 0.5 - loader.width * 0.5;
            
            loader.filters = [new ColorMatrixFilter([
								4.2, 0, 0, 0, 0,
								0, 4, 0, 0, 0,
								0, 0, 4.2, 0, 0,
								0, 0, 0, 0, 0
							])]
            addChild(loader)
            var t:ITween; // I usually make one variable for this and just keep reusing it 
            t = BetweenAS3.tween
				(loader,
					{ // TO
						_colorMatrixFilter: // Filter Tweens are in the format _~ilterNameLikeThis, where ~ is lowercase first char
						{matrix: // All filters are added as their own objects, as if you were calling new X filter
							[
								1, 0, 0, 0, 0,
								0, 1, 0, 0, 0,
								0, 0, 1, 0, 0,
								0, 0, 0, 1, 0
							]
						}

                                                ,_blurFilter: 
						{
						 blurX: 0,
						 blurY: 0,
						 quality: 3
						}
					},
					{ // FROM
						_colorMatrixFilter: 
						{matrix:
							[
								10, 0, 0, 0, 0,
								0, 5, 0, 0, 0,
								0, 0, 10, 0, 0,
								0, 0, 0, 2, 0
							]
						}
                                                ,_blurFilter: 
						{
						 blurX: 4,
						 blurY: 4,
						 quality: 3
						}
                                        }, 0.5, Expo.easeOut, 0.25)
                                        
                                       
              t = BetweenAS3.serial(t, BetweenAS3.tween(loader, {alpha: 0}, null, 2, Sine.easeOut, 1))
              tList.push(t)
              i++;
             }
             
              t = BetweenAS3.serial.apply(null, tList);
              t.stopOnComplete = false;
              t.play();
              Wonderfl.capture(stage)
        }
    }
}