/**
 * Copyright hankuro ( http://wonderfl.net/user/hankuro )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9Br3
 */

package {
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import flash.geom.Vector3D;
	
	[SWF(width = 500, height = 500, backgroundColor = 0x000000)]
	
	//
	// 「ActionScript3.0 アニメーション」の著者のブログにdrawTrianglesを
	//　使用したサンプルを発見。少し表示内容を変えてみました。
	//  http://www.bit-101.com/blog/?p=1544
	//

	public class Main extends Sprite	
	{
		public var sh:Shape = new Shape();
		public var blur:BlurFilter = new BlurFilter(80, 80);
		
		public function Main()
		{
			init();
		}
		
		private function init():void
		{
			
			var pan:BitmapData = new BitmapData(500, 250);
			var vertices:Vector.<Number> = new Vector.<Number>();
			var indices:Vector.<int> = new Vector.<int>();
			var uv:Vector.<Number> = new Vector.<Number>();
			//graphics.lineStyle(0);
			var res:Number = 200;
			var inner:Number = 20;
			var outer:Number = 100;
		
			for (var i:int = 0; i < res + 1; i++)
			{
				var angle:Number = Math.PI * 2 / res * i;
				vertices.push(250 + Math.cos(angle) * inner);
				vertices.push(250 + Math.sin(angle) * inner);
				uv.push(i / res, 1);
				vertices.push(250 + Math.cos(angle) * outer);
				vertices.push(250 + Math.sin(angle) * outer);
				uv.push(i / res, 0);
			}
			for(i = 0; i <res * 2; i += 2)
			{
				indices.push(i, i + 1, i + 2);
				indices.push(i + 1, i + 3, i + 2);
			}
			var a1:Number = 0;
			var a2:Number = 0;
			addEventListener(Event.ENTER_FRAME, tick);
		
			function tick(event:Event):void
			{
				inner = Math.cos(a1 += .1) * 80 + 100;
				outer = Math.sin(a2 += .07) * 80 + 150;
				var n:int = 0;
				for(var i:int = 0; i <res + 1; i++)
				{
					var angle:Number = Math.PI * 2 / res * i;
					vertices[n++] = 250 + Math.cos(angle) * inner;
					vertices[n++] = 250 + Math.sin(angle) * inner;
					vertices[n++] = 250 + Math.cos(angle) * outer;
					vertices[n++] = 250 + Math.sin(angle) * outer;
				}
				
				sh.graphics.clear();
				sh.graphics.beginFill(0xDCDCDC);
				sh.graphics.drawRect(0, 0, 500, 250);
				sh.graphics.endFill();
				sh.graphics.beginFill(Math.random() * 0xFFFFFF);
				sh.graphics.drawRect(0, 30, 500, 200);
				sh.graphics.endFill();
				sh.filters = [blur];
				pan.draw(sh);
				graphics.clear();
				graphics.beginBitmapFill(pan);
				graphics.drawTriangles(vertices, indices, uv);				
			}

		}
		
	}
}