/**
 * Copyright ocaya-isayaboc ( http://wonderfl.net/user/ocaya-isayaboc )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9Bir
 */

// forked from kt3k's Stray Dots sound-off
// forked from kt3k's forked from: Stray Dots
// forked from kt3k's Stray Dots
package
{
    import flash.net.URLRequest;
    import flash.media.SoundChannel;
    import flash.media.Sound;    
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.filters.*;

    [SWF(frameRate="60", backgroundColor="#000000")]

    public class Main extends Sprite
    {
        private var soundsource:String = "http://penv.org/gnossiennes.mp3";
        private var soundon:Boolean = false;

        private var blur:BitmapFilter;
        private var container:Sprite;
        private var source:Sprite;
        private var bmpd:BitmapData;
        
        private var rect:Sprite;
        private var straydot:StrayDot;
        private var sc:StrayDot;
        private var i:Number = 0;
        
        private var snd:Sound = new Sound();
        private var soundChannel:SoundChannel;

        public function Main()
        {
            stage.scaleMode = StageScaleMode.EXACT_FIT;
         
            init();
            if (soundon) initSound();
            addEventListener(Event.ENTER_FRAME, update);
        }

        private function init():void
        {
            blur = new BlurFilter() ;
            bmpd = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x00FFFFFF);
            container = new Sprite();
            source = new Sprite();
            
            rect = new Sprite();
            rect.graphics.beginFill(0xff0000);
            rect.graphics.drawRect(0,0,465,465);
            rect.graphics.endFill();
            addChild(rect);
            
            straydot = new StrayDot();
            sc = new StrayDot(15);
            
            addChild(new Bitmap(bmpd));
            container.addChild(source);
            
            source.graphics.beginFill(0xffffff);
            source.graphics.drawCircle(0,0,20);
            source.graphics.endFill();
        }
        
        private function initSound():void
        {
            snd.load(new URLRequest(soundsource));
            soundChannel = snd.play(0,9999);
        }


        private function update(e:Event = null):void
        {         
            var x:Number = stage.width;
            var y:Number = stage.height;
            x = Math.round(x/50);
            y = Math.round(y/50);
            
            var scale:Number = 0.6 + Math.random() * 0.35;

            source.x = dice(x) * 50 + 15;
            source.y = dice(y) * 50 + 15;
            
            {
                sc.next();
                source.transform.colorTransform = new ColorTransform(1,1,1,1,sc.r,sc.g,sc.b);
            }
            
            if (i == 0)
            {
                if (lucky(0.9)) scale = 0;
            }
            else
            {
                sc.next(50);
                if (lucky(0.4)) scale = 0;
            }

            {
                straydot.next()
                rect.transform.colorTransform = new ColorTransform(1,1,1,1,straydot.r,straydot.g,straydot.b);
            }
            
            if (i > 0) i -= 1;

            if (lucky(0.005)) {
                i = 20;
            }

            source.scaleX = scale;
            source.scaleY = scale;
 
            bmpd.draw(container, null, null, BlendMode.NORMAL);
            bmpd.applyFilter(bmpd, bmpd.rect, new Point(), blur);
        }
        
    }
}

// utils
class StrayDot
{
    public var r:Number = 127;
    public var g:Number = 127;
    public var b:Number = 127;
    public var velocity:Number;
   
    public function StrayDot(v:Number = 1):void
    {
        velocity = v;
    }
    
    public function next(v:Number = 0):void
    {
        var x:Number = uniform(-1, 1);
        var y:Number = uniform(-1, 1);
        var z:Number = uniform(-1, 1);
        
        var n:Number = Math.sqrt(x*x + y*y + z*z);
        
        var velo:Number = velocity;
        if (v) velo = v;
        
        x *= velo / n;
        y *= velo / n;
        z *= velo / n;
        
        r += x;
        g += y;
        b += z;
        this.normalize();
    }
    
    public function normalize():void
    {
        if (r < 0) r = -r;
        if (g < 0) g = -g;
        if (b < 0) b = -b;
        if (r > 255) r = 510 - r;
        if (g > 255) g = 510 - g;
        if (b > 255) b = 510 - b;
    }
}

function dice(n:Number = 6):Number
{
    return Math.round(Math.random() * n);
}

function uniform(x:Number, y:Number):Number
{
    if (x > y) {
        x, y = y, x;
    }
    return x + Math.random() * (y - x)
}


function lucky(luck:Number):Boolean
{
    return Math.random() < luck;
}
