/**
 * Copyright synapsevzla ( http://wonderfl.net/user/synapsevzla )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9BUl
 */

// forked from hacker_ciaxk5up's forked from: 光る玉　BLurを使わずに

package  
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.Stage;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.display.BlendMode;
    import flash.display.PixelSnapping;
    
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    
    
    import caurina.transitions.Tweener;
    import caurina.transitions.properties.ColorShortcuts;
    import caurina.transitions.properties.FilterShortcuts;
    import caurina.transitions.properties.CurveModifiers;
    
    
    import com.flashdynamix.utils.SWFProfiler;
    import com.flashdynamix.motion.Tweensy;
    import com.flashdynamix.motion.TweensyGroup;
    import com.flashdynamix.motion.TweensySequence;
    import com.flashdynamix.motion.TweensyTimeline;
    import com.flashdynamix.motion.guides.Bezier2D;
    import com.flashdynamix.motion.guides.Orbit2D;
    import fl.motion.easing.*;
    
    
    [SWF(backgroundColor = "0", fps = "60")] 
    public class Main extends Sprite
    {
        private var bm:Bitmap;
        private var bmd:BitmapData;
        private var _speed:Number = 10;
        private var _colorTransForme:ColorTransform;
        private var ballCollection:Array;
        private var mxCollection:Array;
        private var rect:Sprite;
        private var hRect:Sprite;
        private var ballNum:Number = 100;
        private var _scale:int = 8;
        private var _dScale:int = 10;
        
        
        public function Main() 
        {
            init();
        }
        
        
        private function init():void
        {
            FilterShortcuts.init();
            CurveModifiers.init();
            ColorShortcuts.init();
            
            
            rect = new Sprite();
            rect.graphics.beginFill(0x000000);
            rect.graphics.drawRect(0, 0, 1, 1);
            rect.graphics.endFill();
            rect.scaleX = stage.stageWidth;
            rect.scaleY = stage.stageHeight;
            addChild(rect);
            
            
            hRect = new Sprite();
            hRect.graphics.beginFill(0x000000,0.5);
            hRect.graphics.drawRect(0, 0, 1, 1);
            hRect.graphics.endFill();
            hRect.scaleX = stage.stageWidth;
            hRect.scaleY = stage.stageHeight;
            
            
            // ボールを作成
            ballCollection = [];
            mxCollection = [];
            
            var n:int = ballNum;
            for (var i:int = 0; i < n; i++) 
            {
                var ball:Ball = new Ball(Math.random()*2+10);
                ball.name = String(i);
                var matrix:Matrix = new Matrix(1, 0, 0, 1, 0, 0);
                ballCollection.push(ball);
                mxCollection.push(matrix);
                onClickHandler(ballCollection[i]);
            }
            
            
            
            bmd = new BitmapData(stage.stageWidth, stage.stageHeight, true,0xff000000);
            bm = new Bitmap(bmd);
            bm.smoothing = true;
            
            addChild(bm);
            
            
            addEventListener(Event.ENTER_FRAME, onEnterFrameHandler);
            _colorTransForme = new ColorTransform(.99, .99, .99, 0.95);
            
            
            addChild(hRect);
            
        }
        
        
        
        private function onClickHandler(moveSprite:Ball):void 
        {
            mxCollection[Number(moveSprite.name)] = new Matrix(1, 0, 0, 1, -120, Math.random() * stage.stageHeight);
            moveSprite.alpha = 1;
            var delay:Number = Math.random() * 5;
            var time:Number = Math.random() * 3 + 3;
            
            var c:uint = Math.random()*0xffffff;
            moveSprite.fillColor(c);
            
            Tweener.addTween(mxCollection[Number(moveSprite.name)], {
                tx:stage.stageWidth+20,
                ty:Math.random() * stage.stageHeight*2-stage.stageHeight/3,
                _bezier:[{tx:Math.random()*stage.stageWidth*0.25, ty:Math.random()*stage.stageHeight},{tx:Math.random()*stage.stageWidth*0.25+stage.stageWidth*.5, ty:Math.random()*stage.stageHeight}],
                time:time,
                delay:delay,
                transition:"linear",
                onComplete:onClickHandler,
                onCompleteParams:[moveSprite]
            });
            
            
        }
        
        
        private function onEnterFrameHandler(e:Event):void 
        {
            bmd.colorTransform(bmd.rect, _colorTransForme);
            
            var n:int = ballNum;
            for (var i:int = 0; i < n; i++) 
            {
                bmd.draw(ballCollection[i], mxCollection[i], null, BlendMode.ADD,null,true);
            }
            
            
        }
        
    }
    
}

import flash.display.Sprite;
class Ball extends Sprite{
    
        public var radius:Number;
        public var color:uint;
        public var vx:Number = 0;
        public var vy:Number = 0;

        
        public function Ball(radius:Number = 400, color:uint = 0xff6633){
            this.radius = radius;
            this.color = color;
            init();
        }
        
        private function init():void{
            graphics.beginFill(color);
            graphics.drawCircle(0,0,radius);
            graphics.endFill();
        }
        
        public function fillColor(value:uint):void
        {
            graphics.beginFill(value);
            graphics.drawCircle(0,0,radius);
            graphics.endFill();
        }
}