/**
 * Copyright yulei ( http://wonderfl.net/user/yulei )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9B6i
 */

package {
    import flash.net.URLRequest;
    import flash.display.Loader;
    import flash.display.Bitmap;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.system.LoaderContext;
    import flash.system.Security;
    public class drawTriangles extends Sprite {
        
        private var handles:Vector.<Sprite> = new Vector.<Sprite>();
        private var vertices:Vector.<Number>=new Vector.<Number>();
        private var uvtData:Vector.<Number>=new Vector.<Number>();
        private var indices:Vector.<int>=new Vector.<int>();
        private var bitmap:Bitmap;
        private var res:Number=100;
        private var cols:int=5;
        private var rows:int=4;
        
        public function drawTriangles() {
            // write as3 code here..
            Security.allowDomain("wonderfl.net");
            var loader:Loader=new Loader();
            var request:URLRequest = new URLRequest("http://assets.wonderfl.net/images/related_images/c/cd/cd25/cd25b6a450e7bc233b57a914e8484f18af8dee05m");
            loader.load(request,new LoaderContext(true));
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE,onLoadComplete);
        }
        
        private function onLoadComplete(e:Event):void
        {
            bitmap=e.target.content;
            makeTriangles();
            
            graphics.beginBitmapFill(bitmap.bitmapData);
            graphics.drawTriangles(vertices,indices,uvtData);
            graphics.endFill();
            
            graphics.lineStyle(0);
            graphics.drawTriangles(vertices,indices);
        }

        private function makeHandle(_x:Number,_y:Number):Sprite
        {
            var handle:Sprite = new Sprite();
            handle.graphics.beginFill(0);
            handle.graphics.drawCircle(0, 0, 5);
            handle.graphics.endFill();
            handle.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
            handle.x = _x;
            handle.y = _y;
            addChild(handle);
            return handle;
        }
        
        private function onMouseDown(e:MouseEvent):void
        {
            e.target.startDrag();
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
            stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
        }
        
        private function onMouseMove(e:MouseEvent):void
        {
            draw();
        }
        
        private function onMouseUp(e:MouseEvent):void
        {
            stopDrag();
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
            stage.removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
        }
        
        private function draw():void
        {
            for (var i:int = 0; i < handles.length; i++)
            {
                vertices[i * 2] = handles[i].x;
                vertices[i * 2 + 1] = handles[i].y;
            }
            graphics.clear();
            graphics.beginBitmapFill(bitmap.bitmapData);
            graphics.drawTriangles(vertices,indices,uvtData);
            graphics.endFill();
        }
        
        private function makeTriangles():void
        {
             for(var i:int=0;i<rows;i++)
             {
                 for(var j:int=0;j<cols;j++)
                 {
                     vertices.push(j*res,i*res);
                     handles[vertices.length / 2 - 1] = makeHandle(j * res, i * res);
                     uvtData.push(j/(cols-1),i/(rows-1));
                     
                     if(i<rows-1 && j<cols-1)
                     {
                         indices.push(i*cols+j,i*cols+j+1,(i+1)*cols+j);
                         
                         indices.push(i*cols+j+1,(i+1)*cols+j+1,(i+1)*cols+j);
                     }

                 }

             }
        }
        
    }
}