/**
 * Copyright kawamura ( http://wonderfl.net/user/kawamura )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9B3F
 */

package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    
    /**
     * ...
     * @author Jaiko
     */
    public class Main extends Sprite 
    {
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            layout();
        }
        
        private function layout():void 
        {
            var wheel:Wheel = new Wheel();
            addChild(wheel);
            wheel.x = stage.stageWidth * 0.5;
            wheel.y = stage.stageHeight * 0.5;
        }
        
    }
}
import flash.display.Graphics;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.text.TextField;

/**
 * ...
 * @author Jaiko
 */
class Wheel extends Sprite 
{
    private var wheel:Sprite;
    private var theta:Number;
    private var vw:Number = 0;
    private var preTheta:Number;
    private var tf:TextField;
    private var isDown:Boolean = false;
    
    public function Wheel() 
    {
        if (stage) init();
        addEventListener(Event.ADDED_TO_STAGE, init);
    }
    
    private function init(e:Event = null):void 
    {
        removeEventListener(Event.ADDED_TO_STAGE, init);
        //
        layout();
    }
    
    private function layout():void 
    {
        var g:Graphics;
        wheel = new Sprite();
        addChild(wheel);
        g = wheel.graphics;
        g.beginFill(0xFF0000);
        g.drawCircle(0, 0, 150);
        var point:Sprite = new Sprite();
        wheel.addChild(point);
        g = point.graphics;
        g.beginFill(0xFFFFFF);
        g.drawCircle(0, 0, 10);
        point.y = -100;
        
        point = new Sprite();
        wheel.addChild(point);
        g = point.graphics;
        g.beginFill(0);
        g.drawCircle(0, 0, 1);
        //
        tf = new TextField();
        addChild(tf);
        tf.text = "0"
        tf.selectable = false;
        tf.mouseEnabled = false;
        theta = 0;
        wheel.buttonMode = true;
        wheel.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownListener);
        //
        addEventListener(Event.ENTER_FRAME, enterFrameListener);
    }
    
    private function mouseDownListener(e:MouseEvent):void 
    {
        isDown = true;
        preTheta = Math.atan2(this.mouseY, this.mouseX);
        stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpListener);
    }
    
    private function mouseUpListener(e:MouseEvent):void 
    {
        isDown = false;
        stage.removeEventListener(MouseEvent.MOUSE_UP, mouseUpListener);
    }
    
    private function enterFrameListener(e:Event):void 
    {
        if (isDown)
        {
            var currentTheta:Number = Math.atan2(this.mouseY, this.mouseX);
            var dw:Number = (currentTheta - preTheta);
            if (dw > Math.PI)
            {
                dw -= 2 * Math.PI;
            }
            else if (dw < -Math.PI)
            {
                dw += 2 * Math.PI;
            }
            vw = dw;
            theta += dw ;
            preTheta = currentTheta;
        }
        else
        {
            vw *= 0.98;
            theta += vw ;
        }
        wheel.rotation = (theta*(180/Math.PI))%360;
        
        tf.text = String(Math.floor(theta / (2*Math.PI)));
    }
}
