/**
 * Copyright katsumi ( http://wonderfl.net/user/katsumi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/9ARN
 */

package {
    import flash.display.*;
    import flash.events.*;
    import flash.net.*;
    import flash.system.Security;
    import flash.geom.Point;
    import flash.geom.Matrix;
    
    public class FlashTest extends Sprite {
        private var req:URLRequest = new URLRequest("http://www.katsulabo.com/wonderfl/image1.jpg");
        private var s1:Sprite = new Sprite();
        private var s2:Sprite = new Sprite();
        private var picH:Number;
        private var picW:Number;
                
        private var SH:Number;
        private var SW:Number;
        
        public function FlashTest() {
            SW = this.stage.stageWidth;
            SH = this.stage.stageHeight;
           
            this.addChild(s1);
            this.addChild(s2);
            
            Security.loadPolicyFile("http://www.katsulabo.com/crossdomain.xml");
            
             var loader:Loader = new Loader();
             var info:LoaderInfo = loader.contentLoaderInfo;
             info.addEventListener(Event.COMPLETE,onLoaded);
             loader.load(req);
             //this.addChild(loader);
        }
        
        private function onLoaded(e:Event):void{
            var loader:Loader = e.target.loader;
            picW = loader.width;
            picH = loader.height;
            
            var bmp:Bitmap = Bitmap(loader.content);
            var bmd:BitmapData = BitmapData(bmp.bitmapData);
            
            this.s1.graphics.clear();
            this.s1.graphics.lineStyle(0,0,0);
            this.s1.graphics.beginBitmapFill(bmd);
            var p0:Point=new Point(0,0);
            var p1:Point=new Point(picW-50,0);
            var p2:Point=new Point(picW,50);
            var p3:Point=new Point(picW,picH);
            var p4:Point=new Point(0,picH);
            
            var tA:Array = new Array();
            tA.push(p0);
            tA.push(p1);
            tA.push(p2);
            tA.push(p3);
            tA.push(p4);
            drawPolygon(this.s1,tA);
            this.s1.x = (SW-picW)/2;
            this.s1.y = (SH-picH)/2;
            
            this.s2.graphics.clear();
            this.s2.graphics.lineStyle(0,0,0);
            this.s2.graphics.beginBitmapFill(bmd);
            var tB:Array=new Array();
            tB.push(new Point(picW-50,0));
            tB.push(new Point(picW,0));
            tB.push(new Point(picW,50));
            drawPolygon(this.s2,tB);
            this.s2.x += (SW-picW)/2;
            this.s2.y += (SH-picH)/2;
            
            //this.graphics.drawRect(0,0,300,150);
        }
        
        //Point型をpushしたArrayとSpriteが引数。
        private function drawPolygon(place:Sprite , pA:Array):void{
             place.graphics.moveTo(pA[0].x,pA[0].y);
             for(var i:Number=1;i<pA.length;i++){
                 place.graphics.lineTo(pA[i].x,pA[i].y);
             }
             place.graphics.lineTo(pA[0].x,pA[0].y);
        }
    }
}