/**
 * Copyright kanatara ( http://wonderfl.net/user/kanatara )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/99KA
 */

// forked from soundkitchen's ぷるるん
/**
 *  なんか背景画像が消されちゃったみたいなので、そのうち直します :-(
 */
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.IOErrorEvent;
    import flash.events.MouseEvent;
    import flash.events.SecurityErrorEvent;
    import flash.geom.Matrix;
    import flash.net.URLRequest;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.system.LoaderContext;

    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.*;
    import org.libspark.betweenas3.tweens.ITween;

    import com.flashdynamix.utils.SWFProfiler;

    [SWF(width=465, height=465, frameRate=30, backgroundColor=0xffffff)]

    public class Main extends Sprite
    {
        public static const IMAGE_URL:String = "http://farm4.static.flickr.com/3646/3383160404_baaf47c928_s.jpg";

        private var _moji:Sprite;
        private var _background:Sprite;
        private var _tween:ITween;

        public function Main()
        {
            SWFProfiler.init(this);

            var txt:TextField,
                fmt:TextFormat,
                bm:Bitmap,
                bmd:BitmapData,
                req:URLRequest,
                loader:Loader,
                ctx:LoaderContext;

            //  文字作る
            fmt = new TextFormat();
            fmt.size = 60;
            fmt.font = "Arial";
            fmt.bold = true;
            fmt.color = 0xFF34D7;   //  Saqoosha pink

            txt = new TextField();
            txt.defaultTextFormat = fmt;
            txt.autoSize = TextFieldAutoSize.LEFT;
            txt.text = "ぷるるん";

            bmd = new BitmapData(txt.width, txt.height, true, 0);
            bmd.draw(txt);

            bm = new Bitmap(bmd);
            bm.x -= bm.width >> 1;
            bm.y -= bm.height >> 1;
            bm.smoothing = true;

            _moji = new Sprite();
            _moji.addChild(bm);
            _moji.x = stage.stageWidth >> 1;
            _moji.y = stage.stageHeight >> 1;

            //  背景画像取りに行く
            req = new URLRequest(IMAGE_URL);
            ctx = new LoaderContext(true);
            loader = new Loader();

            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, loadComplete);
            loader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR,  dispatchEvent);
            loader.contentLoaderInfo.addEventListener(SecurityErrorEvent.SECURITY_ERROR, dispatchEvent);
            loader.load(req, ctx);  
        }

        private function loadComplete(evt:Event):void
        {
            var bm:Bitmap,
                bmd:BitmapData,
                tmp:BitmapData,
                loader:Loader,
                d:Number,
                mtx:Matrix,
                sh:Shape;

            loader = Loader(evt.target.loader);

            _background = new Sprite();
            _background.x = stage.stageWidth >> 1;
            _background.y = stage.stageHeight >> 1;
            _background.alpha = 0;

            //  背景画像の調整
            d = Math.max(stage.stageWidth / loader.width, stage.stageHeight / loader.height);
            mtx = new Matrix();
            mtx.scale(d, d);
            bmd = new BitmapData(loader.width * d, loader.height * d, true);
            bmd.draw(loader, mtx);

            bm = new Bitmap(bmd);
            bm.x -= bm.width >> 1;
            bm.y -= bm.height >> 1;

            _background.addChild(bm);

            //  マスキング画像
            tmp = new BitmapData(2, 2, true, 0);
            tmp.setPixel32(0, 0, 0x99000000);
            tmp.setPixel32(1, 1, 0x99000000);

            mtx.identity();
            mtx.scale(4, 4);
            bmd = new BitmapData(8, 8, true, 0);
            bmd.draw(tmp, mtx);

            sh = new Shape();
            sh.graphics.beginBitmapFill(bmd);
            sh.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            sh.graphics.endFill();

            sh.x -= sh.width >> 1;
            sh.y -= sh.height >> 1;

            _background.addChild(sh);

            //  仕込み
            addChild(_background);
            addChild(_moji);
            stage.addEventListener(MouseEvent.CLICK, clickHandler);
        }

        private function clickHandler(evt:MouseEvent):void
        {
            if (_tween)
            {
                _tween.stop();
            }

            _tween = BetweenAS3.parallel(
                //
                BetweenAS3.tween(_moji, {
                    rotation: 0,
                    scaleX: 1,
                    scaleY: 1
                }, {
                    rotation: Math.random() >= .5 ? 60 : -60,
                    scaleX: 1.5,
                    scaleY: 1.5
                }, 2, Elastic.easeOutWith(1, .2)),
                //
                BetweenAS3.tween(_background, {
                    alpha: 0,
                    scaleX: 1.5,
                    scaleY: 1.5
                }, {
                    alpha: .15,
                    scaleX: 1,
                    scaleY: 1
                }, 1.2, Cubic.easeOut)
            );
            _tween.play();
        }
    }
}
