/**
 * Copyright tenasaku ( http://wonderfl.net/user/tenasaku )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/99E8
 */

// 2010年4月2日
// マウスで物をドラッグして速度を与える(つまり投げる)ためには
// 投げる動きをどのように捕捉するべきか...
// ドラッグ中のマウスの動きを記録してみる

package {

	import flash.display.*;
	import flash.events.*;
	import flash.text.*;

	public class Main extends Sprite {

		private const MOUSETRACK_LIMIT:int = 40;
		private var mouseTrack:Array;
		private var screen:Shape;
		private var monitor:TextField;

		private function onMouseDown(e:MouseEvent):void {
			mouseTrack = [e.stageX,e.stageY];
			screen.graphics.clear();
			stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
			stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
		}

		private function onMouseMove(e:MouseEvent):void {
			if ( mouseTrack.unshift(e.stageX,e.stageY) > MOUSETRACK_LIMIT ) {
				mouseTrack.pop();
				mouseTrack.pop();
			}
		}

		private function onMouseUp(e:MouseEvent):void {
			stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
			stage.removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
			while ( mouseTrack.length >= 2 ) {
				var X = mouseTrack.shift();
				var Y = mouseTrack.shift();
				screen.graphics.beginFill(0xff0000);
				screen.graphics.drawCircle(X,Y,3);
				screen.graphics.endFill();
			}
		}

		private function initialize(e:Event):void {
			this.removeEventListener(Event.ADDED_TO_STAGE, initialize);
			stage.align = StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			this.graphics.clear();
			this.graphics.beginFill(0xffff00);
			this.graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);
			this.graphics.endFill();
			monitor = new TextField();
			var tfmt = new TextFormat();
			tfmt.font = null;
			tfmt.size = 16;
			tfmt.leftMargin = 2;
			tfmt.rightMargin = 2;
			tfmt.color = 0xff0000;
			monitor.defaultTextFormat = tfmt;
			monitor.autoSize = TextFieldAutoSize.LEFT;
			monitor.text = "Let's start.";
			monitor.x = 0;
			monitor.y = 0;
			this.addChild(monitor);
			screen = new Shape();
			this.addChild(screen);
			mouseTrack = [];
			stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
		}
		// The Main constructor simply calles initialize() function.

		public function Main():void {
			if ( stage != null ) {
				initialize(null);
			} else {
				this.addEventListener(Event.ADDED_TO_STAGE, initialize);
			}
		}

	} // end of class Main
} // end of package

