/**
 * Copyright GreekFellows ( http://wonderfl.net/user/GreekFellows )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/97no
 */

package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Rectangle;
    import flash.text.TextField;
    
    /**
     * ...
     * @author greekfellows
     */
    public class Main extends Sprite 
    {
        private var panel:Sprite;
        
        private var instructionsTextField:TextField;
        
        private var singlelineTextField:TextField;
        private var multilineTextField:TextField;
        private var currentTextField:String;
        
        private var submitButton:Sprite;
        private var switchButton:Sprite;
        
        private var strings:Array;
        
        private var tf:TextField;
        
        private var bd:BitmapData;
        private var b:Bitmap;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            
            setupInstructions();
        }
        
        private function setupInstructions():void {
            panel = new Sprite();
            panel.x = 465 / 2;
            panel.y = 465 / 2;
            this.addChild(panel);
            
            instructionsTextField = HandyFunctions.addTextField("Type in some text below.", 18, 0, -50);
            singlelineTextField = HandyFunctions.addTextField("Single line text goes here.", 24, 0, 0, 0, "input", 500);
            multilineTextField = HandyFunctions.addTextField("Multiline text goes here.", 24, 0, 0, 0, "input", 500, true);
            submitButton = HandyFunctions.addButton("Then click here.", 18, 0, 50);
            switchButton = HandyFunctions.addButton("Switch to multiline here.", 18, 0, 200);
            
            currentTextField = "single";
            
            panel.addChild(instructionsTextField);
            panel.addChild(singlelineTextField);
            panel.addChild(submitButton);
            panel.addChild(switchButton);
            
            submitButton.addEventListener(MouseEvent.CLICK, submitString);
            switchButton.addEventListener(MouseEvent.CLICK, switchMultiline);
        }
        
        private function fadeaway(e:Event):void {
            panel.alpha -= .05;
            panel.y -= panel.y / 50;
            
            if (panel.alpha <= 0) {
                e.currentTarget.removeEventListener(Event.ENTER_FRAME, fadeaway);
                this.removeChild(panel);
                
                effect();
            }
        }
        
        private function submitString(me:MouseEvent):void {
            me.currentTarget.removeEventListener(MouseEvent.CLICK, submitString);
            
            switch (currentTextField) {
                case "single":
                    strings = [singlelineTextField.text];
                    break;
                    
                case "multi":
                    strings = multilineTextField.text.split("\r");
                    break;
            }
            
            panel.addEventListener(Event.ENTER_FRAME, fadeaway);
        }
        
        private function switchMultiline(me:MouseEvent):void {
            switch (currentTextField) {
                case "single":
                    currentTextField = "multi";
                    panel.removeChild(singlelineTextField);
                    panel.addChild(multilineTextField);
                    break;
                    
                case "multi":
                    currentTextField = "single";
                    panel.removeChild(multilineTextField);
                    panel.addChild(singlelineTextField);
                    break;
            }
        }
        
        // the greatest thing in this entire application: effect
        
        private function effect():void {
            // set text field
            if (strings.length == 1) {
                tf = HandyFunctions.addTextField(strings[0], 18, 465 / 2, 465 / 2);
            } else {
                tf = HandyFunctions.addTextField(strings.join("\n"), 18, 465 / 2, 465 / 2, 0, "dynamic", 200, true);
                tf.height = tf.textHeight + 4;
            }
            
            this.addChild(tf);
            
            // draw it out
            bd = new BitmapData(465, 465, true, 0);
            bd.draw(this);
            
            this.removeChild(tf);
            
            // choose an effect and apply, that's all
            
            switch (Math.floor(Math.random() * 1)) {
                case 0:
                    b = new Bitmap(BrokenFall.effect(bd, false, true, new Rectangle(65 / 2, 65 / 2, 400, 400), 0.1, 0.5, 5), "auto", true);
                    break;
            }            
            this.addChild(b);
        }
    }
    
}

    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.text.TextFormat;
    /**
     * ...
     * @author greekfellows
     */
    dynamic class HandyFunctions 
    {
        
        public function HandyFunctions() 
        {
            
        }
        
        public static function addButton(text:String, size:Number, cx:Number, cy:Number):Sprite {
            var s:Sprite = new Sprite();
            
            s.x = cx;
            s.y = cy;
            
            s.addChild(addTextField(text, size, 0, 0, 0xffffff));
            
            var w:Number = s.getChildAt(0).width - s.getChildAt(0).width % 20 + 20;
            var h:Number = s.getChildAt(0).height - s.getChildAt(0).height % 20 + 20;
            
            s.graphics.beginFill(0, 1);
            s.graphics.drawRect( -w / 2, -h / 2, w, h);
            s.graphics.endFill();
           
            return s;
        }
        
        public static function addTextField(text:String, size:Number, cx:Number, cy:Number, color:uint = 0x000000, type:String = "dynamic", width:int = 200, multiline:Boolean = false):TextField {
            var tf:TextField = new TextField();            
            tf.type = type;
            tf.text = text;
            tf.multiline = multiline;
            
            if (type == "dynamic") {
                tf.selectable = false;
            }
            
            var fmt:TextFormat = new TextFormat("Segoe UI Light", size, color, false, false, false, "", "", "center");
            
            tf.setTextFormat(fmt);
            tf.defaultTextFormat = fmt;
            
            if (type == "input") {
                tf.width = width;
            } else {
                tf.width = tf.textWidth + 4;
            }
            
            tf.height = tf.textHeight + 4;
            tf.x = cx - tf.width / 2;
            tf.y = cy - tf.height / 2;
            
            return tf;
        }
        
    }
    import flash.display.BitmapData;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    /**
     * ...
     * @author greekfellows
     */
    dynamic class BrokenFall 
    {
        
        public function BrokenFall() 
        {
            
        }
        
        public static function effect(bd:BitmapData, fillClipped:Boolean = true, smoothing:Boolean = true, rectangle:Rectangle = null, scaleRange:Number = 0.5, rotateRange:Number = 1, translateRange:Number = 10):BitmapData {
            var rbd:BitmapData = bd.clone();
            
            if (rectangle == null) rectangle = new Rectangle(0, 0, rbd.width, rbd.height);
            
            for (var it:int = 0; it < (10 + Math.random() * 90); it++) {
                var sx:Number = rectangle.x + Math.random() * (rectangle.width - 1);
                var sy:Number = rectangle.y + Math.random() * (rectangle.height - 1);
                
                var rect:Rectangle = new Rectangle(sx, sy, Math.ceil(Math.random() * (rectangle.x + rectangle.width - sx)), Math.ceil(Math.random() * (rectangle.y + rectangle.height - sy)));
                var tbd:BitmapData = new BitmapData(rect.width, rect.height, true, 0);
                tbd.copyPixels(rbd, rect, new Point(0, 0));
                
                var m:Matrix = new Matrix();
                var s:Number = Math.random() * (scaleRange * 2) + (1 - scaleRange);
                m.translate( -rect.width / 2, -rect.height / 2);
                m.rotate(Math.random() * rotateRange * Math.PI / 180);
                m.scale(s, s);
                m.translate(rect.width / 2, rect.height / 2);
                m.translate(rect.x, rect.y);
                m.translate(Math.random() * translateRange - translateRange / 2, Math.random() * translateRange - translateRange / 2);
                
                if (fillClipped) rbd.fillRect(rect, 0xffffffff);
                rbd.draw(tbd, m, null, null, null, smoothing);
            }
            
            return rbd;
        }
        
    }