/**
 * Copyright WLAD ( http://wonderfl.net/user/WLAD )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/97iw
 */

// forked from Vladik's Draw Pulse
package 
{
    import flash.geom.Point;
    import flash.events.MouseEvent;
    import flash.events.Event;
    import flash.display.Sprite;
    
    public class Main extends Sprite 
    {
        private var c:StageControl;
        
        public function Main() 
        {
            if(stage) init();
            else this.addEventListener(Event.ADDED_TO_STAGE,init);}
            private function init(e:Event = null):void{
            
                        
            //Code...
            
            c = new StageControl(stage);            
            this.addEventListener(Event.ENTER_FRAME,onFrame);   

            initWaves();                
        }
        
        private var red:WaveLine;
        private var green:WaveLine;        
        
        private function initWaves():void
        {
            green = new WaveLine(c.w / 2, 70,0x00FF00);
            addChild(green);
            green.y = 50;
            green.aTime = 1.2;
            green.setQueue(0.0,1,0.0);
            green.pSize = 20;
         
            red = new WaveLine(c.w,80,0xFF0000);
            addChild(red);
            red.y = c.h / 2;
            
            trace("Move the mouse");
        }
        private function onFrame(e:Event):void
        {
            green.lPos = mouseX <= 0 ? .3 : (mouseX - 465/2) / (465/2);
            green.draw(c.timeStep);
            //green.y = mouseY <= 0 ? 45 : mouseY;
            
            red.draw(c.timeStep);
        }
    }
}
import flash.geom.*;
import flash.events.*;
import flash.display.*;
import flash.utils.Dictionary;

import flash.text.TextField;
import flash.text.TextFormat;



class WaveLine extends Sprite
{
    /// GRAPHICS ///
    
    //Draw graphics width
    public var gWidth:Number = 0;
    //Draw graphics heigth
    public var gHeight:Number = 0;
    //Draw color
    public var gColor:uint = 0;
    //Line thikness
    public var gThikness:Number = 6;
    //Graphics refz
    public var g:Graphics = null;
    
    /// ANIMATION ///
    
    //size Queue per time.
    public var aQueue:Vector.<Number>;
    //Animation time in secounds (of each animation in the animation queue).
    public var aTime:Number = 0.45;
    //Animation step. range [0, aQueue.length - 1]
    public var aStep:int = 0;
    ///Animation current time in ms.
    public var aMs:int = 0;
    /// Continius animation ?
    public var aContinius:Boolean = true;
    
    /// LINE ///
    
    //Line position. range [0,1]
    public var lPos:Number = 0.3;
    
    /// PULSE ///
    
    //Pulse size in pixels.
    public var pSize:Number = 50;
    //Pulse difference , the magnitude of the pulse.
    public var pValue:Number = 1;
    //From value.
    public var pFrom:Number = 0;
    //To value.
    public var pTo:Number = 0;
    //Num of pulses
    public var pNum:uint = 5;
    
    
    public function WaveLine(w:Number,h:Number,c:uint)
    {
        gWidth = w;
        gHeight = h;
        gColor = c;
        
        /*
        aQueue.push(0.0 , 0.3 , 0.0 , -0.3 , 
                    0.0 , 0.6 , 0.0 , -0.6 ,
                    0.0 , 1.0 , 0.0 , -1.0 ,
                    0.0 , 0.6 , 0.0 , -0.6 ,
                    0.0 , 0.3 , 0.0 , -0.3);
        */            
        setQueue(0.0 , 0.3 , 0.0 , -0.6 , 
                    0.0 , 1.0 , 0.0 , -0.6 ,
                    0.0 , 0.3 , 0.0);
        
        g = this.graphics;
    }
      
    public function setQueue(...args):void
    {
        aQueue = new Vector.<Number>();
        
        for each(var a:* in args)
        {
            aQueue.push(Number(a));
        }

        pValue = pFrom = aQueue[0];
        pTo = aQueue[1];
        aStep = 0;
        aMs = 0;
    }

    
    
    ///ms - Time step in meilisecounds.
    public function draw(ms:uint):void
    {
        aMs += ms;

        //Debug code...
        if(false)//aStep < 9) 
        {         
            aTime = 4;
            aStep = 9;   
            aMs = aStep * aTime * 1000;
        }
    
        if(aStep > aQueue.length - 1)
        {
            if(aContinius)
            {
                 aMs = 0;            
                 aStep = 0;    
                 pValue = pFrom = aQueue[0];
                 pTo = aQueue[1];
                 
                 trace("continued...",aStep,"/",aQueue.length," , ",pValue.toFixed(2));
            }
            else return;
        } else if (aMs / 1000 >= aStep * aTime) {
            
            pFrom = aQueue[aStep];
            aStep++;
            pTo = aQueue[aStep];
            
            //trace(aStep,"/",aQueue.length," , ", pValue.toFixed(2));
        }
        
        pValue = pTo + (pTo - pFrom) * 
        ( (aMs / 1000) - (aStep * aTime) ) / aTime;
        
        //trace(pValue);
        
        
        var n1:uint = pNum - 1;
        var n2:Number = n1 / 2;
        
        //Current node position.
        var pos:Number = lPos * gWidth;
        //Current node value. range [0.3 - 1.0]
        var nod:Number;
        //Node step.
        var stp:Number;
        //Node heigth. range [0,1]
        var hei:Number;
        //Min / Max node bound.
        var bnd:Number;
        //Node Length.
        var lng:Number;
        
        g.clear();
        g.lineStyle(gThikness,gColor);
        g.moveTo(0,0);
        if(pos > 0) g.lineTo(pos,0);
        
        for(var i:int = 0; i < pNum; ++i)
        { 
            nod = ((i <= n2 ? i / n2 : (n1 - i) / n2) * .7 + .3);
            stp = pSize * nod;
            hei = (i % 2 == 0 ? 1 : -1) * nod;
            bnd = -gHeight * hei * pValue;
            lng = pSize * nod;

            //Draw
            g.curveTo(
              // X                 Y
                pos,              bnd,    // top/bottom left point
                pos + lng / 2,    bnd     // top middle point
            ); g.curveTo(
                pos + lng,        bnd,    // top/bottom rigth point
                pos + lng,        0       // next point on line
            );
            
            pos += stp;            
        }
        
        if(pos < gWidth) g.lineTo(gWidth,0);        
        
    }
}

class StageControl
{
    public function keyDown(keyCode:int):Boolean
    {
        return keyCodes[keyCode];    
    }

    
    /*
     _   _            _       _     _           
    | | | |          (_)     | |   | |          
    | | | | __ _ _ __ _  __ _| |__ | | ___  ___ 
    | | | |/ _` | '__| |/ _` | '_ \| |/ _ \/ __|
    \ \_/ / (_| | |  | | (_| | |_) | |  __/\__ \
     \___/ \__,_|_|  |_|\__,_|_.__/|_|\___||___/*/
    
    //Mouse is dowm
    public var mouseDown:Boolean = false;
    //Current mouse position
    public var mouse:Point = null;
    //Previus frame mouse pos
    public var mousePrev:Point = null;

    public var keyCodes:Dictionary;
    public var keyChars:Dictionary;
    public var keyAlt:Boolean = false;
    public var keyCtrl:Boolean = false;
    public var keyShift:Boolean = false;



    public var stage:Stage = null;
    //w - stageWidth
    //h - stageHeight
    public var w:Number = 1, h:Number = 1;
    public var timeStep:uint = 0;

        /*
         _____      _ _   
        |_   _|    (_) |  
          | | _ __  _| |_ 
          | || '_ \| | __|
         _| || | | | | |_ 
         \___/_| |_|_|\__|*/
          
    public function StageControl(stage:Stage)
    {
        initStage(stage);
        initEvents();
    }
    
    private function initStage(stage:Stage):void
    {
        //Init trace
        inittrace(stage);
        
        this.stage = stage;
        
        w = stage.stageWidth;
        h = stage.stageHeight;
         
        stage.frameRate = 20;
        
        timeStep = uint(1000 / stage.frameRate);
        
        var g:Graphics = (stage.getChildAt(0) as Sprite).graphics;
        
        g.clear();
        g.beginFill(0x000000);
        g.drawRect(0,0,w,h);
        g.endFill();
    }    
    private function initEvents():void
    {
        keyCodes = new Dictionary(true);
        keyChars = new Dictionary(true);
        
        stage.addEventListener(MouseEvent.MOUSE_DOWN,onMouseDown);
        stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
        stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
    }
    /*
     _____                _       
    |  ___|              | |      
    | |____   _____ _ __ | |_ ___ 
    |  __\ \ / / _ \ '_ \| __/ __|
    | |___\ V /  __/ | | | |_\__ \
    \____/ \_/ \___|_| |_|\__|___/*/
         
    private function onMouseDown(e:MouseEvent):void
    {
        if(mouse) mousePrev = mouse.clone();
        mouse = new Point(stage.mouseX,stage.mouseY);
        if(!mousePrev) mousePrev = mouse.clone();
        
        stage.removeEventListener(MouseEvent.MOUSE_DOWN,onMouseDown);
        stage.addEventListener(MouseEvent.MOUSE_UP,onMouseUp);
        stage.addEventListener(MouseEvent.MOUSE_MOVE,onMouseMove);
    }
    private function onMouseUp(e:MouseEvent):void
    {
        stage.removeEventListener(MouseEvent.MOUSE_UP,onMouseUp);
        stage.addEventListener(MouseEvent.MOUSE_DOWN,onMouseDown);
        stage.removeEventListener(MouseEvent.MOUSE_MOVE,onMouseMove);
    }
    private function onMouseMove(e:MouseEvent):void
    {
        mousePrev = mouse.clone();
        mouse = new Point(stage.mouseX,stage.mouseY);
    }
    
    private function onKeyDown(e:KeyboardEvent):void
    {
        keyCtrl = e.ctrlKey;
        keyAlt = e.altKey;
        keyShift = e.shiftKey;
        keyCodes[e.keyCode] = true;
        keyChars[e.charCode] = true;
    }
    private function onKeyUp(e:KeyboardEvent):void
    {
        keyCtrl = e.ctrlKey;
        keyAlt = e.altKey;
        keyShift = e.shiftKey;
        keyCodes[e.keyCode] = false;
        keyChars[e.charCode] = false;
    }
}


import flash.text.TextField;
import flash.text.TextFormat;
/////  WONDERFL TRACE /////
function inittrace(s:Stage):void{WTrace.initTrace(s);}var trace:Function;class WTrace{

    private static var FONT:String = "_sans";
    private static var SIZE:Number = 12;
    private static var SPACE:String = " ";
    private static var COLOR:uint = 0xFFFFFF;
    private static var LINES:uint = 6;

private static var TextFields:Array = [];private static var trace_stage:Stage;
public static function initTrace(stg:Stage):void{trace_stage = stg;trace = wtrace;}
private static function scrollup():void{if (TextFields.length > LINES){
var removeme:TextField = TextFields.shift();trace_stage.removeChild(removeme);removeme = null;
}for(var x:Number=0;x<TextFields.length;x++){(TextFields[x] as TextField).y -= SIZE*1.2;}}
public static function wtrace(... args):void{var s:String="";var tracefield:TextField;
for (var i:int;i < args.length;i++){if (i != 0) s+=SPACE;s+=args[i].toString();}
tracefield= new TextField();tracefield.autoSize = "left";tracefield.textColor = COLOR;
tracefield.text = s;tracefield.y = trace_stage.stageHeight - 20;
var tf:TextFormat = new TextFormat(FONT, SIZE);tracefield.setTextFormat(tf);
trace_stage.addChild(tracefield);scrollup();TextFields.push(tracefield);}}