/**
 * Copyright faseer ( http://wonderfl.net/user/faseer )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/97Ym
 */

package
{
    import flash.display.Bitmap;
    import flash.events.Event;
    import flash.display.BitmapData;
    import flash.geom.Point;
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.display.Loader;
    import flash.net.URLRequest;
    import flash.geom.Matrix;
    import flash.geom.ColorTransform;
    import flash.display.BlendMode;
    import flash.system.LoaderContext;
    
    public class FlashTest extends Sprite
    {
        private const w:Number = 256.0;
        private const h:Number = 256.0;
        private const zero:Point = new Point;
        private const nice:Array = [13209,13465,13722,14235,14492,14749,15262,15519,16032,16288,16545,17058,17315,17572,18085,18342,18855,19111,19368,19881,20138,20395,20908,21165,21678,21934,22191,22704,22961,23218,23731,23988,24501,24757,25014,25527,25784,26041,26554,26811,27324,27580,27837,28350,28607,28864,29377,29634,30147,30403,30660,31173,31430,31687,32200,32457,32970,33226,33483,33996,34253,34510,35023,35280,35793,36049,36306,36819,37076,37333,37846,38103,38616,38872,39129,39642,39899,40156,40669,40926,106975,3322853,6604267,9820402,13101816,16383487,16119793,15856100,15658199,15394506,15196605,14671798,14212528,13753258,13293987,12834973,12375703,11916433,11457162,10997892,10538878,10014072,9554801,9095531,8636261,8177247,7717976,7258706,6799436,6340165,5881151,5356345,4897075,4437804,3978534,3519520,3060250,2600979,2141709,1682439,1223425,1223169,1288706,1353987,1419524,1484804,1550341,1615878,1681159,1746695,1811976,1877513,1943050,2008330,2073867,2139148,2204685,2269965,2335502,2401039,2466320,2531856,2597137,2662674,2728211,2793491,2859028,2924309,2989846,3055126,3120663,3120664,3185945,3251481,3316762,3382299,3447836,3513116,3578653,3643934,3709471,3774751,3840288,3905825,3971106,4036642,4101923,4167460,4232997,4298277,4363814,4429095,4494632,4559912,4625449,4690986,4756267,4821803,4887084,4952621,5018158,5214768,5411635,5608501,5805112,6001979,6198845,6460992,6657858,6854725,7051592,7248202,7445069,7641935,7904082,8100949,8297815,8494426,8691292,8888159,9150562,9347172,9544039,9740905,9937516,10134383,10331249,10593396,10790262,10987129,11183996,11380606,11577473,11774339,12036486,12233353,12430219,12626830,12823696,13020563,13282966,13349274,13415583,13481892,13613736,13680045,13746354,13812663,13944763,14011072,14077381,14143690,14275534,14341843,14408152,14540253,14540253,14540253,14540253,14540253,14540253,14540253,14540253,14540253,14540253,14540253,14540253,14540253,14540253,14540253,14540253,14540253,14540253,14540253,14540253,14540253];
        
        private var offsets:Array = [new Point, new Point, new Point, new Point, new Point, new Point, new Point, new Point];
        private var bheight:BitmapData;
        private var bterrain:BitmapData;
        private var bcolor:BitmapData;
        private var bnoise:BitmapData;
        
        private var frequency:int = 3;
        private var amplitude:int = 130;
        private var peakHeight:Number = 128;
        
        private var _currentFireColor:int = 0;
        private var _fireColor:BitmapData;
        private var palette:Array = nice;
        
        
        
        public function FlashTest()
        {
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, this._onLoaded);
            loader.load(new URLRequest('http://saqoosha.net/lab/Moyasu/srcview/source/fire-color.png'), new LoaderContext(true));

            this.bcolor = new BitmapData(w * 2, h, false, 0 );
            this.bheight = new BitmapData(w * 2, h, false, 0);
            this.bnoise = new BitmapData(w * 2, h, false, 0);
            this.bterrain = new BitmapData(w, h, false, 0);
            
            var canvas:Bitmap = new Bitmap(this.bterrain);
            canvas.width = 400;
            canvas.height = 400;
            this.addChild( canvas );
            this.addEventListener(Event.ENTER_FRAME, loop);
            stage.addEventListener(MouseEvent.CLICK, onclick);
        }
        
        private function _onLoaded(e:Event):void
        {
            this._fireColor = Bitmap(e.target.loader.content).bitmapData;
            this._createPalette( this._currentFireColor = 0 );
        }
        
        private function _createPalette(idx:int):void {
            this.palette = [];
            for (var i:int = 0; i < 256; i++) {
                this.palette.push(this._fireColor.getPixel(i, idx * 32));
            }
        }
        
        private function onclick(e:MouseEvent):void
        {
            if( this.mouseX > 200 )
            {
                if(++this.frequency > 8) this.frequency = 2;
            }
            else
            {
                if((this.amplitude+=10) > 300) this.amplitude = 50;
            }
            
            if( this.mouseY > 200 )
                this.peakHeight -= 10;
            else
                this.peakHeight += 10;
                
            if(this._fireColor)
            {
                if (++this._currentFireColor == int(this._fireColor.height / 32) - 2) {
                    this._currentFireColor = -1;
                }
                if(this._currentFireColor == -1){
                    this.palette = nice;
                }else{
                    this._createPalette(this._currentFireColor);
                }
            }
            
        }
        
        private function loop(e:Event):void
        {
            var octaves:int = this.frequency;

            for(var i:int = octaves; i--;)
            {
                this.offsets[i].x += ( w*.5 - this.mouseX ) * .1;
                this.offsets[i].y += ( h*.5 - this.mouseY ) * .1;
            }

            this.bheight.perlinNoise( this.amplitude,this.amplitude, octaves, 1, false, true, 7, true, offsets )
            this.bcolor.copyPixels( this.bheight, this.bcolor.rect, zero );
            
            this.bheight.threshold( this.bheight, this.bheight.rect, zero, "<", 0xff555555, 0xff555555);
            
            this.bnoise.perlinNoise( 4,4, 1, 1, false, true,7,true, this.offsets );
            this.bcolor.paletteMap( this.bcolor, this.bcolor.rect, this.zero, this.palette, [],[]);
            this.bcolor.draw( this.bnoise, null, new ColorTransform(1,1,1,.5), BlendMode.OVERLAY );
            
            this.render();
        }
        
        private function render():void
        {
            this.bterrain.fillRect(this.bterrain.rect, 0);
            
            this.bheight.lock();
            this.bterrain.lock();

            var rows:int = this.bheight.height;
            var cols:int = this.bheight.width;
            var f:Number = 150;

            for(var y:int = 0; y < rows; ++y)
            {
                for(var x:int = 0; x < cols; ++x)
                {
                    for(var k:int = 0; k < 3; ++k)
                    {
                        var color:int = this.bheight.getPixel(x,y);
                        
                        var p3z:Number = y;
                        var p3x:Number = x - w;
                        var p3y:Number = -(color / 0xffffff * this.peakHeight) + h;
                        
                        var scale:Number = f / (f + p3z);

                        var p2x:Number = p3x * scale + w*.5;
                        var p2y:Number = p3y * scale + k;

                        if( this.bterrain.getPixel( p2x, p2y ) == 0)
                            this.bterrain.setPixel( p2x, p2y, this.bcolor.getPixel(x,y) );
                        else
                            break;
                    }
                }
            }

            this.bheight.unlock();
            this.bterrain.unlock();
        }
    }
}