/**
 * Copyright s1190133 ( http://wonderfl.net/user/s1190133 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/97HC
 */

package
{
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
 
    [SWF(backgroundColor=0x000000, width=465, height=465)]
    public class flash_ex07_sample1 extends Sprite
    {
        private var ball1:Ball;
        private var ball2:Ball;
        private var ball3:Ball;
        private var radius:Number=0;
        private var centerX:Number=stage.stageWidth / 2;
        private var centerY:Number=stage.stageHeight / 2;
 
        public function flash_ex07_sample1()
        {
            stage.scaleMode=StageScaleMode.NO_SCALE;
            stage.align=StageAlign.TOP_LEFT;
 
            ball1=new Ball(0xFF0000); //赤い玉
            ball1.r=200;
            ball1.y=centerY;
            ball1.x=centerX+ball1.r;
            ball2=new Ball(0x00FF00); //緑の玉
            ball2.r=200;
            ball2.y=centerY;
            ball2.x=centerX+ball2.r;
            ball3=new Ball(0x0000FF); //青の玉
            ball3.r=200;
            ball3.x=centerX;
            ball3.y=centerY+ball3.r;
 
            addChild(ball1);
            addChild(ball2);
            addChild(ball3);
 
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        //ボールを動かすメソッド 
        private function onEnterFrame(e:Event):void
        {
            //角度をちょっとづつ増やしてやる
            radius+=3;
 
            graphics.clear(); //線を毎回消す
 
            //赤い玉を動かす
            ball1.x=ball1.r * Math.cos(Math.PI * radius / 180) + centerX;
            ball1.y=ball1.r * Math.sin(Math.PI * radius / 180) + centerY;
 
            //緑の玉を動かす
            ball2.x=ball2.r * Math.cos(Math.PI * radius / 180) + centerX;
 
            //青の玉を動かす
            ball3.y=ball3.r * Math.sin(Math.PI * radius / 180) + centerY;
 
            draw_line(); //線を毎回描く
        }
         //線を引くメソッド
        private function draw_line():void
        {
            graphics.lineStyle(1, 0xFFFFFF);
 
            //緑と青を結ぶ
            graphics.moveTo(ball2.x, ball2.y);
            graphics.lineTo(ball3.x, ball3.y);
            //赤と青を結ぶ
            graphics.moveTo(ball1.x, ball1.y);
            graphics.lineTo(ball3.x, ball3.y);
            //赤と緑を結ぶ
            graphics.moveTo(ball1.x, ball1.y);
            graphics.lineTo(ball2.x, ball2.y);
 
            //円を描く
            graphics.drawCircle(centerX, centerY, 200);
            //縦の線
            graphics.moveTo(centerX, centerY + 200);
            graphics.lineTo(centerX, centerY - 200);
            //横の線
            graphics.moveTo(centerX + 200, centerY);
            graphics.lineTo(centerX - 200, centerY);
        }
    }
}
import flash.display.Sprite;
 
class Ball extends Sprite
{
    public var r:Number;
 
    public function Ball(color:Number)
    {
        graphics.beginFill(color,0.5);
        graphics.drawCircle(0, 0, 20);
        graphics.endFill();
    }
}