/**
 * Copyright alumican_net ( http://wonderfl.net/user/alumican_net )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/97BW
 */

// [実験] Point.distance
package {

import flash.display.*;
import flash.geom.Point;
import flash.text.*;
import flash.utils.*;

public class Main extends Sprite
{
    public function Main():void
    {
        var n:uint = 10000;
        var points:Array = new Array(n);
        for(var i:uint = 0; i < n; ++i)
        {
            points[i] = new Point(
                (Math.random() - 0.5) * 1000,
                (Math.random() - 0.5) * 1000
            );
        }
        
        _setup();
        
        _measure("Point.distance", function ():void
        {
            for(var i:uint = 0; i < n - 1; ++i)
            {
                Point.distance(points[i], points[i + 1]);
            }
            
        }, 100);
        
        var dx:Number, dy:Number, p0:Point, p1:Point;
        
        _measure("Math.sqrt(x^2 + y^2)", function ():void
        {
            for(var i:uint = 0; i < n - 1; ++i)
            {
                p0 = points[i    ];
                p1 = points[i + 1];
                
                dx = p0.x - p1.x;
                dy = p0.y - p1.y;
                Math.sqrt(dx * dx + dy * dy);
            }
            
        }, 100);
    }
    
    private function _measure(
        title:String, func:Function, numTimes:uint, ...params):void
    {
        _time = getTimer();
        
        for (var i:int = 0; i < numTimes; i++) {
            func.apply(null, params);
        }
        
        _time = getTimer() - _time;
        
        _debug("[ " + title + " ] --> " + _time + " ms");
    }
    
    private function _debug(log:String):void
    {
        _field.appendText(log + "\n");
    }
    
    private var _field:TextField;
    private var _time:uint;
    
    private function _setup():void
    {
        _field = new TextField();
        _field.width = stage.stageWidth;
        _field.height = stage.stageHeight;
        
        var format:TextFormat = _field.defaultTextFormat;
        format.font = "_sans";
        _field.defaultTextFormat = format;
        
        addChild(_field);
    }
}

}