/**
 * Copyright umi_kappa ( http://wonderfl.net/user/umi_kappa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/96FL
 */

//Papervision3DでPlaneを生成し、Gainerに加速度センサをつなげて
//ブレッドボードを傾けるとPlaneも連動して変形します。
//読み込んだ3秒後にセンサの誤差をリセットする。
//Gainerモジュールのボタンを押してもリセットできます。
//回路の組み方やもっと詳しいコメントはhttp://wonderfl.net/code/eba916c4a25e76949fa69d7cac9495aae2830e2e
//にあります。
//次はCubeに挑戦してみようかな？？

//youtubeに動画をUPしてみました。
//http://www.youtube.com/watch?v=WV3Sh_xDwbo
//なんでここには載せられないんだろ？？
//不具合だろうな・・・残念。

package  
{
	import flash.display.Sprite;
	import flash.events.Event;
    import flash.system.*;
	import adobe.utils.ProductManager;
	import flash.text.TextField;
	import flash.utils.*;
	import funnel.Convolution;
	import funnel.Gainer;
	import funnel.Pin;
	import funnel.Scaler;
	import funnel.ui.*;
	import org.papervision3d.materials.*;
	import org.papervision3d.objects.primitives.*;
	import org.papervision3d.view.*;
	
	[SWF(width = "500",height = "500",backgroundColor = "#fefefe",frameRate = "30")]
	
	public class Main extends BasicView
	{
		
		Security.loadPolicyFile("http://assets.wonderfl.net/crossdomain.xml");//クロスドメイン対策
		
		private var url:String;
		private var material:BitmapFileMaterial;
		private var plane:Plane;
		//回転するPlane用
		
		private var Floor_material:WireframeMaterial;
		private var Floor:Plane;
		//床
		
		private var gio:Gainer;
		private var in_Pin0:Pin;//ain0 X軸方向
		private var in_Pin1:Pin;//ain1　Z軸方向
		private var xx:Number = 0;//X軸調整用
		private var zz:Number = 0;//Z軸調整用
		//Gainer用変数
		
		private var text_x:TextField = new TextField;
		private var text_z:TextField = new TextField;
		
		public function Main() 
		{
			set_3d();//3D設定
			set_gainer();
			
			addChild(text_x);
			addChild(text_z);
			text_z.y = 20;
			//現在何度か表示する
		}
		
		private function set_gainer():void
		{
			
			var intervalId:uint = setTimeout(syoki_set, 3000);
			
			gio = new Gainer;
			
			in_Pin0 = gio.analogInput(0);
			in_Pin0.addFilter(new Scaler(0, 1, -180, 180, Scaler.LINEAR, true));
			in_Pin0.addFilter(new Convolution(Convolution.MOVING_AVERAGE));
			
			in_Pin1 = gio.analogInput(1);
			in_Pin1.addFilter(new Scaler(0, 1, -180, 180, Scaler.LINEAR, true));
			in_Pin1.addFilter(new Convolution(Convolution.MOVING_AVERAGE));
			
			addEventListener(Event.ENTER_FRAME, doEF);
			
			gio.button.addEventListener(ButtonEvent.PRESS, btn_press);
		}
		
		private function btn_press(e:ButtonEvent):void 
		{
			syoki_set();
		}
		
		private function syoki_set():void
		{
			xx = Math.floor(in_Pin0.value);
			zz = Math.floor(in_Pin1.value);
		}
		
		private function doEF(e:Event):void 
		{
			plane.rotationX = Math.floor(in_Pin0.value - xx -90) * -1;
			text_x.text = "rotationX = " + plane.rotationX;
			
			plane.rotationZ = Math.floor(in_Pin1.value - zz) * -1;
			text_z.text = "rotationZ = " + plane.rotationZ;
		}
		
		private function set_3d():void {
			Floor_material = new WireframeMaterial(0x333333);
			Floor = new Plane(Floor_material, 1000, 1000, 10, 10);
			scene.addChild(Floor);
			Floor.rotationX = 90;
			Floor.z = 300;
			Floor.y = -300;
			//床
			
			url = "http://assets.wonderfl.net/images/related_images/3/33/33f8/33f8378a890bab7cca98107b0edfaf2bfbfeac3a";
			material = new BitmapFileMaterial(url, true);
			plane = new Plane(material, 300, 300, 10, 10);
			material.smooth = true;
			material.oneSide = false;
			scene.addChild(plane);
			//回転用Planeを配置
			
			
			camera.z = camera.focus * camera.zoom * -1;
			//ピクセル等倍
			
			startRendering();
			//レンダリング開始
		}
	}
}