/**
 * Copyright more_more_for ( http://wonderfl.net/user/more_more_for )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/95G6
 */

package 
{
	/* Text Layout Framework Test01
	** reference--------
	** http://help.adobe.com/en_US/FlashPlatform/beta/reference/actionscript/3/flashx/textLayout/elements/package-detail.html
	** http://www.aozora.gr.jp/cards/000081/files/46268_23911.html
	** http://www.eqliquid.com/blog/2009/11/text-layout-framework-2-textfl.html */
	/* auther--------
	** more_more_for
	*/
	
	import flash.display.Sprite;
	import flash.events.Event;
    import flashx.textLayout.container.ContainerController;
    import flashx.textLayout.elements.Configuration;
    import flashx.textLayout.elements.ParagraphElement;
    import flashx.textLayout.elements.SpanElement;
    import flashx.textLayout.elements.TextFlow;
    import flash.text.engine.FontPosture;
    import flash.text.engine.Kerning;
	import flashx.textLayout.formats.TextLayoutFormat;
	import flashx.textLayout.formats.TextAlign;
	import flashx.textLayout.container.ContainerController;
	import flashx.textLayout.conversion.TextConverter;
	import flashx.textLayout.formats.JustificationRule;
	import flashx.textLayout.formats.BlockProgression;
	import flashx.textLayout.formats.BackgroundColor;
	
	public class TLFTest01 extends Sprite 
	{
		private var textFlow:TextFlow;
		private var paragraph:ParagraphElement;
		private var baseSp:Sprite;
		private var baseBg:Sprite;
		private var span:SpanElement;
		
		public function TLFTest01():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			var config:Configuration = new Configuration();
			var textLayoutFormat:TextLayoutFormat = new TextLayoutFormat();
			textLayoutFormat.color = 0xFFFFFF;
			textLayoutFormat.fontFamily = "Kozuka Mincho Pro M"
			textLayoutFormat.fontSize = 16;
			textLayoutFormat.textAlign = TextAlign.LEFT;
			config.textFlowInitialFormat = textLayoutFormat;

			
			textFlow = new TextFlow(config);
			paragraph = new ParagraphElement();
			span = new SpanElement();
			
			paragraph.addChild(span);
			textFlow.addChild(paragraph);
			baseSp = new Sprite();
			baseBg = new Sprite();
			baseSp.x = -15;
			baseSp.y = 100;
			baseBg.graphics.beginFill(0x000033);
			baseBg.graphics.drawRect(0,0,465,465);
			baseBg.graphics.endFill();
			this.addChild(baseBg);
			baseBg.addChild(baseSp);
			
			//表示したいテキスト
			var markup:String = "<?xml version=\"1.0\" encoding=\"utf-8\"?>" +
            "<flow:TextFlow xmlns:flow=\"http://ns.adobe.com/textLayout/2008\" verticalScrollPolicy=\"auto\" horizontalScrollPolicy=\"auto\" editingMode=\"readWrite\" fontSize=\"14\" lineHeight='24' textIndent=\"0\" marginBottom=\"15\" paddingTop=\"4\" paddingLeft=\"4\">"+
                "<flow:p fontSize='28' fontWeight='BOLD' lineHeight='150%'>"+
                		"<flow:span>星めぐりの歌</flow:span>"+
                "</flow:p>"+
                "<flow:p fontSize='18' fontWeight='bold' textIndent='120' lineHeight='200%'>"+
                		"<flow:span>宮澤賢治</flow:span>"+
                "</flow:p>"+
                "<flow:p>"+
                    "<flow:span id='span1'>あかいめだまの　さそり<br /></flow:span>"+
                    "<flow:span id='span2'>ひろげた鷲の　　つばさ<br /></flow:span>"+
                    "<flow:span id='span3'>あをいめだまの　小いぬ、<br /></flow:span>"+
                    "<flow:span id='span3'>ひかりのへびの　とぐろ。<br /><br /></flow:span>"+
                    "<flow:span id='span3'>オリオンは高く　うたひ<br /></flow:span>"+
                    "<flow:span id='span3'>つゆとしもとを　おとす、<br /></flow:span>"+
                    "<flow:span id='span3'>アンドロメダの　くもは<br /></flow:span>"+
                    "<flow:span id='span3'>さかなのくちの　かたち。<br /><br /></flow:span>"+
                    "<flow:span id='span3'>大ぐまのあしを　きたに<br /></flow:span>"+
                    "<flow:span id='span3'>五つのばした　　ところ。<br /></flow:span>"+
                    "<flow:span id='span3'>小熊のひたいの　うへは<br /></flow:span>"+
                    "<flow:span id='span3'>そらのめぐりの　めあて。<br /></flow:span>"+
                "</flow:p>"+
            "</flow:TextFlow>";
			
			textFlow = TextConverter.importToFlow(markup, TextConverter.TEXT_LAYOUT_FORMAT);
			var containerController:ContainerController = new ContainerController(baseSp, 450, 400);
			textLayoutFormat.locale = "ja";
			textLayoutFormat.justificationRule = JustificationRule.EAST_ASIAN;
			textLayoutFormat.blockProgression = BlockProgression.RL;
			textFlow.hostFormat = textLayoutFormat;
			textFlow.flowComposer.addController(containerController);
			textFlow.flowComposer.updateAllControllers();
			
		}
		
	}
	
}
