/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/94ml
 */

package {
    import flash.geom.Point;
    import flash.geom.ColorTransform;
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.filters.BlurFilter;
    
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    import com.greensock.easing.*;
    import com.greensock.TweenMax;
    
    import com.bit101.components.Label;
    import com.bit101.components.CheckBox;
    import com.bit101.components.ComboBox;
    import com.bit101.components.NumericStepper;
    
    [SWF(width='465', height='465', backgroundColor='0xffffff', frameRate='25')]
    
    public class FlashTest extends Sprite {
        private var blob_vector:Vector.<Blob>;
        private var blob_ease:String = 'easeIn';
        private var blob_tween:Class = Back;
        private var blob_blend:String = 'hardlight';
        private var blob_alpha:Number = 0.95;
        private var blob_blur:Number = 0;
        private var blob_pixels:BitmapData;
        private var blob_bitmap:Bitmap;
        private var blob_holder:Sprite;
        
        private var panel_button:CheckBox;
        private var panel:Sprite;
        private var stageW:Number;
        private var stageH:Number;
        
        public function FlashTest() {
            stage ? init():addEventListener(Event.ADDED_TO_STAGE, init);            
        }
        
        private function init():void
        {
            if(hasEventListener(Event.ADDED_TO_STAGE))
            {
                removeEventListener(Event.ADDED_TO_STAGE, init);
            }
            stageH = stage.stageHeight;
            stageW = stage.stageWidth;
            
            stage.scaleMode = 'noScale';
            stage.align = 'TL';
            
            blob_holder = new Sprite();
            
            blob_bitmap = new Bitmap();
            
            addChild(blob_bitmap);
            blob_pixels = new BitmapData
            (
                stageW, stageH, true, 0xffffff
            );
            
            onGenerate();
            
            onPanel();
            
            stage.addEventListener
            (
                MouseEvent.CLICK, onGenerateProxy
            );
            
            addEventListener(Event.ENTER_FRAME, onRender);
        }
        
        private function onRender(e:Event):void
        {
            var px:Number = -0.025 * (mouseX - stageW / 2);
            var py:Number = -0.025 * (mouseY - stageH / 2);
            
            blob_pixels.colorTransform
            (
                blob_pixels.rect, new ColorTransform(1, 1, 1, blob_alpha, 0, 0, 0, 0)
            );
            blob_pixels.applyFilter
            (
                blob_pixels, blob_pixels.rect, new Point(0, 0), new BlurFilter(blob_blur, blob_blur)
            );
            blob_pixels.scroll(px, py);
            blob_pixels.draw(blob_holder);
            blob_bitmap.bitmapData = blob_pixels;
            
            for each(var b:Blob in blob_vector)
            {
                var degrees:Number = Math.atan2
                (mouseY - b.y, mouseX - b.x) * (180 / Math.PI);
                b.bevel.angle = degrees;
                b.filters = [b.bevel, b.glow];
                
                if(b.moved)
                {
                    b.moved = false;
                    b.point = new Point
                    (
                        b.width /2 + (Math.random() * (stageW - b.width)),
                        b.height /2 + (Math.random() * (stageH - b.height))
                    )
                    
                    var duration:Number = 0.75 + Math.round(Math.random() + 1.25);
                    
                    TweenMax.to
                    (
                        b,
                        duration,
                        {
                            x:b.point.x - x,
                            y:b.point.y - y,
                            onCompleteParams : [b],
                            onComplete : onPointMoved,
                            ease : blob_tween[blob_ease]
                        }
                    );
                }
            }
        }
        
        private function onGenerate():void
        {
            var blob_num : uint = 5 + Math.round(Math.random()*5);
            blob_holder = new Sprite();
            blob_vector = new <Blob>[];
            
            for(var i:int=0; i<blob_num; i++)
            {
                var b:Blob = new Blob
                (
                    new Point
                    (
                        stageH / 2,
                        stageW / 2
                    )
                );
                
                b.blendMode = blob_blend;
                blob_holder.addChild(b);
                blob_vector.push(b); 
            }
        }
        
        private function onGenerateProxy(e:MouseEvent):void
        {
            if(!panel.hitTestPoint(mouseX, mouseY))
            {
                onGenerate();
            }
        }
        
        private function onPanel():void
        {
            panel = new Sprite();
            
            var rect:Sprite = new Sprite();
            rect.graphics.lineStyle(1, 0xaaaaaa);
            rect.graphics.beginFill(0xffffff, 0.5);
            rect.graphics.moveTo(0, 0);
            rect.graphics.lineTo(130, 0);
            rect.graphics.lineTo(130, 119);
            rect.graphics.lineTo(20, 119);
            rect.graphics.lineTo(20, 20);
            rect.graphics.lineTo(0, 20);
            rect.graphics.lineTo(0, 0);
            rect.graphics.endFill();
            
            panel.addChild(rect);
            
            panel_button = new CheckBox(panel, 5, 5, null, onPanelDisplay);
            panel_button.selected = true;
            
            var array_tween:Array = 
            [
                {label:'BACK', data:Back},
                {label:'BOUNCE', data:Bounce},
                {label:'CIRC', data:Circ},
                {label:'CUBIC', data:Cubic},
                {label:'ELASTIC', data:Elastic},
                {label:'EXPO', data:Expo},
                {label:'LINEAR', data:Linear},
                {label:'QUAD', data:Quad},
                {label:'QUART', data:Quart},
                {label:'QUINT', data:Quint},
                {label:'SINE', data:Sine},
                {label:'STRONG', data:Strong}
            ];
            
            var combo_tween:ComboBox = new ComboBox(panel, 25, 5, 'TWEEN', array_tween);
            combo_tween.numVisibleItems = array_tween.length;
            combo_tween.addEventListener
            (
                Event.SELECT, onSelectTween
            );
            
            var array_ease:Array =
            [
                {label:'EASE IN', data:'easeIn'},
                {label:'EASE OUT', data:'easeOut'},
                {label:'EASE IN OUT', data:'easeInOut'}
            ];
            
            var combo_ease:ComboBox = new ComboBox(panel, 25, 30, 'EASE', array_ease);
            combo_ease.numVisibleItems = array_ease.length;
            combo_ease.addEventListener
            (
                Event.SELECT, onSelectEase
            );
            
            var array_blend:Array =
            [
                {label:'ADD', data:'add'},
                {label:'DARKEN', data:'darken'},
                {label:'DIFFERENCE', data:'difference'},
                {label:'HARDLIGHT', data:'hardlight'},
                {label:'INVERT', data:'invert'},
                {label:'LAYER', data:'layer'},
                {label:'LIGHTEN', data:'lighten'},
                {label:'MULTIPLY', data:'multiply'},
                {label:'NORMAL', data:'normal'},
                {label:'OVERLAY', data:'overlay'},
                {label:'SCREEN', data:'screen'},
                {label:'SUBTRACT', data:'subtract'}
            ];
            
            var combo_blend : ComboBox = new ComboBox(panel, 25, 25, 'BLEND', array_blend);
            combo_blend.numVisibleItems = array_blend.length;
            combo_blend.addEventListener
            (
                Event.SELECT, onSelectBlend
            );
            
            var lb_alpha:Label = new Label(panel, 91, 79, 'ALPHA');
            var ns_alpha:NumericStepper = new NumericStepper(panel, 25, 79, onAlpha);
            ns_alpha.width = 60;
            ns_alpha.step = 0.05;
            ns_alpha.labelPrecision = 2;
            ns_alpha.minimum = -0.1;
            ns_alpha.maximum = 1;
            ns_alpha.value = blob_alpha;
            
            var lb_blur:Label = new Label(panel, 91, 99, 'BLUR');
            var ns_blur:NumericStepper = new NumericStepper(panel, 25, 99, onBlur);
            ns_blur.width = 60;
            ns_blur.minimum = 0;
            ns_blur.maximum = 10;
            ns_blur.value = blob_blur;
            
            panel.x = stageW - (panel.width + 20);
            panel.y = 20;
            
            addChild(panel);
        }
        
        private function onPanelDisplay(e:Event=null):void
        {
            TweenMax.to
            (
                panel, 0.75,
                {x:stageW - (panel_button.selected ? panel.width + 20 : 20), ease:Elastic.easeOut}
            );
        }
        
        private function onSelectTween(e:Event):void
        {
            blob_tween = e.target.selectedItem.data;
        }
        
        private function onSelectEase(e:Event):void
        {
            blob_ease = e.target.selectedItem.data;
        }
        
        private function onSelectBlend(e:Event):void
        {
            blob_blend = e.target.seletedItem.data;
            for each(var b:Blob in blob_vector)
            {
                b.blendMode = blob_blend;
            }
        }
        
        private function onAlpha(e:Event):void
        {
            blob_alpha = e.target.value;
        }
        
        private function onBlur(e:Event):void
        {
            blob_blur = e.target.value;
        }
        
        private function onPointMoved(b:Blob):void
        {
            b.moved = true;
        }
    }
}

import flash.geom.Point;
import flash.display.Shape;
import flash.filters.GlowFilter;
import flash.filters.BevelFilter;

class Blob extends Shape
{
    public var color:uint = 0xff0000 * Math.random();
    
    public var glow:GlowFilter = new GlowFilter(color);
    public var bevel:BevelFilter = new BevelFilter;
    (
        15, 45, 0xffffff, .15, 0xffffff, 0.75, 15, 0
    );
    
    public var moved:Boolean = true;
    public var point:Point;
    
    public function Blob(p:Point)
    {
        graphics.lineStyle(2, 0xffffff);
        graphics.beginFill(color, 1);
        graphics.drawCircle(0, 0, 5 + Math.random() * 30);
        graphics.endFill();
        
        filters = [bevel, glow];
        
        x = p.x;
        y = p.y;
    }
}


