/**
 * Copyright keno42 ( http://wonderfl.net/user/keno42 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/93wr
 */

// forked from bkzen's ひげ
package  
{
	import flash.display.BitmapData;
	import flash.display.GradientType;
	import flash.display.Graphics;
	import flash.display.Shape;
	import flash.display.Sprite;
        import flash.display.Bitmap;
        import flash.display.BitmapData;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Matrix;
        import flash.geom.Point;
        import flash.geom.Rectangle;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
        import flash.utils.getTimer;
	
	/**
	 * respect HIGE
	 * 俺もひげほしい。　
	 * クリックでエラーを修正　
	 * @author jc at bk-zen.com
	 */
	public class HigeMoja extends Sprite
	{
		private var tips:TextField;
		private var startX: Number;
		private var startY: Number;
		private var guide: Shape;
                private var bitmapData:BitmapData = new BitmapData(465, 465, true, 0x0);
                private var white: Sprite = new Sprite();
		private var count:Number = 0;
		public function HigeMoja() 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e: Event = null): void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			//
                        white.graphics.beginFill(0xFFFFFF, 0.0625);
                        white.graphics.drawRect(0,0,465,465);
			tips = new TextField();
			tips.selectable = false;
			tips.text = "drag  stage.";
			tips.autoSize = TextFieldAutoSize.LEFT;
			tips.x = (stage.stageWidth - tips.width) / 2;
			tips.y = (stage.stageHeight - tips.height) / 2;
//			addChild(tips);
                        stage.addChild(new Bitmap(bitmapData));
//			stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
                        stage.addEventListener(Event.ENTER_FRAME,onEnterFrame);
		}
		private function onEnterFrame(e:Event):void{
                    var p1:Point = new Point(
                        Math.random()*465,
                        Math.random()*465
                    );
                    var p2:Point = new Point(
                        1 + p1.x + (464-p1.x)*Math.random(),
                        1 + p1.y + (464-p1.y)*Math.random()
                    );
                    guide = new Shape();
                    
                    if( (count++ & 15) == 15 ){
                        makeFace(p1, p2);
                    }
                    bitmapData.lock();
                    bitmapData.draw(white);
                    bitmapData.draw(guide, new Matrix(1,0,0,1,guide.x,guide.y));
                    bitmapData.unlock();
                    guide.graphics.clear();

                }
		private function onMouseDown(e:MouseEvent):void 
		{
			guide = new Shape();
			addChild(guide);
			if (tips) removeChild(tips);
			stage.addEventListener(MouseEvent.MOUSE_MOVE, onMove);
			stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
			stage.removeEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
			startX = stage.mouseX;
			startY = stage.mouseY;
			guide.x = startX;
			guide.y = startY;
		}
		
		private function onMove(e:MouseEvent):void 
		{
			var g: Graphics = guide.graphics;
			g.clear();
			g.lineStyle(1, 0xCCCCCC);
			g.drawEllipse(0, 0, stage.mouseX - startX, stage.mouseY - startY);
			g.endFill();
		}
		
		private function onMouseUp(e:MouseEvent):void 
		{
			stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMove);
			stage.removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
			// 
			makeFace(new Point(startX, startY), new Point(stage.mouseX, stage.mouseY));
			stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
		}
		
		private function makeFace(p1:Point, p2:Point):void
		{
			var g: Graphics = guide.graphics;
			var minX: Number = Math.min(p1.x, p2.x);
			var minY: Number = Math.min(p1.y, p2.y);
			var maxX: Number = Math.max(p1.x, p2.x);
			var maxY: Number = Math.max(p1.y, p2.y);
			var w: Number = maxX - minX;
			var h: Number = maxY - minY;
			if (w < 1 || h < 1) return ;
			guide.x = minX;
			guide.y = minY;
			g.clear();
			g.lineStyle(1, 0x333333);
			g.drawEllipse(0, 0, w, h);
			
			g.moveTo(w / 5 * 1.3, h / 4);
			g.lineTo(w / 5 * 1.7, h / 4);
			g.moveTo(w / 5, h / 5);
			g.lineTo(w / 5 * 2, h / 5);
			
			g.moveTo(w / 5 * 3.3, h / 4);
			g.lineTo(w / 5 * 3.7, h / 4);
			g.moveTo(w / 5 * 3, h / 5);
			g.lineTo(w / 5 * 4, h / 5);
			
			g.moveTo(w / 2, h / 5 * 3);
			g.lineTo(w / 2, h / 5 * 2);
			
			g.moveTo(w / 5 * 1.5, h / 5 * 4);
			g.lineTo(w / 5 * 3.5, h / 5 * 4);
			
			g.endFill();
			
			// ひげエリア
			var higeArea: Shape = new Shape();
			var matrix: Matrix = new Matrix();
			matrix.createGradientBox(w, h, 90 * Math.PI / 180);
			higeArea.graphics.beginGradientFill(GradientType.LINEAR, [0xFFFFFF, 0x333333], [1.0, 1.0], [0xCC, 0xFF], matrix);
			higeArea.graphics.drawEllipse(0, 0, w, h);
			
			var dh: int = 1 + h / 0xFF * (0xFF - 0xCC);
			var bmd: BitmapData = new BitmapData(w, dh, true, 0xFFFFFFFF);
			bmd.lock();
			matrix = new Matrix();
			matrix.ty = dh - h;
			bmd.draw(higeArea, matrix);
			bmd.unlock();
			var n: int = bmd.width * bmd.height;
			for (var i: int = 0; i < n; i++ )
			{
				var x: int = i % bmd.width;
				var y: int = i / bmd.width;
				var c: uint = bmd.getPixel32(x, y);
				if (c != 0xFFFFFFFF)
				{
					var b: int = c & 0xFF;
					var whiskerL: Number = Math.random() * (0xFF - b) / 0xFF * 20;
					var whiskerR: Number = Math.random() * 2 * Math.PI;
					var acX: Number = x + whiskerL * Math.cos(whiskerR);
					var acY: Number = y + whiskerL * Math.sin(whiskerR) + h - dh;
					var ctrlD: Number = whiskerL * Math.random();
					var ctrlR: Number = Math.random() * 2 * Math.PI;
					var ctrlX: Number = x + ctrlD * Math.cos(ctrlR);
					var ctrlY: Number = y + ctrlD * Math.sin(ctrlR) + h - dh;
					g.lineStyle(1, 0, (0xFF - b) / 0xFF);
					g.moveTo(x, y + h - dh);
					g.curveTo(ctrlX, ctrlY, acX, acY);
				}
			}
			tips = null;
			}
		
	}
	
}