/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/93fC
 */

package {
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import net.hires.debug.Stats;
    
    // zahirの二番煎じな気がしないでもない
    public class ShaderParticle extends Sprite {
        private const PW : int = 300;
        private const PH : int = 300;
        private const PWH : int = PW * PH;
        
        private var _xv : Vector.<Number>;
        private var _a : Vector.<Number>;
        private var _c : Vector.<uint>;
        
        private var _s : Shader;
        private var _nxv : Vector.<Number>;
        private var _ct : ColorTransform;
        
        private var _space : BitmapData;
        
        public function ShaderParticle() {
            _xv = new Vector.<Number>();
            _a = new Vector.<Number>();
            _c = new Vector.<uint>();
            
            for(var i : int = 0;i < PWH;i++){
                _xv.push(465 / 2);
                _xv.push(100);
                _xv.push(Math.random() * 10 - 5);
                _xv.push(-Math.random() * 10);
                _a.push(0);
                _a.push(0.2);
                _c.push(Math.random() * 0xffffff);
            }
            
            _s = new VMoveShader();
            
            _ct = new ColorTransform(0.95, 0.95, 0.95);
            
            _nxv = new Vector.<Number>();
            _space = new BitmapData(465, 465, false, 0x000000);
            addChild(new Bitmap(_space));
            
            addChild(new Stats());
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e : Event) : void
        {
            _s.data.xv.input = _xv;
            _s.data.a.input = _a;
            _s.data.xv.width = PW;
            _s.data.xv.height = PH;
            _s.data.a.width = PW;
            _s.data.a.height = PH;
            
            var sj : ShaderJob = new ShaderJob(_s, _nxv, PW, PH);
            sj.start(true);
            _xv = _nxv;
            
            _space.lock();
            _space.colorTransform(_space.rect, _ct);
            
            for(var i : int = 0;i < PWH;i++){
                if(_xv[i * 4 + 1] > 465){
                    _xv[i * 4] = 465 / 2;
                    _xv[i * 4 + 1] = 100;
                    _xv[i * 4 + 2] = Math.random() * 10 - 5;
                    _xv[i * 4 + 3] = -Math.random() * 10;
                    _a[i * 2] = 0;
                    _a[i * 2 + 1] = 0.2;
                }
                _space.setPixel(_xv[i * 4], _xv[i * 4 + 1], _c[i]);
            }
            
            _space.unlock();
        }
    }
}

import flash.display.Shader;
import flash.utils.ByteArray;
class VMoveShader extends Shader
{

	private var vec:Vector.<int> = Vector.<int>( [ 53,143,193,9,194,64,16,69,223,174,35,40,4,204,93,2,182,96,7,1,193,163,150,32,193,236,33,160,137,108,98,244,104,41,138,122,183,4,83,146,216,128,179,162,167,247,255,159,207,12,115,55,192,109,200,194,29,230,197,166,113,254,28,149,217,214,213,187,108,237,224,28,181,174,204,43,175,106,208,58,95,23,85,137,209,52,119,245,218,23,187,38,120,46,198,66,180,90,238,155,89,85,249,156,43,114,108,185,26,155,113,177,98,24,229,117,67,2,83,136,153,90,94,240,32,233,241,182,140,131,239,212,155,196,6,25,163,236,122,58,215,157,157,13,61,9,252,231,241,55,151,224,229,215,239,115,18,78,129,169,240,12,156,136,190,164,140,133,148,196,240,238,235,157,15 ] );
	private var byteArr:ByteArray;

	public function VMoveShader():void
	{
		var len:int = vec.length;
		if(!byteArr)
		{
			byteArr = new ByteArray();
			for(var i:int=0; i<len; i++)
			{
				byteArr.writeByte( vec[i] );
			}
			byteArr.inflate();
			this.byteCode = byteArr;
		}
	}
/*
<languageVersion : 1.0;>

kernel NewFilter
<   namespace : "";
    vendor : "";
    version : 1;
    description : "";
>
{
    input image4 xv;
    input image2 a;
    output pixel4 dst;

    void
    evaluatePixel()
    {
        float2 oc = outCoord();
        pixel4 sxv = sample(xv, oc);
        pixel2 sa = sample(a, oc);
        pixel2 fv = sxv.ba + sa;
        pixel2 fx = sxv.rg + fv;
        dst = pixel4(fx.x, fx.y, fv.x, fv.y);
    }
}
*/
}