/**
 * Copyright mrhdms ( http://wonderfl.net/user/mrhdms )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/93BK
 */

package
{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.media.*;
    
    /**
     * 単純なスリットスキャン
     * @author mrhdms
     */
    [SWF(width="465", height="465", frameRate="60")]
    
    public class Main extends Sprite
    {
        private var _camera:Camera;
        private var _video:Video;
        private var _canvas:BitmapData;
        private var _rect:Rectangle;
        
        public function Main():void
        {
            if (stage)
                init();
            else
                addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            //var status:Stats = new Stats()
            
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            //カメラの設定
            try
            {
                _camera = Camera.getCamera();
                _video = new Video(stage.stageWidth, stage.stageHeight);
                _camera.setMode(stage.stageWidth, stage.stageHeight, 60);
                _video.attachCamera(_camera);
            }
            catch (err:Error)
            {
                throw new Error("カメラ取得失敗");
            }
            //書き込み用キャンバス
            _canvas = new BitmapData(_camera.width, _camera.height, false);
            var bmp:Bitmap = new Bitmap(_canvas);
            
            //キャプチャ領域
            _rect = new Rectangle(_camera.width / 2, 0, 1, _camera.height);
            
            var line:Shape = new Shape();
            line.graphics.beginFill(0xFF0000);
            line.graphics.drawRect(0, 0, 1, _camera.height);
            line.graphics.endFill();
            line.x = _camera.width / 2;
            
            addChild(bmp);
            addChild(line);
            //addChild(status);
            addEventListener(Event.ENTER_FRAME, update);
        }
        
        private function update(e:Event):void
        {
            var tmpBmd:BitmapData = new BitmapData(_camera.width, _camera.height);
            tmpBmd.draw(_video);
            _canvas.lock();
            _canvas.copyPixels(_canvas, new Rectangle(0, 0, _camera.width / 2 + 1, _camera.height), new Point(-1, 0));
            _canvas.copyPixels(_canvas, new Rectangle(_camera.width / 2, 0, _camera.width / 2, _camera.height), new Point(_camera.width / 2 + 1, 0));
            _canvas.copyPixels(tmpBmd, _rect, new Point(_camera.width / 2, 0));
            _canvas.unlock();
        }
    
    }

}