/**
 * Copyright _wonder ( http://wonderfl.net/user/_wonder )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/92Ve
 */

// forked from _wonder's セグメントをマウスに向ける：IK(1)
// forked from _wonder's セグメントを描画：IK(1)
package {
    import flash.display.Sprite;
    import flash.events.Event;
    
    public class InverseKinematics extends Sprite {
            private var seg0:Segment;
            
        public function InverseKinematics() {
            init();
        }
        
        private function init():void {
                seg0 = new Segment(100, 20);
                addChild( seg0 );
                
                addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame( e:Event ):void {
            var dx:Number = mouseX - seg0.x;
            var dy:Number = mouseY - seg0.y;
            var angle:Number = Math.atan2( dy, dx );
            seg0.rotation = angle * 180 / Math.PI;
            
            //セグメントの位置をずらす
            var w:Number = seg0.getPin().x - seg0.x;
            var h:Number = seg0.getPin().y - seg0.y;
            seg0.x = mouseX - w;
            seg0.y = mouseY - h;
        }

    }
}
import flash.display.Sprite;
import flash.geom.Point;

class Segment extends Sprite {
    private var color:uint;
    private var segmentWidth:Number;
    private var segmentHeight:Number;
    
    public var vx:Number = 0;
    public var vy:Number = 0;
    
    public function Segment(segmentWidth:Number,segmentHeight:Number,color:uint=0xffffff){
        this.segmentWidth = segmentWidth;
        this.segmentHeight = segmentHeight;
        this.color = color;
        init();
    }
    
    public function init():void {
        //セグメントの描画
        graphics.lineStyle( 0 );
        graphics.beginFill( color );
        graphics.drawRoundRect( -segmentHeight / 2, -segmentHeight / 2, segmentWidth+segmentHeight, segmentHeight, segmentHeight, segmentHeight );
        graphics.endFill();
        
        //ピン
        graphics.drawCircle( 0, 0, 2 );
        
        graphics.lineStyle( 0, 0xcc0000 );
        graphics.beginFill( 0xcc0000 );
        graphics.drawCircle( segmentWidth, 0, 2 );
    }
    
    public function getPin():Point {
        var angle:Number = rotation * Math.PI / 180;
        var xPos:Number = x + Math.cos( angle ) * segmentWidth;
        var yPos:Number = y + Math.sin( angle ) * segmentWidth;
        return new Point( xPos, yPos );
    }
}