/**
 * Copyright osamX ( http://wonderfl.net/user/osamX )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/92G0
 */

// forked from checkmate's Checkmate vol.5 Amateur
/**
 * 遊び方：
 * 1. フルスクリーンにします。
 * 2. マウスが右向きになるように置きます。
 * 3. マウスを左手で押さえます。
 * 4. 右手をマウスホイールの上に置き、左右に動かします。
 * 5. 左クリック、ホイールクリックしてみると...？
 * 
 * ヒント:
 *    ホイールクリック3回
 * 
 * 　ソースはメッチャクチャのグッチャグチャ。あんまり見ないでね。
 *  http://flash-scope.com/?p=709
 */

package {
	import flash.display.*;
	import flash.events.*;
	import flash.utils.*;
	import flash.net.*;
	import flash.system.*;
	import jp.progression.commands.*;
	import jp.progression.commands.lists.*;
	import jp.progression.commands.display.*;
	import jp.progression.commands.net.*;
	import jp.progression.commands.tweens.*;
	import jp.progression.events.*;
	
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.easing.*;
	import org.libspark.betweenas3.tweens.ITween;
	import org.libspark.betweenas3.events.TweenEvent;
	import flash.system.Security;
	
	public class Nadenade extends Sprite {
		public static var GRAPHICS_URL:String = "http://swf.wonderfl.net/static/assets/checkmate05/wancoProfessional.swf";
		
		public var stayMotion:MovieClip;
		public var jumpMotion:MovieClip;
		public var highJumpMotion:MovieClip;
		public var walkMotion:MovieClip;
		public var runMotion:MovieClip;
		public var squatMotion:MovieClip;
		public var questionMotion:MovieClip;
		public var exclamationMotion:MovieClip;
		public var heartMotion:MovieClip;
		public var poutMotion:MovieClip;
		public var starMotion:MovieClip;
		public var singMotion:MovieClip;
		public var sleepMotion:MovieClip;
		public var wakeMotion:MovieClip;
		
		private const SIZE:uint = 465;
		private var hand:MyHand;
		private var lc:LocalConnectionEx;
		private var motionList:Array;
		private var guchaflg:Boolean = false;
		private var singflg:Boolean = false;
		private var achaflg:Boolean = false;
		private var eraseflg:Boolean = false;
		private var lastAchaTime:int;
		
		private const NUM:uint = 20;
		private var particles:Array = [];
		private var fragments:Array = [];
		
		private const HX:Number = 0;
		private const HY:Number = 50;
		
		public function Nadenade () {
			super();
			//Security.allowDomain("flash-scope.com");
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			var com:SerialList = new SerialList();
			com.addCommand(
				new LoadSWF( new URLRequest( GRAPHICS_URL ) ),
				function():void {
					var loader:Loader = Loader( this.latestData );
					var domain:ApplicationDomain = loader.contentLoaderInfo.applicationDomain;
					
					stayMotion = new ( domain.getDefinition( "StayMotion" ) as Class );
					jumpMotion = new ( domain.getDefinition( "JumpMotion" ) as Class );
					highJumpMotion = new ( domain.getDefinition( "HighJumpMotion" ) as Class );
					walkMotion = new ( domain.getDefinition( "WalkMotion" ) as Class );
					runMotion = new ( domain.getDefinition( "RunMotion" ) as Class );
					squatMotion = new ( domain.getDefinition( "SquatMotion" ) as Class );
					questionMotion = new ( domain.getDefinition( "QuestionMotion" ) as Class );
					exclamationMotion = new ( domain.getDefinition( "ExclamationMotion" ) as Class );
					heartMotion = new ( domain.getDefinition( "HeartMotion" ) as Class );
					poutMotion = new ( domain.getDefinition( "PoutMotion" ) as Class );
					starMotion = new ( domain.getDefinition( "StarMotion" ) as Class );
					singMotion = new ( domain.getDefinition( "SingMotion" ) as Class );
					sleepMotion = new ( domain.getDefinition( "SleepMotion" ) as Class );
					wakeMotion = new ( domain.getDefinition( "WakeMotion" ) as Class );
				},
				hand = new MyHand()
			);
			com.addEventListener(ExecuteEvent.EXECUTE_COMPLETE,onLoadSWF);
			com.execute();
		}
		
		private function onLoadSWF(e:Event):void {
			motionList = [
				stayMotion,		//0
				walkMotion,		//1
				runMotion,		//2
				squatMotion,	//3
				questionMotion,	//4
				exclamationMotion,//5
				heartMotion,	//6
				poutMotion,		//7
				singMotion,		//8
				sleepMotion,	//9
				wakeMotion		//10
			];
			
			for each( var motion:MovieClip in motionList ) {
				addChild(motion);
				motion.x = SIZE / 2;
				motion.y = SIZE / 2 + 100;
				motion.scaleX = motion.scaleY = 3;
			}
			freeMotion();
			
			hand.x = HX;
			hand.y = HY;
			hand.alpha = 0;
			addChild(hand);
			var handframe:int = 0;
			var cnt:int = 0;
			var lastNadeTime:int;
			const SPEED:uint = 2;
			var buruburu:Boolean = false;
			stage.addEventListener(MouseEvent.MOUSE_WHEEL, function(e:MouseEvent):void {
				resetHand();
				eraseflg = true;
				if (!singflg && !guchaflg && !achaflg) {
					if (e.delta > 0) cnt++;
					else if (e.delta < 0) cnt--;
					if (Math.abs(cnt) >= SPEED) {
						handframe += int(cnt / SPEED);
						cnt = 0;
						if (handframe < 0) handframe = 0;
						else if (handframe > 4) handframe = 4;
					}
					hand.show(handframe);
					hand.alpha = 0.6;
					lastNadeTime = getTimer();
					showMotion(6);
				}
			});
			var tim:uint = 0;
			addEventListener(Event.ENTER_FRAME, function(e:Event):void {
				if (++tim % 2 == 0) {
					tim = 0;
					if (!achaflg && !guchaflg && hand.alpha > 0 && getTimer() - lastNadeTime > 500) {
						eraseflg = true;
						hand.alpha -= 0.1;
						if (hand.alpha <= 0) {
							eraseflg = false;
							freeMotion();
						}
					}
					if (achaflg) {
						buruburu = !buruburu;
						if (buruburu) hand.x = HX + 10;
						else hand.x = HX;
					}
				}
				
				for (var i:uint = 0; i < particles.length; i++) {
					var p:Particle = particles[i];
					if(p && p.y < 500){
						p.vy += 1.5;
						p.vx *= 0.987;
						p.vy *= 0.987;
						p.x += p.vx;
						p.y += p.vy;
						fragments[i].x = p.x;
						fragments[i].y = p.y;
					}else if(fragments[i]){
						removeChild(fragments[i]);
						fragments[i] = null;
						particles[i] = null;
					}
				}
			});
			wheelClickHandler();
		}
		
		private function wheelClickHandler():void {
			var loader:Loader = new Loader();
			var request:URLRequest = new URLRequest("http://flash-scope.com/wonderfl/ClickTest/mouse.swf");
			loader.load(request);
			
			lc = new LocalConnectionEx();
			lc.allowDomain('*');
			lc.connect("_wonderflconnection");
			
			var frame:int = 1;
			var guchaNum:uint = 0;
			
			lc.leftDown = function():void {
				resetHand();
				if (!singflg && !guchaflg && !achaflg && !eraseflg) {
					showMotion(8);
					addEventListener(Event.ENTER_FRAME, function(e:Event):void {
						if (!singflg) { //do once
							singMotion.gotoAndPlay(1);
							singMotion.wc2.wc3.gotoAndPlay(2);
							singflg = true;
						}
						frame++;
						if (frame > 31) {
							singflg = false;
							frame = 1;
							singMotion.stop();
							removeEventListener(Event.ENTER_FRAME, arguments.callee);
							freeMotion();
						}
					});
				}
			};
			
			lc.wheelDown = function():void {
				resetHand();
				if (!singflg && !guchaflg && !achaflg) {
					showMotion(10);
					guchaflg = true;
					hand.alpha = 0.6;
					BetweenAS3.parallel(
						BetweenAS3.tween(hand, {y:120},null,0.1),
						BetweenAS3.tween(wakeMotion, { height:50, width:250 }, null, 0.3, Back.easeOutWith(5.0))
					).play();
					createFragment();
				}
			};
			
			lc.wheelUp = function():void {
				if(!singflg && guchaflg && !achaflg){
					var tween:ITween = BetweenAS3.tween(wakeMotion, { height:55.8 * 3, width:60.45 * 3 }, null, 0.5, Elastic.easeOut);
					tween.addEventListener(TweenEvent.COMPLETE, function(e:TweenEvent):void {
						freeMotion();
						guchaflg = false;
						eraseflg = false;
						if (++guchaNum >= 3) {
							lastAchaTime = getTimer();
							guchaNum = 0;
							hand.show(5);
							hand.alpha = 1;
							achaflg = true;
							showMotion(4);
						}
					});
					BetweenAS3.parallel(
						BetweenAS3.tween(hand, {y:HY},null,0.05),
						tween
					).play();
				}
			};
		}
		
		private function showMotion(num:uint):void {
			var i:uint = 0;
			for each( var motion:MovieClip in motionList ) {
				if (i++ == num) {
					motion.visible = true;
					//motion.stop();
				}else {
					motion.visible = false;
					//motion.gotoAndPlay(1);
				}
			}
		}
		
		private function freeMotion():void {
			var num:uint = int(Math.random() * 8);
			switch(num) {
				case 6: num = 7; break;
				case 7: num = 9; break;
			}
			showMotion(num);
		}
		
		private function resetHand():void {
			if (achaflg && getTimer()-lastAchaTime>1000) {
				hand.x = HX;
				achaflg = false;
				eraseflg = false;
				hand.show(0);
				hand.alpha = 0;
			}
		}
		
		private function createFragment(e:MouseEvent = null):void {
			var l:uint = fragments.length;
			for (var i:uint = 0; i < NUM; i++) {
				var p:Particle = new Particle(465/2, 330, 40 * Math.random()-20, -20 * Math.random());
				particles.push(p);
				
				var s:Sprite = new Sprite();
				s.graphics.lineStyle(5, 0x330000);
				s.graphics.beginFill(0xCC6633);
				//s.graphics.beginFill(0xFFFFFF*Math.random());
				s.graphics.drawCircle(0, 0, 5);
				s.graphics.endFill();
				s.x = p.x;
				s.y = p.y;
				fragments.push(s);
				addChildAt(fragments[l + i],0);
				//addChild(fragments[l + i]);
			}
		}
		
	}
}

import flash.display.Loader;
import flash.display.Sprite;
import flash.net.URLRequest;
import flash.system.LoaderContext;

class MyHand extends Sprite 
{
	public var images:Array = [];
	public function MyHand():void 
	{
		for (var i:uint = 1; i <= 6; i++){
			var loader:Loader = new Loader();
			loader.load(new URLRequest("http://flash-scope.com/wonderfl/Wanco/img"+i+".png"), new LoaderContext(true));
			images.push(loader);
			addChild(images[i - 1]);
		}
		show(0);
	}
	public function show(num:uint):void {
		for (var i:uint = 0; i < 6; i++) {
			if(i==num) images[i].visible = true;
			else images[i].visible = false;
		}
		
	}
}

class Particle 
{
	public var x:Number;
	public var y:Number;
	public var vx:Number;
	public var vy:Number;
	
	public function Particle(_x:Number, _y:Number,_vx:Number,_vy:Number):void {
		x = _x;
		y = _y;
		vx = _vx;
		vy = _vy;
	}
}

import flash.net.LocalConnection; 
dynamic class LocalConnectionEx extends LocalConnection  
{
}