/**
 * Copyright yd_niku ( http://wonderfl.net/user/yd_niku )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/91HU
 */

package {
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.text.*;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            // write as3 code here..
            addEventListener( Event.ADDED_TO_STAGE, onInit );
        }
        private var _reportField:TextField;
        private function onInit( e:Event ):void {
            _reportField = new TextField();
            addChild( _reportField );
            _reportField.multiline = true;
            _reportField.autoSize = TextFieldAutoSize.LEFT;
            _reportField.text = "Vector3D TEST\n\n";
            
            // Zero Point
            var vec0:Vector3D = new Vector3D();
            
            // Vector 1
            var vec:Vector3D = new Vector3D( 100, 250 );
            draw( vec0, vec, 0xFF0000 );
            
            _reportField.appendText( "vec.length = "+vec.length+"\n" );
            _reportField.appendText( "vec.lengthSquared = "+vec.lengthSquared+"\n" );
            _reportField.appendText( "vec.w= "+vec.w+"\n" );
            
            // vector 2
            var vec2:Vector3D = new Vector3D( 200, 50 );
            
            // Added
            var vec3:Vector3D = vec.add( vec2 );
            draw( vec, vec3, 0x0000FF );
            
            _reportField.appendText( "vec3 = "+vec3.toString()+"\n" );
            
            // IncrementBy
            vec3.incrementBy( new Vector3D( 2.4, 2, 1 ) );
            _reportField.appendText( "vec.incrementBy = "+vec3.toString()+"\n" );
            
            // DecrementBy
            vec3.decrementBy( new Vector3D( 2, 2, 1 ) );
            _reportField.appendText( "vec.decrementBy = "+vec3.toString()+"\n" );
            
            // ScaledBy
            vec.normalize();
            vec.scaleBy(200);
            draw( vec0, vec, 0xFFCCFF );
            
            // Normalize
            var maxLength:Number = Math.min( 150, vec.length );
            vec.normalize();
            vec.scaleBy(maxLength);
            _reportField.appendText( "Math.min( 150, vec.length ) => "+vec.length +"\n" );
            draw( vec0, vec, 0x00FFFF );
            
            var vec4:Vector3D = vec.clone();
            var vec5:Vector3D = new Vector3D(120,0);
            var vec5Length:Number = vec5.length;
            draw( vec0, vec5, 0xCC6600 );
            
            // DotProjection
            vec4.normalize();
            var dotProduct:Number = vec4.dotProduct( vec5 );
            vec4.scaleBy(dotProduct);
            _reportField.appendText( "vec･vec5 = "+dotProduct+"\n" );
            _reportField.appendText( "vec･vec5 => rot "+Math.acos(dotProduct/vec5Length)/Math.PI*180+"\n" );
            draw( vec0, vec4, 0x006600 );
            
        }
        private function draw( v1:Vector3D, v2:Vector3D, c:uint ):void {
            graphics.lineStyle( 0, c );
            graphics.moveTo( v1.x, v1.y );
            graphics.lineTo( v2.x, v2.y );
        }
    }
}