/**
 * Copyright Jenya ( http://wonderfl.net/user/Jenya )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/90P9
 */

// forked from hironanix's forked from: TransitPhoto (1)
// forked from ProjectNya's TransitPhoto (1)
////////////////////////////////////////////////////////////////////////////////
// [AS3.0] TransitPhotoクラスだ！ (2)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1026
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;

    [SWF(backgroundColor="#FFFFFF", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private static var basePath:String = "http://www.project-nya.jp/images/flash/";
        private var transit:TransitPhoto;
        private var photoList:Array;
        private var itemList:Array;
        private var photo:Label;
        private var txt:Label;

        public function Main() {
            Wonderfl.capture_delay(4);
            init();
        }

        private function init():void {
            createTitle();
            transit = new TransitPhoto();
            addChild(transit);
            transit.x = 72;
            transit.y = 122;
            photoList = new Array();
            photoList.push(basePath + "transitPhoto_photo1.jpg");
            photoList.push(basePath + "transitPhoto_photo2.jpg");
            photoList.push(basePath + "transitPhoto_photo3.jpg");
            photoList.push(basePath + "transitPhoto_photo4.jpg");
            transit.dataProvider = photoList;
            //
            var fade:Fade = new Fade();
            var brightness:Brightness = new Brightness();
            var block1:Block = new Block("++", 40, 40, 8, 6);
            block1.transitName = "block [1]";
            var block2:Block = new Block("+-", 40, 40, 8, 6);
            block2.transitName = "block [2]";
            var block3:Block = new Block("-+", 40, 40, 8, 6);
            block3.transitName = "block [3]";
            var block4:Block = new Block("--", 40, 40, 8, 6);
            block4.transitName = "block [4]";
            var blindX:Blind = new Blind("x", 20, 240, 16, 1);
            blindX.transitName = "blind [x]";
            var blindY:Blind = new Blind("y", 320, 20, 1, 12);
            blindY.transitName = "blind [y]";
            var circle:Circle = new Circle("++", 30, 40, 40, 8, 6);
            circle.transitName = "circle";
            //
            var transitList:Array = new Array();
            transitList.push(fade);
            transitList.push(brightness);
            transitList.push(block1);
            transitList.push(block2);
            transitList.push(block3);
            transitList.push(block4);
            transitList.push(blindX);
            transitList.push(blindY);
            transitList.push(circle);
            transitList = ArrayUtils.shuffle(transitList);
            //
            transit.label(photo, txt);
            transit.transitType(transitList);
        }
        private function createTitle():void {
            var title:Label = new Label(150);
            addChild(title);
            title.x = 255;
            title.y = 98;
            title.textColor = 0x333333;
            title.text = "[AS3.0] TransitPhoto";
            var order:Label = new Label(120);
            addChild(order);
            order.x = 75;
            order.y = 368;
            order.textColor = 0x333333;
            order.text = "photo";
            var type:Label = new Label(120);
            addChild(type);
            type.x = 175;
            type.y = 368;
            type.textColor = 0x333333;
            type.text = "transit";
            photo = new Label(60);
            addChild(photo);
            photo.x = 125;
            photo.y = 368;
            photo.textColor = 0x000000;
            txt = new Label(80);
            addChild(txt);
            txt.x = 230;
            txt.y = 368;
            txt.textColor = 0x000000;
        }

    }

}


//////////////////////////////////////////////////
// TransitPhotoクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.events.Event;
import flash.utils.Timer;
import flash.events.TimerEvent;

class TransitPhoto extends Sprite {
    private var loaderList:Array;
    private var photoList:Array;
    private var max:uint;
    private var transitList:Array;
    private var transitID:uint = 0;
    private var hideID:uint = 0;
    private var showID:uint = 0;
    private var timer:Timer;
    public var interval:uint = 2;
    private var transit:*;
    public static const COMPLETE:String = "transitComplete";
    private var photo:Label;
    private var txt:Label;

    public function TransitPhoto() {
    }

    public function set dataProvider(list:Array):void {
        photoList = list;
        max = photoList.length;
        initialize();
    }
    public function transitType(list:Array):void {
        reset();
        transitList = list;
        exchangeTransit();
        load(showID);
    }
    private function initialize():void {
        loaderList = new Array();
        for (var n:uint = 0; n < max; n++) {
            var loader:PhotoLoader = new PhotoLoader();
            loaderList.push(loader);
            loader.addEventListener(PhotoLoader.INIT, loadInit, false, 0, true);
        }
    }
    private function reset():void {
        if (transit) {
            transit.reset();
            transit.removeEventListener(TransitPhoto.COMPLETE, setInterval);
        }
        if (timer) {
            timer.removeEventListener(TimerEvent.TIMER_COMPLETE, transitPhoto);
            timer.stop();
        }
        transitID = 0;
        var hide:PhotoLoader = loaderList[hideID];
        var show:PhotoLoader = loaderList[showID];
        if (contains(hide)) removeChild(hide);
        if (contains(show)) removeChild(show);
        hideID = 0;
        showID = 0;
    }
    private function load(id:uint):void {
        var loader:PhotoLoader = loaderList[id];
        var filePath:String = photoList[id];
        loader.load(filePath, true);
    }
    private function loadInit(evt:Event):void {
        var hide:PhotoLoader = loaderList[hideID];
        var show:PhotoLoader = loaderList[showID];
        if (hide) addChild(hide);
        addChild(show);
        transitEffect();
    }
    private function transitEffect():void {
        var show:PhotoLoader = loaderList[showID];
        transit.effect(show);
        transit.addEventListener(TransitPhoto.COMPLETE, setInterval, false, 0, true);
    }
    private function setInterval(evt:Event):void {
        transit.removeEventListener(TransitPhoto.COMPLETE, setInterval);
        timer = new Timer(1000*interval, 1);
        timer.addEventListener(TimerEvent.TIMER_COMPLETE, transitPhoto, false, 0, true);
        timer.start();
    }
    private function transitPhoto(evt:TimerEvent):void {
        timer.removeEventListener(TimerEvent.TIMER_COMPLETE, transitPhoto);
        var hide:PhotoLoader = loaderList[hideID];
        if (hideID != showID) removeChild(hide);
        hideID = showID;
        showID ++;
        if (showID >= max) showID = 0;
        exchangeTransit();
        load(showID);
    }
    private function exchangeTransit():void {
        var id:uint = transitID%transitList.length;
        transit = transitList[id];
        photo.text = "[" + (hideID+1) + "-" + (showID+1) + "] ";
        txt.text = transit.transitName;
        transitID ++;
    }
    public function label(p:Label, t:Label):void {
        photo = p;
        txt = t;
    }

}


//////////////////////////////////////////////////
// PhotoLoaderクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Loader;
import flash.display.LoaderInfo;
import flash.net.URLRequest;
import flash.display.Bitmap;
import flash.events.Event;
import flash.events.IOErrorEvent;
import flash.events.HTTPStatusEvent;
import flash.events.SecurityErrorEvent;
import flash.system.LoaderContext;

class PhotoLoader extends Sprite {
    private var loader:Loader;
    private var info:LoaderInfo;
    public var content:*;
    private var smoothing:Boolean;
    public static const IO_ERROR:String = IOErrorEvent.IO_ERROR;
    public static const HTTP_STATUS:String = HTTPStatusEvent.HTTP_STATUS;
    public static const SECURITY_ERROR:String = SecurityErrorEvent.SECURITY_ERROR;
    public static const INIT:String = Event.INIT;
    public static const COMPLETE:String = Event.COMPLETE;

    public function PhotoLoader() {
        loader = new Loader();
        info = loader.contentLoaderInfo;
    }

    public function load(file:String, s:Boolean = false):void {
        smoothing = s;
        info.addEventListener(IOErrorEvent.IO_ERROR, ioerror, false, 0, true);
        info.addEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus, false, 0, true);
        info.addEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror, false, 0, true);
        info.addEventListener(Event.INIT, initialize, false, 0, true);
        info.addEventListener(Event.COMPLETE, complete, false, 0, true);
        try {
            loader.load(new URLRequest(file), new LoaderContext(true));
        } catch (err:Error) {
            trace(err.message);
        }
    }
    public function unload():void {
        loader.unload();
    }
    private function ioerror(evt:IOErrorEvent):void {
        loader.unload();
        dispatchEvent(new Event(PhotoLoader.IO_ERROR));
    }
    private function httpstatus(evt:HTTPStatusEvent):void {
        dispatchEvent(new Event(PhotoLoader.HTTP_STATUS));
    }
    private function securityerror(evt:SecurityErrorEvent):void {
        dispatchEvent(new Event(PhotoLoader.SECURITY_ERROR));
    }
    private function initialize(evt:Event):void {
        if (smoothing) {
            content = Bitmap(info.content);
            content.smoothing = true;
        } else {
            content = info.content;
        }
        dispatchEvent(new Event(PhotoLoader.INIT));
    }
    private function complete(evt:Event):void {
        info.removeEventListener(IOErrorEvent.IO_ERROR, ioerror);
        info.removeEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus);
        info.removeEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror);
        info.removeEventListener(Event.INIT, initialize);
        info.removeEventListener(Event.COMPLETE, complete);
        addChild(loader);
        dispatchEvent(new Event(PhotoLoader.COMPLETE));
    }
    public function centerize():void {
        content.x = -uint(content.width*0.5);
        content.y = -uint(content.height*0.5);
    }

}


//////////////////////////////////////////////////
// transitionsクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.events.Event;

class Fade extends Sprite {
    public static var className:String = "Fade";
    public var transitName:String = "fade";
    private var loader:PhotoLoader;
    private static var speed:Number = 0.05;
    public static const COMPLETE:String = "complete";

    public function Fade() {
    }

    public function effect(target:PhotoLoader):void {
        loader = target;
        loader.alpha = 0;
        addEventListener(Event.ENTER_FRAME, transit, false, 0, true);
    }
    private function transit(evt:Event):void {
        loader.alpha += speed;
        if (loader.alpha >= 1) {
            loader.alpha = 1;
            removeEventListener(Event.ENTER_FRAME, transit);
            dispatchEvent(new Event(TransitPhoto.COMPLETE));
        }
    }
    public function reset():void {
        if (loader) {
            loader.alpha = 1;
        }
    }

}


import flash.display.Sprite;
import flash.events.Event;

class Brightness extends Sprite {
    public static var className:String = "Brightness";
    public var transitName:String = "brightness";
    private var loader:PhotoLoader;
    private var _brightOffset:Number = 0;
    private static var speed:Number = 5;
    public static const COMPLETE:String = "complete";

    public function Brightness() {
    }

    public function effect(target:PhotoLoader):void {
        loader = target;
        brightOffset = 100;
        addEventListener(Event.ENTER_FRAME, transit, false, 0, true);
    }
    private function transit(evt:Event):void {
        brightOffset -= speed;
        if (brightOffset <= 0) {
            brightOffset = 0;
            removeEventListener(Event.ENTER_FRAME, transit);
            dispatchEvent(new Event(TransitPhoto.COMPLETE));
        }
    }
    public function get brightOffset():Number {
        return _brightOffset;
    }
    public function set brightOffset(param:Number):void {
        _brightOffset = param;
        ColorManager.brightOffset(loader, _brightOffset);
    }
    public function reset():void {
        if (loader) {
            brightOffset = 0;
        }
    }

}


import flash.display.Sprite;
import flash.events.Event;

class Block extends Sprite {
    public static var className:String = "Block";
    public var transitName:String = "block";
    private var loader:PhotoLoader;
    private var type:String;
    private var mWidth:uint;
    private var mHeight:uint;
    private var cols:uint;
    private var rows:uint;
    private var blocks:Sprite;
    private var blockList:Array;
    private var completed:uint = 0;
    public static const COMPLETE:String = "complete";

    public function Block(t:String, w:uint, h:uint, c:uint, r:uint) {
        type = t;
        mWidth = w;
        mHeight = h;
        cols = c;
        rows = r;
        init();
    }

    private function init():void {
        if (!blocks) {
            blocks = new Sprite();
            blockList = new Array();
            createBlocks();
        }
    }
    public function effect(target:PhotoLoader):void {
        loader = target;
        loader.addChild(blocks);
        loader.mask = blocks;
        transit()
    }
    private function transit():void {
        for (var n:uint = 0; n < rows*cols; n++) {
            var block:BlockMask = blockList[n];
            block.effect();
            block.addEventListener(Block.COMPLETE, complete, false, 0, true);
        }
    }
    private function complete(evt:Event):void {
        evt.target.removeEventListener(Block.COMPLETE, complete);
        completed ++;
        if (completed >= rows*cols) {
            reset();
            dispatchEvent(new Event(TransitPhoto.COMPLETE));
        }
    }
    private function createBlocks():void {
        for (var r:uint = 0; r < rows; r++) {
            for (var c:uint = 0; c < cols; c++) {
                var xPos:uint;
                var yPos:uint;
                switch (type) {
                    case "++" :
                        xPos = mWidth/2 + mWidth*(c%cols);
                        yPos = mHeight/2 + mHeight*r;
                        break;
                    case "+-" :
                        xPos = mWidth/2 + mWidth*(c%cols);
                        yPos = mHeight/2 + mHeight*(rows - r - 1);
                        break;
                    case "-+" :
                        xPos = mWidth/2 + mWidth*((cols - c - 1)%cols);
                        yPos = mHeight/2 + mHeight*r;
                        break;
                    case "--" :
                        xPos = mWidth/2 + mWidth*((cols - c - 1)%cols);
                        yPos = mHeight/2 + mHeight*(rows - r - 1);
                        break;
                }
                var block:BlockMask = new BlockMask(mWidth, mHeight);
                blockList.push(block);
                block.x = xPos;
                block.y = yPos;
                block.generation = r + c;
                blocks.addChild(block);
            }
        }
    }
    public function reset():void {
        if (loader) {
            if (loader.contains(blocks)) {
                loader.removeChild(blocks);
                loader.mask = null;
            }
        }
        close();
    }
    private function close():void {
        for (var n:uint = 0; n < rows*cols; n++) {
            var block:BlockMask = blockList[n];
            block.close();
            block.removeEventListener(Block.COMPLETE, complete);
        }
        completed = 0;
    }

}


import flash.display.Sprite;
import flash.events.Event;
import flash.utils.Timer;
import flash.events.TimerEvent;

class BlockMask extends Sprite {
    public var generation:uint;
    private var mWidth:uint;
    private var mHeight:uint;
    private var _scale:Number = 1;
    private var timer:Timer;
    private static var deceleration:Number = 0.4;
    public static const COMPLETE:String = "complete";

    public function BlockMask(w:uint, h:uint) {
        mWidth = w;
        mHeight = h;
        init();
    }

    private function init():void {
        graphics.beginFill(0x000000);
        graphics.drawRect(-mWidth/2, -mHeight/2, mWidth, mHeight);
        graphics.endFill();
    }
    public function effect():void {
        scale = 0;
        var offset:uint = 300*(generation + 1);
        timer = new Timer(offset, 1);
        timer.addEventListener(TimerEvent.TIMER_COMPLETE, open, false, 0, true);
        timer.start();
    }
    private function open(evt:TimerEvent):void {
        timer.removeEventListener(TimerEvent.TIMER_COMPLETE, open);
        addEventListener(Event.ENTER_FRAME, transit, false, 0, true);
    }
    private function transit(evt:Event):void {
        scale += (1- scale)*deceleration;
        if (Math.abs(1 - scale) < 0.005) {
            scale = 1;
            removeEventListener(Event.ENTER_FRAME, transit);
            dispatchEvent(new Event(BlockMask.COMPLETE));
        }
    }
    public function get scale():Number {
        return _scale;
    }
    public function set scale(param:Number):void {
        _scale = param;
        scaleX = scaleY = _scale;
    }
    public function close():void {
        scale = 0;
        timer.removeEventListener(TimerEvent.TIMER_COMPLETE, open);
        timer.stop();
        removeEventListener(Event.ENTER_FRAME, transit);
    }

}


import flash.display.Sprite;
import flash.events.Event;

class Blind extends Sprite {
    public static var className:String = "Blind";
    public var transitName:String = "blind";
    private var loader:PhotoLoader;
    private var type:String;
    private var mWidth:uint;
    private var mHeight:uint;
    private var cols:uint;
    private var rows:uint;
    private var blinds:Sprite;
    private var blindList:Array;
    private var completed:uint = 0;
    public static const COMPLETE:String = "complete";

    public function Blind(t:String, w:uint, h:uint, c:uint, r:uint) {
        type = t;
        mWidth = w;
        mHeight = h;
        cols = c;
        rows = r;
        init();
    }

    private function init():void {
        if (!blinds) {
            blinds = new Sprite();
            blindList = new Array();
            createBlinds();
        }
    }
    public function effect(target:PhotoLoader):void {
        loader = target;
        loader.addChild(blinds);
        loader.mask = blinds;
        transit()
    }
    private function transit():void {
        for (var n:uint = 0; n < rows*cols; n++) {
            var blind:BlindMask = blindList[n];
            blind.effect();
            blind.addEventListener(Blind.COMPLETE, complete, false, 0, true);
        }
    }
    private function complete(evt:Event):void {
        evt.target.removeEventListener(Blind.COMPLETE, complete);
        completed ++;
        if (completed >= rows*cols) {
            reset();
            dispatchEvent(new Event(TransitPhoto.COMPLETE));
        }
    }
    private function createBlinds():void {
        for (var r:uint = 0; r < rows; r++) {
            for (var c:uint = 0; c < cols; c++) {
                var xPos:uint = mWidth/2 + mWidth*(c%cols);
                var yPos:uint = mHeight/2 + mHeight*r;
                var blind:BlindMask = new BlindMask(type, mWidth, mHeight);
                blindList.push(blind);
                blind.x = xPos;
                blind.y = yPos;
                blind.generation = r + c;
                blinds.addChild(blind);
            }
        }
    }
    public function reset():void {
        if (loader) {
            if (loader.contains(blinds)) {
                loader.removeChild(blinds);
                loader.mask = null;
            }
        }
        close();
    }
    private function close():void {
        for (var n:uint = 0; n < rows*cols; n++) {
            var blind:BlindMask = blindList[n];
            blind.close();
            blind.removeEventListener(Blind.COMPLETE, complete);
        }
        completed = 0;
    }

}


import flash.display.Sprite;
import flash.events.Event;
import flash.utils.Timer;
import flash.events.TimerEvent;

class BlindMask extends Sprite {
    public var generation:uint;
    private var type:String;
    private var mWidth:uint;
    private var mHeight:uint;
    private var _scale:Number = 1;
    private var timer:Timer;
    private static var deceleration:Number = 0.4;
    public static const COMPLETE:String = "complete";

    public function BlindMask(t:String, w:uint, h:uint) {
        type = t;
        mWidth = w;
        mHeight = h;
        init();
    }

    private function init():void {
        graphics.beginFill(0x000000);
        graphics.drawRect(-mWidth/2, -mHeight/2, mWidth, mHeight);
        graphics.endFill();
    }
    public function effect():void {
        scale = 0;
        var offset:uint = 300*(generation + 1);
        timer = new Timer(offset, 1);
        timer.addEventListener(TimerEvent.TIMER_COMPLETE, open, false, 0, true);
        timer.start();
    }
    private function open(evt:TimerEvent):void {
        timer.removeEventListener(TimerEvent.TIMER_COMPLETE, open);
        addEventListener(Event.ENTER_FRAME, transit, false, 0, true);
    }
    private function transit(evt:Event):void {
        scale += (1- scale)*deceleration;
        if (Math.abs(1 - scale) < 0.005) {
            scale = 1;
            removeEventListener(Event.ENTER_FRAME, transit);
            dispatchEvent(new Event(BlindMask.COMPLETE));
        }
    }
    public function close():void {
        scale = 0;
        timer.removeEventListener(TimerEvent.TIMER_COMPLETE, open);
        timer.stop();
        removeEventListener(Event.ENTER_FRAME, transit);
    }
    public function get scale():Number {
        return _scale;
    }
    public function set scale(param:Number):void {
        _scale = param;
        switch (type) {
            case "x" :
                scaleX = _scale;
                break;
            case "y" :
                scaleY = _scale;
                break;
        }
    }

}


import flash.display.Sprite;
import flash.events.Event;

class Circle extends Sprite {
    public static var className:String = "Circle";
    public var transitName:String = "circle";
    private var loader:PhotoLoader;
    private var type:String;
    private var radius:uint;
    private var mWidth:uint;
    private var mHeight:uint;
    private var cols:uint;
    private var rows:uint;
    private var circles:Sprite;
    private var circleList:Array;
    private var completed:uint = 0;
    public static const COMPLETE:String = "complete";

    public function Circle(t:String, rd:uint, w:uint, h:uint, c:uint, r:uint) {
        type = t;
        radius = rd;
        mWidth = w;
        mHeight = h;
        cols = c;
        rows = r;
        init();
    }

    private function init():void {
        if (!circles) {
            circles = new Sprite();
            circleList = new Array();
            createCircles();
        }
    }
    public function effect(target:PhotoLoader):void {
        loader = target;
        loader.addChild(circles);
        loader.mask = circles;
        transit()
    }
    private function transit():void {
        for (var n:uint = 0; n < rows*cols; n++) {
            var circle:CircleMask = circleList[n];
            circle.effect();
            circle.addEventListener(Circle.COMPLETE, complete, false, 0, true);
        }
    }
    private function complete(evt:Event):void {
        evt.target.removeEventListener(Circle.COMPLETE, complete);
        completed ++;
        if (completed >= rows*cols) {
            reset();
            dispatchEvent(new Event(TransitPhoto.COMPLETE));
        }
    }
    private function createCircles():void {
        for (var r:uint = 0; r < rows; r++) {
            for (var c:uint = 0; c < cols; c++) {
                var xPos:uint;
                var yPos:uint;
                switch (type) {
                    case "++" :
                        xPos = mWidth/2 + mWidth*(c%cols);
                        yPos = mHeight/2 + mHeight*r;
                        break;
                    case "+-" :
                        xPos = mWidth/2 + mWidth*(c%cols);
                        yPos = mHeight/2 + mHeight*(rows - r - 1);
                        break;
                    case "-+" :
                        xPos = mWidth/2 + mWidth*((cols - c - 1)%cols);
                        yPos = mHeight/2 + mHeight*r;
                        break;
                    case "--" :
                        xPos = mWidth/2 + mWidth*((cols - c - 1)%cols);
                        yPos = mHeight/2 + mHeight*(rows - r - 1);
                        break;
                }
                var circle:CircleMask = new CircleMask(radius);
                circleList.push(circle);
                circle.x = xPos;
                circle.y = yPos;
                circle.generation = r + c;
                circles.addChild(circle);
            }
        }
    }
    public function reset():void {
        if (loader) {
            if (loader.contains(circles)) {
                loader.removeChild(circles);
                loader.mask = null;
            }
        }
        close();
    }
    private function close():void {
        for (var n:uint = 0; n < rows*cols; n++) {
            var circle:CircleMask = circleList[n];
            circle.close();
            circle.removeEventListener(Circle.COMPLETE, complete);
        }
        completed = 0;
    }

}


import flash.display.Sprite;
import flash.events.Event;
import flash.utils.Timer;
import flash.events.TimerEvent;

class CircleMask extends Sprite {
    public var generation:uint;
    private var radius:uint;
    private var _scale:Number = 1;
    private var timer:Timer;
    private static var speed:Number = 0.05;
    public static const COMPLETE:String = "complete";

    public function CircleMask(r:uint) {
        radius = r;
        init();
    }

    private function init():void {
        graphics.beginFill(0x000000);
        graphics.drawCircle(0, 0, radius);
        graphics.endFill();
    }
    public function effect():void {
        scale = 0;
        var offset:uint = 300*(generation + 1);
        timer = new Timer(offset, 1);
        timer.addEventListener(TimerEvent.TIMER_COMPLETE, open, false, 0, true);
        timer.start();
    }
    private function open(evt:TimerEvent):void {
        timer.removeEventListener(TimerEvent.TIMER_COMPLETE, open);
        addEventListener(Event.ENTER_FRAME, transit, false, 0, true);
    }
    private function transit(evt:Event):void {
        scale += speed;
        if (scale >= 1) {
            scale = 1;
            removeEventListener(Event.ENTER_FRAME, transit);
            dispatchEvent(new Event(CircleMask.COMPLETE));
        }
    }
    public function get scale():Number {
        return _scale;
    }
    public function set scale(param:Number):void {
        _scale = param;
        scaleX = scaleY = _scale;
    }
    public function close():void {
        scale = 0;
        timer.removeEventListener(TimerEvent.TIMER_COMPLETE, open);
        timer.stop();
        removeEventListener(Event.ENTER_FRAME, transit);
    }

}


//////////////////////////////////////////////////
// ColorManagerクラス
//////////////////////////////////////////////////

import flash.display.DisplayObject;
import flash.geom.ColorTransform;
import flash.filters.ColorMatrixFilter;

class ColorManager {
    private static var rs:Number = 0.3086;
    private static var gs:Number = 0.6094;
    private static var bs:Number = 0.0820;

    public function ColorManager() {
    }

    public static function brightOffset(target:DisplayObject, param:Number):void {
        target.transform.colorTransform = getBrightOffset(param);
    }
    private static function getBrightOffset(param:Number):ColorTransform {
        var percent:Number = 1;
        var offset:Number = param*2.55;
        var colorTrans:ColorTransform = new ColorTransform(0, 0, 0, 1, 0, 0, 0, 0);
        colorTrans.redMultiplier = percent;
        colorTrans.greenMultiplier = percent;
        colorTrans.blueMultiplier = percent;
        colorTrans.redOffset = offset;
        colorTrans.greenOffset = offset;
        colorTrans.blueOffset = offset;
        colorTrans.alphaMultiplier = 1;
        colorTrans.alphaOffset = 0;
        return colorTrans;
    }
    public static function saturation(target:DisplayObject, param:Number):void {
        target.filters = [getSaturation(param)];
    }
    private static function getSaturation(param:Number):ColorMatrixFilter {
        var colorMatrix:ColorMatrixFilter = new ColorMatrixFilter();
        var p:Number = param*0.01;
        var r:Number = (1 - p)*rs;
        var g:Number = (1 - p)*gs;
        var b:Number = (1 - p)*bs;
        var matrix:Array = [r + p, g, b, 0, 0, r, g + p, b, 0, 0, r, g, b + p, 0, 0, 0, 0, 0, 1, 0];
        colorMatrix.matrix = matrix;
        return colorMatrix;
    }

}


//////////////////////////////////////////////////
// ArrayUtilsクラス
//////////////////////////////////////////////////

class ArrayUtils {

    public function ArrayUtils() {
    }

    public static function shuffle(list:Array):Array {
        var n:uint = list.length;
        var sList:Array = list.concat();
        while (n--) {
            var i:uint = uint(Math.random()*(n+1));
            var t:Object = sList[n];
            sList[n] = sList[i];
            sList[i] = t;
        }
        return sList;
    }

}


//////////////////////////////////////////////////
// Labelクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.TextFieldAutoSize;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;

class Label extends Sprite {
    private var txt:TextField;
    private static var fontType:String = "_ゴシック";
    private var _width:uint;
    private static var _height:uint = 20;
    public static const LEFT:String = TextFormatAlign.LEFT;
    public static const CENTER:String = TextFormatAlign.CENTER;
    public static const RIGHT:String = TextFormatAlign.RIGHT;

    public function Label(w:uint, align:String = LEFT) {
        _width = w;
        draw(align);
    }

    private function draw(align:String):void {
        txt = new TextField();
        addChild(txt);
        txt.width = _width;
        txt.height = _height - 1;
        txt.autoSize = align;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = 12;
        tf.align = align;
        txt.defaultTextFormat = tf;
        textColor = 0x000000;
    }
    public function set text(param:String):void {
        txt.text = param;
    }
    public function set textColor(param:uint):void {
        txt.textColor = param;
    }

}
