/**
 * Copyright Cheshir ( http://wonderfl.net/user/Cheshir )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8zkj
 */

package {
    import flash.text.TextField;
    import flash.events.Event;
    import flash.geom.ColorTransform;
    import flash.filters.GlowFilter;
    import flash.display.Shape;
    import flash.geom.Matrix;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.MouseEvent;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        private var bit:BitmapData;
        private var map:Bitmap;
        private var particles:Array = [];
        private var tf:TextField = new TextField();
        public function FlashTest() {
            // write as3 code here..
            bit = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0);
            map = new Bitmap(bit);
            addChild(map);
            stage.addEventListener(MouseEvent.CLICK, generateParticles);
            stage.addEventListener(Event.ENTER_FRAME, updateMap);
            shape.graphics.beginFill(0xffffff);
            shape.graphics.drawRect(-10,-10,20,20);// drawCircle(0,0,3);
            shape.graphics.endFill();
            shape.filters = [new GlowFilter(red*16+green*16+blue*16)];
         //   map.filters = [new GlowFilter(red*16+green*16+blue*16)];
            tf.x = 300; tf.y = 300;
            tf.autoSize = 'left';
            addChild(tf);
        }
        private var red:Number = Math.random()*32;
        private var green:Number = Math.random()*32;
        private var blue:Number = Math.random()*32;
        private var m:Matrix = new Matrix();
        private var shape:Shape = new Shape();
        private function updateMap(e:Event):void{
            m.tx = mouseX;
            m.ty = mouseY;
            //bit.draw()
            bit.colorTransform(bit.rect, new ColorTransform(1, 1, 1, 0.96, red, green, blue, 0));
            bit.draw(shape, m);
            for(var i:int=0; i<particles.length; i++){
                m.tx = particles[i].x;
                m.ty = particles[i].y;
                //*Can I add rotations?
                m.a = Math.cos(particles[i].rotate);
                m.b = -Math.sin(particles[i].rotate);
                m.c = -m.b;
                m.d = m.a;
                // */
                bit.draw(shape,m);
                particles[i].next();
                if(particles[i].y > stage.stageHeight){
                    particles[i].y = stage.stageHeight;
                    particles[i].ySp*=-0.9;
                    particles[i].xSp = -particles[i].rotateSpeed*10;
                }
                if(particles[i].x > stage.stageWidth){
                    particles[i].x = 0;
                } else if(particles[i].x < 0){
                    particles[i].x = stage.stageWidth;
                }
            }
            tf.text = particles.length.toString();
        }
        private var max:Number = 40;
        private function generateParticles(e:MouseEvent):void{
            if(particles.length < max){
                for(var i:int=0; i<3; i++){
                    particles.push(new Particle(e.localX, e.localY, 45-i*3 ));
                }    
            } else {
                for(var j:int=0; j<particles.length; j++){
                    particles[j].x = e.localX;
                    particles[j].y = e.localY;
                }
            }
        }
        
    }
}
import flash.geom.Point;

Class {
    class Particle extends Point{
        public var ySp:Number;
        public var xSp:Number;
        public var rotate:Number = 0;
        public var rotateSpeed:Number = Math.random()-0.5;
        public function Particle(x:Number, y:Number, degree:Number):void{
            this.x = x;
            this.y = y;
            this.ySp = Math.sin(degree/180*Math.PI);
            this.xSp = Math.cos(degree/180*Math.PI)*(Math.random()*16-8);
        }
        public function next():void{
            this.x += xSp;
            this.y += ySp;
            ySp += 0.5;
            rotate += rotateSpeed;
        }

    }
}
