/**
 * Copyright mirrorboy ( http://wonderfl.net/user/mirrorboy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8zLS
 */

/**
 * Copyright amashio ( http://wonderfl.net/user/amashio )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/71f5
 */

/**
 * Copyright soundkitchen ( http://wonderfl.net/user/soundkitchen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/A91d
 */
 
/**
 * ActionScriptBeautiflcode P23
 */
  


package{
    
    import flash.display.BlendMode;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.filters.BitmapFilterQuality;
    import flash.filters.BlurFilter;
    import flash.geom.Point;
    import flash.utils.Timer;
    
    //右メニューでプロフィールを表示させられる
    //import com.flashdynamix.utils.SWFProfiler;
    //色をひろう
    import frocessing.color.ColorHSV;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.*;
    import org.libspark.betweenas3.tweens.ITween;
    
    [SWF(width=465, height=465, frameRate=60, backgroundColor=0xFFFFFF)]
    public class Pan extends Sprite{
        
        private static var P_ZERO:Point = new Point();
        private static var F_BLUR:BlurFilter = new BlurFilter(1, 8, BitmapFilterQuality.HIGH);
        
        
        private var _txt:TextField;
        private var _hsv:ColorHSV;//色相（Hue） 彩度(Saturation) 明度(Value・Brightness) で色を定義するクラス
        private var _film:BitmapData;
        private var _timer:Timer;
        private var _activeParticles:Vector.<Particle>;
        private var _inactiveParticles:Vector.<Particle>;
        
        
        public function Pan(){
            addEventListener(Event.ADDED_TO_STAGE, initialize);
        }
        
        //初期化
        private function initialize(event:Event):void{
            removeEventListener(Event.ADDED_TO_STAGE, initialize);
            
         //   SWFProfiler.init(this);
            
            var i:uint;
            var fmt:TextFormat;
            var bm:Bitmap;
            
            //particleを入れる配列
            _activeParticles = new Vector.<Particle>();
            //あらかじめつくったけど　つかっていないparticleを入れている配列？
            _inactiveParticles = new Vector.<Particle>();
            
            //とりあえず10000個のparticleを作って入れておく
            for(i = 0; i < 100; i++){
                _inactiveParticles.push(new Particle());
            }
            
            //色の用意
            _hsv = new ColorHSV(Math.random(), 1, 1, Math.random());
            
            //表示文字のフォーマット
            fmt = new TextFormat();
            fmt.font = "Verdana";
            fmt.bold = true;
            fmt.size = 60;
            
            //表示文字の用意
            _txt = new TextField();
            _txt.defaultTextFormat = fmt;
            _txt.autoSize = TextFieldAutoSize.LEFT;
            _txt.text = "●";
            
            //文字を写すBitmapDataの用意と配置
            _film = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0);
            bm = new Bitmap(_film);
            addChild(bm);
            
            //timerの用意と設置
            _timer = new Timer(0);
            _timer.addEventListener(TimerEvent.TIMER, timerHandler);
            _timer.start();
            
            //イベントをしこむ
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }
        
        //毎フレームですること
        private function enterFrameHandler(event:Event):void{
            var i:uint;
            var p:Particle;
            
            //色の取得
            //インクリメント _hsvを360で割った剰余を足していく　最大で1
            _hsv.h = ++_hsv.h % 360;
            
            //setPixelのためのロック
            _film.lock();
            //フィルタを適用
            _film.applyFilter(_film, _film.rect, P_ZERO, F_BLUR);
            
            //パーティクルを呼び込む
            for(i = 0; i < _activeParticles.length; i++){
                p = _activeParticles[i];
                
                p.vx += (stage.mouseX - p.x)/50.;
                p.vy += (stage.mouseY - p.y)/100.;
                
                p.x += p.vx;
                p.y += p.vy;
                //パーティクルの寿命をきる
                p.life--;
                
                //setPixelにおく
                _film.setPixel32(p.x, p.y, p.color);
                
                //もしパーティクルの寿命がないなら
                if(!p.life){
                    //パーティクル配列から該当パーティクルを切る
                    _activeParticles.splice(i, 1);
                    //出番待ち配列に入れる
                    _inactiveParticles.push(p);
                    //繰り返し順の数字を減らす=_activeParticleの順番が減るから
                    i--;
                }
            }
            
            //lockをはずす
            _film.unlock();
        }
        
        //任意時間ですること
        private function timerHandler(event:TimerEvent):void{
            //timer.delayを　ばらけて設定　//正の整数側に傾ける
            _timer.delay = (50 + Math.random() * 950) >> 0;
            
            var sp:Sprite;
            var bm:Bitmap;
            var bmd:BitmapData;
            var t:ITween;
            
            //取得した色の値をtextFieldに送る
            _txt.textColor = _hsv.value;
            
            bmd = new BitmapData(_txt.width, _txt.height, true, 0);
            bmd.draw(_txt);
            
            //貼付けるBitmap
            bm = new Bitmap(bmd);
            bm.smoothing = true;
            //bmの中心点左上からbmのwidth,heightの中心にする
            bm.x -= bm.width >> 1;
            bm.y -= bm.height >> 1;
            
            //spriteを作って貼る
            sp = new Sprite();
            sp.addChild(bm);
            
            //位置をstage内にランダムに置く
            sp.x = (Math.random() * stage.stageWidth) >> 0;
            sp.y = (Math.random() * stage.stageHeight) >> 0;
            //サイズは0
            sp.scaleX = 0;
            sp.scaleY = 0;
            //0度以上で回転させる
            sp.rotation = (Math.random() * 360) >> 0;
            
            addChild(sp);
            
            //BetweenAS3の用意
            //2つのtweenを結合して　順番に処理する
            t = BetweenAS3.serial(
                BetweenAS3.to(sp, {
                    'scaleX':1,
                    'scaleY':1,
                    'rotation':0
                }, 2, Expo.easeIn),
                BetweenAS3.removeFromParent(sp)
            );
            
            //該当tweenが完了したらfuncionを呼ぶ
            t.onComplete = tweenComplete;
            //オブジェクトをわたす
            t.onCompleteParams = [sp, bm, bmd];
            //Tweenをうごかす
            t.play();
        }
        
        //tween完了時にすること
        private function tweenComplete(sp:Sprite, bm:Bitmap, bmd:BitmapData):void{
            var i:uint;
            var j:uint;
            var c:uint;
            var cx:Number;
            var cy:Number;
            var angle:Number;
            var strength:Number;
            var p:Particle;
            
            //bmの中心からの距離?
            cx = sp.x + bm.x;
            cy = sp.y + bm.y;
            
            //BitmapData上をくりかえす
            for(i = 0; i < bmd.width; i++){
                for(j = 0; j < bmd.height; j++){
                    
                    //BitmapData上を走査する
                    c = bmd.getPixel32(i, j);
                    
                    //cがないならおわり　あるなら以下を続ける　
                    if(!c) continue;
                    
                    //もし待機配列だったら　待機配列から要素を消してエレメントを返す(そして待機配列は配列数が１つへる)　そうでないなら新しいparticleをつくる
                    //(条件演算子は三項演算子であり、3つのオペランドを取ります。条件演算子はif..else条件のステートメントを適用する簡易的な方法です)
                    p = _inactiveParticles.length ? _inactiveParticles.shift() : new Particle();
                    
                    //角度を設定
                    angle = 0;//Math.random() * Math.PI * 2;
                    
                    //randomでの強度をつける
                    strength = Math.random() * 5;
                    
                    //particleの速度を計算
                    p.vx = Math.cos(angle) * strength;
                    p.vy = Math.sin(angle) * strength;
                    
                    //particleの位置を
                    p.x = cx + i;
                    p.y = cy + j;
                    //走査した色をつける
                    p.color = c;
                    //lifeをMaxにする
                    p.life = 50 * Math.random();
                    
                    //表示配列にいれる
                    _activeParticles.push(p);
                }
            }
            
            //BitmapDataの破棄
            bmd.dispose();
        }
    }
}

class Particle{
    
    public var vx:Number;
    public var vy:Number;
    public var x:Number;
    public var y:Number;
    public var color:uint;
    public var life:uint;
    
}