/**
 * Copyright esukei ( http://wonderfl.net/user/esukei )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8yuk
 */

package {
    import flash.display.Sprite;
    import flash.display.Graphics;
    import flash.events.Event;
    import flash.geom.Point;

    /**
     * Polarとか知らなかったので使ってみるテスト。
     * 棒がぐるぐる回る。
     * 今までこういうの愚直にsinとcos使ってたわー。
     */

    //メインクラス
    public class PolarTest extends Sprite {
        
        //棒
        private var line:Line;
        //座標
        private var point:Point;
        //単位時間ごとの変化量
        private var delta:Number = 5;
        //角度
        private var angle:Number = 0;

        //コンストラクタ
        public function PolarTest() {
            line = new Line();
            line.x = stage.stageWidth / 2;
            line.y = stage.stageHeight / 2;
            stage.addChild(line);
            stage.addEventListener(Event.ENTER_FRAME, rotateLine);
        }

        //ぐるぐる回す
        private function rotateLine(event:Event):void{
            point = Point.polar(stage.stageWidth / 2, angle*Math.PI/180);
            line.draw(point.x,point.y);
            angle+=delta;
            //http://gihyo.jp/dev/serial/01/as3/0016?page=2参考にwhileから変えてみた。
            angle = (angle % 360 + 360) % 360;
        }

    }
}

import flash.display.CapsStyle;
import flash.display.JointStyle;
import flash.display.LineScaleMode;
import flash.display.Shape;
import flash.display.Sprite;

//棒
class Line extends Sprite {
    //シェイプ
    public var lineBody:Shape;
    
    //コンストラクタ
    public function Line(){
        lineBody = new Shape();
        draw(0,0);
        this.addChild(lineBody);
    }

    //棒を描画
    public function draw(newX:Number,newY:Number):void{
        lineBody.graphics.clear();
        lineBody.graphics.lineStyle(1, 0xFF0000, 1, false, LineScaleMode.NONE, CapsStyle.NONE, JointStyle.MITER, 10);
        lineBody.graphics.moveTo(0,0);
        lineBody.graphics.lineTo(newX,newY);
    }
}