/**
 * Copyright ulrichz14 ( http://wonderfl.net/user/ulrichz14 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8yuE
 */

package  
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.DisplayObject;
    import flash.display.Sprite;
    import flash.events.Event;
    
    /**
     * [企画]皆で動くパズル作ろうぜ
     * http://wonderfl.net/c/yb0z
     * 前から気になってた事があって、Wonderfl は色んな作品があるけど作品同士のつながりがないのが気になっていた。
     * 例えば、パーツだけ作って読み込んでロードするだけで使える[素材]を作るとか。
     * あと Fork することで何かに参加できるようにすればもっと面白い事になって行きそうなきがする。
     * チェックメイトやJAMのような方法ではなく、Forkされたもの全てが一つの作品を作るというか。
     * これからもチェックメイトやJAM以外にも[企画]タグや[素材]タグが増えていくといいなぁ。
     * @author jc at bk-zen.com
     */
    [SWF (backgroundColor = "0x000005", frameRate = "60", width = "465", height = "465")]
    public class MoviePuzzle extends Sprite 
    {
        private static const BG_COLOR: uint = 0x000000;
        private static const FRAME_RATE: uint = 30;
        
        public function MoviePuzzle() 
        {
            // ローダーで読み込まれなかった時の為のデモ用
            if (stage) demo(null)
            else addEventListener(Event.ADDED_TO_STAGE, demo);
        }
        
        /**
         * 
         * MoviePuzzle -> MovieJigsawPuzzle
         *         obj["disp"]      : DisplayObject : 描画対象このオブジェクトの440x440の範囲で切り取られて描画されます。
         *         obj["color"]     : uint : 背景色(省略時は0x000000)
         *         obj["frameRate"] : uint : フレームレート(省略時は60)
         *         obj["level"]     : uint : 上限レベル(省略時は1)
         * @param    obj : <Object>
         */
        public function initialize(obj: Object): void
        {
            disp = new ParticleTest1();
            addChild(disp);
            obj["disp"]  = disp
            obj["color"] = BG_COLOR;
            obj["frameRate"]  = FRAME_RATE;
        }
        
        /**
         * スタートする時に呼ばれます。
         * @param    level : uint : 指定レベル : 変える必要があれば。
         */
        public function start(level: uint): void
        {
            
            disp.start();
            
        }
        
        /**
         * 終了した時に呼ばれます。
         */
        public function end(): void
        {
            //Object(disp).end()
        }
        
        private var disp:ParticleTest1;
        
        /**
         * デモ用
         * @param    e
         */
        private function demo(e: Event): void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, demo);
            var obj: Object = {};
            initialize(obj);
            disp = obj["disp"];
            start(1);
        }
    }
}

    /**
 * Copyright coppieee ( http://wonderfl.net/user/coppieee )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/436W
 */

// forked from paq's forked from: 重力マウス（ちょっぴり軽量化してみた）
// forked from fumix's 重力マウス（リンクリストにしてみた）
// forked from undo's 重力マウス
//　リンクリストにしてみたけどそんなに速くない？？
//_bmd.fillRect()を_bmd.setPixel()に変更。
//sin(),cos(),atan2(),sqrt()を排除。

    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import net.hires.debug.Stats;

    

    class ParticleTest1 extends Sprite
    {
        private var _bmp:Bitmap;
        private var _bmd:BitmapData;
        private var _bmdRect:Rectangle;
        private var _colorTransform:ColorTransform = new ColorTransform(0.9, 0.8, 0.6, .9);

        private var _nodeArray:Array = [];
        private var _first:Node;
        private var _maxNum:int =30000;
        
        //private var _rect:Rectangle = new Rectangle(0, 0, 1, 1);

        public function ParticleTest1()
        {
        }
        public function start():void{
            //this.stage.align = StageAlign.TOP_LEFT;
            //this.stage.scaleMode = StageScaleMode.NO_SCALE;
            
            var old:Node;

            _bmd = new BitmapData(465, 465, false, 0x000000);
            _bmp = new Bitmap(_bmd);
            addChild(_bmp);
            this._bmdRect = new Rectangle(0, 0, 465, 465);

            for (var i:int = 0; i < this._maxNum; i++)
            {
                var n:Node = new Node();
                n.pos_x = Math.random() * 465;
                n.pos_y = Math.random() * 465;
                this._nodeArray.push(n);
                //リンクリスト
                if (_first == null) {
                    old = _first = n;
                } else {
                    old.next = n;
                    old = n;
                }
            }
            
            //addChild(new Stats());
            addEventListener(Event.ENTER_FRAME, onEnter);
        }

        private function onEnter(evt:Event):void
        {
            //var gravPoint:Point = new Point(mouseX, mouseY);
            var gravPoint_x:Number = mouseX;
            var gravPoint_y:Number = mouseY;
            var n:Node = _first;
            this._bmd.lock();
            do
            {
                var diff_x:Number = gravPoint_x - n.pos_x;
                var diff_y:Number = gravPoint_y - n.pos_y;
                var acc:Number = 50/(diff_x * diff_x + diff_y * diff_y);
                var acc_x:Number = acc * diff_x;
                var acc_y:Number = acc * diff_y;
                n.v_x += acc_x;
                n.v_y += acc_y;
                n.pos_x += n.v_x;
                n.pos_y += n.v_y;
                //n.acc_x *= 0.98;
                //n.acc_y *= 0.98;
                n.v_x *= 0.96;
                n.v_y *= 0.96;
                
                if (n.pos_x > 465)
                    n.pos_x = 0;
                else if (n.pos_x < 0)
                    n.pos_x = 465;
                if (n.pos_y > 465)
                    n.pos_y = 0;
                else if (n.pos_y < 0)
                    n.pos_y = 465;
                
                //_rect.x = n.pos_x;
                //_rect.y = n.pos_y;
                //this._bmd.fillRect(_rect, 0xffffff);
                this._bmd.setPixel(n.pos_x,n.pos_y,0xffffff);
            }
            while (n = n.next);
            this._bmd.colorTransform(this._bmdRect, this._colorTransform);
            this._bmd.unlock();
        }
    }


import flash.geom.Point;

class Node
{
//    public var acc_x:Number;
//    public var acc_y:Number;
    public var v_x:Number = 0;
    public var v_y:Number = 0;
    public var pos_x:Number = 0;
    public var pos_y:Number = 0;
    public var next:Node;
}
