/**
 * Copyright Test_Dept ( http://wonderfl.net/user/Test_Dept )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8xrW
 */

package {

	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.DisplayObject;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.utils.getTimer;
	
	/**
	 * Untitled
	 * @author Test Dept
	 */
	[SWF(backgroundColor="#000000", width="465", height="465")]
	public class Untitled extends Sprite {

		public function Untitled() {
			addEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
		}
		
		private function addedToStageHandler(event : Event) : void {

			// sand storm
			var bgBmp : BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight);
			addEventListener(Event.ENTER_FRAME, function(event : Event) : void {
				bgBmp.noise(getTimer(), 0, 63, 7, true);
			} );
			addChild(new Bitmap(bgBmp) );

			// title
			var title : DisplayObject = TextUtil.createText(
				"World\nWide\nwonderfl", 120, 0xff33cc);
			title.x = stage.stageWidth / 2;
			title.y = (stage.stageHeight - title.height) / 2;
			addChild(title);
		}
	}
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.BitmapDataChannel;
import flash.display.BlendMode;
import flash.display.DisplayObject;
import flash.display.Graphics;
import flash.display.Sprite;
import flash.text.TextFieldAutoSize;
import flash.text.TextField;
import flash.text.TextFormat;
import flash.geom.ColorTransform;
import flash.geom.Point;
import flash.geom.Rectangle;
import flash.geom.Matrix;

class TextUtil {
	
	public static function createText(
		messageLines : String, size : Number, bgcolor : uint
	) : DisplayObject {

		var messages : Array = messageLines.split("\n");
		var text : Sprite = new Sprite();
		var textLine : DisplayObject;
		var y : Number = 0;
		for (var i : int = 0; i < messages.length; i++) {
			textLine = TextUtil.createTextLine(messages[i], size, bgcolor);
			textLine.x = -textLine.width / 2;
			textLine.y = y;
			text.addChild(textLine);
			y += textLine.height;
		}
		return text;
	}
	
	public static function createTextLine(
		message : String, size : Number, bgcolor : uint
	) : DisplayObject {
		
		var textLine : Sprite = new Sprite();
		var x : Number = 0;
		for (var i : int = 0; i < message.length; i++) {
			var char : DisplayObject = createChar(
				message.substring(i, i + 1), size, bgcolor);
			char.x = x;
			textLine.addChild(char);
			x += char.width;
		}
		return textLine;
	}

	public static function createChar(
		char : String, size : Number, bgcolor : uint
	) : DisplayObject {
		
		var randFnt : Number = 0.9;
		var gapX : Number = 4;
		var gapY : Number = 8;
		
		var textField : TextField = new TextField();
		textField.defaultTextFormat = new TextFormat(
			"helvetica", size * (randFnt + rand() ) / (randFnt + 1), 0, true);
		textField.autoSize = TextFieldAutoSize.LEFT;
 		textField.text = char;

		var bmp : BitmapData;
		var rect : Rectangle;
		
		//---------------------------------------
		// create bitmap (1st.)

		bmp = new BitmapData(textField.width, textField.height, true, 0);		
		bmp.draw(textField);
		rect = bmp.getColorBoundsRect(0xffffffff, 0, false);

		if (rect.width == 0 || rect.height == 0) {
			// empty.
			return new Sprite();
		}

		var points : Array = [
			new Point(rect.x, rect.y),
			new Point(rect.x + rect.width, rect.y),
			new Point(rect.x + rect.width, rect.y + rect.height),
			new Point(rect.x, rect.y + rect.height)
		];

		var offsets : Array = [
			getOffsetPoint(-gapX, -gapY),
			getOffsetPoint(gapX, -gapY),
			getOffsetPoint(gapX, gapY),
			getOffsetPoint(-gapX, gapY)
		];

		var i : int;
		var p : Point;

		var center : Point = new Point(
			rect.x + rect.width / 2, rect.y + rect.height / 2);
		var mat : Matrix = new Matrix();
		mat.translate(-center.x, -center.y);
		mat.rotate( (rand() - 0.5) * 0.5);
		mat.translate(center.x, center.y);

		var tmpChar : Sprite = new Sprite();
		var g : Graphics = tmpChar.graphics;
		g.clear();

		// draw background
		// background : white
		g.beginFill(0xffffff);
		for (i = 0; i < points.length; i++) {
			p = mat.transformPoint(points[i].add(offsets[i]) );
			g[(i == 0)? "moveTo" : "lineTo"](p.x, p.y);
		}
		g.endFill();

		// draw character
		// color : black
		g.beginBitmapFill(bmp, mat, false, true);
		for (i = 0; i < points.length; i++) {
			p = mat.transformPoint(points[i]);
			g[(i == 0)? "moveTo" : "lineTo"](p.x, p.y);
		}
		g.endFill();

		//---------------------------------------
		// create bitmap (2nd.)
		// background : red

		rect = tmpChar.getBounds(tmpChar);
		bmp = new BitmapData(
			tmpChar.width + 1, tmpChar.height + 1, false, 0xffff0000);
		bmp.draw(tmpChar, new Matrix(1, 0, 0, 1, -rect.x, -rect.y),
			null, null, null, true);

		//---------------------------------------
		// create bitmap (3rd.)

		var charBmp : BitmapData = new BitmapData(
			bmp.width, bmp.height, true, 0xff000000 | bgcolor);
		charBmp.copyChannel(bmp,
			new Rectangle(0, 0, bmp.width, bmp.height), new Point(0, 0),
			BitmapDataChannel.BLUE, BitmapDataChannel.ALPHA);

		return new Bitmap(charBmp);
	}

	private static function getOffsetPoint(
		offsetX : Number, offsetY : Number
	) : Point {
		return new Point(offsetX * (0.1 + rand() ),	offsetY * (0.1 + rand() ) );
	}
	
	private static function rand() : Number {
		return Math.random();
	}
}
