/**
 * Copyright kazuyuki ( http://wonderfl.net/user/kazuyuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8xdR
 */

// forked from kazuyuki's forked from: flash on 2010-2-21
// forked from kazuyuki's flash on 2010-2-21
package {
    import flash.display.Sprite;
    	import flash.events.*;
    	[SWF( width="465", height="465", backgroundColor="0x000000", frameRate="30" )]
    public class FlashTest extends Sprite {
    		private var _box:ImgBox;
        public function FlashTest() {
              init()
        }    
		public function init():void{
			stage.addEventListener(MouseEvent.CLICK,add);
		}
		public function add(e:MouseEvent):void{
			var _box:ImgBox = new ImgBox();
			_box.x = mouseX;
			_box.y = mouseY;
			
			_box.init();
			_box.show();
			_box.buttonMode = true;
			
			addChild(_box);


			_box.open();    			    
        }
    }
}

import flash.display.*;
import flash.events.*;
import caurina.transitions.Tweener;
import flash.net.URLRequest;

internal class ImgBox extends Sprite{
	
	private var _loader:Loader;
	private var _lineRect:Sprite;
	private var _maskRect:Sprite;
	private var _bgRect:Sprite;
	
	private const IMG_SIZE:Number = 100;
	private const HALF_SIZE:Number = IMG_SIZE / 2;
	
	public function ImgBox() {
	}
	
	public function init():void{
		_lineRect = new Sprite();
		_lineRect.graphics.lineStyle(1,0xffffff, 1, false , LineScaleMode.NONE);
		_lineRect.graphics.moveTo( 0,0 );
		_lineRect.graphics.lineTo(IMG_SIZE,IMG_SIZE);
		_lineRect.graphics.moveTo(0,IMG_SIZE);
		_lineRect.graphics.lineTo(IMG_SIZE,0);
		_lineRect.graphics.drawRect(0,0,IMG_SIZE,IMG_SIZE);
		_lineRect.x = _lineRect.y = -HALF_SIZE;
		
		
		_maskRect = new Sprite();
		_maskRect.graphics.beginFill(0xffffff,0.5);
		_maskRect.graphics.drawRect(0,0,IMG_SIZE,IMG_SIZE);
		_maskRect.graphics.endFill();
		_maskRect.x = _maskRect.y = -HALF_SIZE;
		
		
		_bgRect = new Sprite();
		_bgRect.graphics.beginFill(0xffffff,0.5);
		_bgRect.graphics.drawRect(0,0,IMG_SIZE,IMG_SIZE);
		_bgRect.graphics.endFill();
		_bgRect.x = _bgRect.y = -HALF_SIZE;
		
		_loader = new Loader();
		_loader.alpha = 0;
		
		addChild( _bgRect );
		addChild( _lineRect );
		addChild( _loader );
		addChild( _maskRect );
		
		this.alpha = 0;
		this.scaleX = 0.01;
		this.scaleY = 0.01;
	}
	
	public function show():void{
		
		Tweener.addTween( this, { alpha:1, scaleX:0.2, scaleY:0.2, time:30, useFrames:true, transition:"easeOutExpo"});
	}
	
	public function open():void{
		Tweener.addTween( this, {scaleX:1, scaleY:1, time:30, useFrames:true, transition:"easeOutElastic"});
		Tweener.addTween( _maskRect, { x:-HALF_SIZE, y:-HALF_SIZE, alpha:1, width:1, time:20, delay:21, useFrames:true, transition:"easeOutExpo", onComplete:load });
	}
	
	private function load():void{
		_loader.contentLoaderInfo.addEventListener(ProgressEvent.PROGRESS, loading);
		_loader.contentLoaderInfo.addEventListener(Event.COMPLETE, complete);
		
		_loader.load( new URLRequest( "http://wonderfl.net/images/icon/4/48/480f/480f876800731772d8e7a547397888a08d8f71bfm" ));
	}
	private function loading(e:ProgressEvent):void{
		var percent:Number = e.bytesLoaded / e.bytesTotal;
		Tweener.addTween( _maskRect,{x:-HALF_SIZE, y:-HALF_SIZE, width:IMG_SIZE * percent, time:20, useFrames:true, transition:"easwOutExpo"});
	}
	private function complete(e:Event):void{
		Tweener.addTween( _maskRect,{alpha:1, x:-HALF_SIZE, y:-HALF_SIZE, width:IMG_SIZE, time:15, useFrames:true, transition:"easeOutExpo",onComplete:showImg});
	}

	private function showImg():void {
		Tweener.addTween( _maskRect, { x:HALF_SIZE, y:-HALF_SIZE, width:1, time:15, useFrames:true, transition:"easeOutExpo", onComplete:showImg });
		_loader.x = -HALF_SIZE;
		_loader.y = -HALF_SIZE;
		Tweener.addTween( _loader, { alpha:1, time:20, useFrames:true, transition:"easeOutExpo" });
	}
}
	
	
		 
	
	

