/**
 * Copyright minon ( http://wonderfl.net/user/minon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8xb8
 */

// forked from axcelwork's 虹色
package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import caurina.transitions.Tweener;
    
    /**
     * ...
     * @author axcel-work
     */
     
    [SWF(width=300, height=300, backgroundColor=0x000000, frameRate=60)]
    
    public class Main extends Sprite {
        public function Main():void{
            stage.scaleMode = "noScale";
            stage.align = "left";
            
            
            stage.addEventListener( MouseEvent.MOUSE_MOVE, moveMosue );
            
            var ball1:RootBall = new RootBall();
            ball1.x = Math.random() * 10;
            ball1.y = Math.random() * 10;
            addChild( ball1 );
            
            var ball2:RootBall = new RootBall();
            ball2.x = Math.random() * 60;
            ball2.y = Math.random() * 60;
            addChild( ball2 );
            
            var ball3:RootBall = new RootBall();
            ball3.x = Math.random() * 100;
            ball3.y = Math.random() * 100;
            addChild( ball3 );
        }
        
        private function moveMosue ( evt:MouseEvent ):void {
            var sprCircle:Circle = new Circle( evt.stageX, evt.stageY );
            addChild( sprCircle );
            
            Tweener.addTween( sprCircle, { alpha:1, transition:"easeOutCubic", time:0.6, onComplete : goneAlpha, onCompleteParams : [ sprCircle ] } );
            
            function goneAlpha( target:Sprite ):void {
                Tweener.addTween( target, { x:Math.random() *stage.stageWidth, y:Math.random() *stage.stageHeight,alpha:0, transition:"easeOutCubic", time:1.2, onComplete : goneMotion, onCompleteParams : [ target ] } );
            }
            
            function goneMotion( target:Sprite ):void {
                removeChild( target );
            }
        }
    }
}


import flash.display.BlendMode;
import flash.display.Sprite;
import caurina.transitions.Tweener;
import flash.events.Event;
import flash.utils.Timer;
import flash.events.TimerEvent;

class RootBall extends Sprite {
    private var vx:Number = Math.random() * 5;
    private var vy:Number = Math.random() * 5;
    
    private var moveX:Number = 0;
    private var moveY:Number = 0;
    
    public function RootBall() {
        this.graphics.beginFill( 0x000000, 0 );
        this.graphics.drawCircle( 0, 0, 20 );
        this.graphics.endFill();
        
        this.addEventListener( Event.ENTER_FRAME, onEnterHandler );
        
        var time:Timer = new Timer( 100, 0 );
        time.addEventListener( TimerEvent.TIMER, timHandler );
        time.start();
    }
    
    private function onEnterHandler( e:Event ):void{
       
        //速度に従ってボールの移動
        e.target.x += vx;
        e.target.y += vy;
        
        moveX = e.target.x;
        moveY = e.target.y;

        if(e.target.x < 20){
            e.target.x = 20;
            vx *= -1;
        }else if(stage.stageWidth - 20 < e.target.x){
            e.target.x = stage.stageWidth - 20;
            vx *= -1;
        }

        //縦向きのチェック
        if(e.target.y < 20){
            e.target.y = 20;
            vy *= -1;
        }else if(stage.stageHeight < e.target.y){
            e.target.y = stage.stageHeight;
            vy *= -1;
        }
        
    }
    
    private function timHandler(e:TimerEvent):void {
        var sprCircle:Circle = new Circle( moveX, moveY );
        addChild( sprCircle );
            
        Tweener.addTween( sprCircle, { alpha:1, transition:"easeOutCubic", time:0.6, onComplete : goneAlpha, onCompleteParams : [ sprCircle ] } );
            
        function goneAlpha( target:Sprite ):void {
            Tweener.addTween( target, { x:Math.random() *stage.stageWidth, y:Math.random() *stage.stageHeight,alpha:0, transition:"easeOutCubic", time:1.2, onComplete : goneMotion, onCompleteParams : [ target ] } );
        }
            
        function goneMotion( target:Sprite ):void {
            removeChild( target );
        }
    }
}


import flash.display.Sprite;

class Circle extends Sprite {
    public function Circle( x:Number, y:Number ) {
        var grad:Gradation = new Gradation(0xff0000, 0x00ff00, 0x0000ff);
        this.graphics.beginFill( grad.getColor( y / 464 )  );
        this.graphics.drawCircle( 0, 0, Math.random() * ( Math.random() * 40 ) );
        this.graphics.endFill();
        
        this.x = x - Math.random() * 40;
        this.y = y - Math.random() * 40;
        this.alpha = 0;
		
		this.blendMode = BlendMode.ADD;
    }
}




import frocessing.color.ColorLerp;

import org.libspark.betweenas3.core.easing.IEasing;
import org.libspark.betweenas3.easing.Linear;

class Gradation {
    
    private var _colors:Array;
    private var _easing:IEasing;
    
    public function Gradation(...args) {
        _colors = args.concat();
        _easing = Linear.linear;
    }
    
    public function setEasing(easing:IEasing):void {
        _easing = easing;
    }
    
    public function getColor(position:Number):uint {
        position = (position < 0 ? 0 : position > 1 ? 1 : position) * (_colors.length - 1);
        var idx:int = position;
        var alpha:Number = _easing.calculate(position - idx, 0, 1, 1);
        if (alpha == 0) {
            return _colors[idx];
        } else {
            return ColorLerp.lerp(_colors[idx], _colors[idx + 1], alpha);
        }
    }
}


