/**
 * Copyright nutsu ( http://wonderfl.net/user/nutsu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8ur2
 */

//Tankテスト用
package 
{
	// ai0
	import Box2D.Common.Math.b2Vec2;
	
	import flash.display.Bitmap;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.display.BitmapData;
	import flash.geom.ColorTransform;
	import flash.geom.Matrix;
	import flash.geom.Rectangle;
	
	import net.wonderfl.game.infinity_tank.model.Command;
	import net.wonderfl.game.infinity_tank.tank.TankBase;
	import net.wonderfl.utils.SequentialLoader;
	/**
	 * @author 9re
	 */
	// クラス名は必ずTankにして、TankBaseクラスを拡張して下さい
	// http://flash-games.wonderfl.net/static/asdoc/net/wonderfl/game/infinity_tank/tank/TankBase.html
	public class Tank extends TankBase
	{
		private var _spTank:Sprite;
		private var _spBattery:Sprite;
		private var _ctfm:ColorTransform;
		private var _images:Vector.<Bitmap>;
		private var _gun:Bitmap;
		private var _arr:Array = [];
		private var _i:int = -1;
		private var _j:int = 0;
		private var _mat:Matrix = new Matrix(1, 0, 0, 1, 5, 15);
		
		public function Tank() 
		{
            _bulletRenderer = "http://swf.wonderfl.net/swf/usercode/8/8f/8faa/8faa6f4c1148ad9a535d25bdd49b7e4d98d02030.swf";
			
			_spTank = new Sprite;
			_spBattery = new Sprite;
			
			SequentialLoader.loadImages(["http://assets.wonderfl.net/images/tank/tankA_1.png", "http://assets.wonderfl.net/images/tank/tankA_2.png", "http://assets.wonderfl.net/images/tank/tankB_cannon.png"], _arr, onImageLoaded);
			
			_ctfm = new ColorTransform(1, 1, 1, 0);
		}
		
		private function onImageLoaded():void
		{
			_images = Vector.<Bitmap>(_arr.map(function ($ldr:Loader, $index:int, $arr:Array):Bitmap {
				var mat:Matrix = new Matrix;
				var bd:BitmapData = new BitmapData($ldr.width, $ldr.height, true, 0x00ffffff);
				bd.draw($ldr, mat);
				var bm:Bitmap = new Bitmap(bd);
				
				return bm;
			}));
			
			_gun = _images.pop();
			_gun.x = -5;
			
			_gun.y = -5;
			_spBattery.addChild(_gun);
			_spBattery.x = 20;
			_spBattery.y = 15;
			_i = 0;
			_images.forEach(function ($bm:Bitmap, $index:int, $vec:Vector.<Bitmap>):void {
				_spTank.addChild($bm);
			});
			_spTank.addChild(_spBattery);
		}
		
		// Commandクラスのフラグを立てることによって、タンクの行動を設定できます
		// http://flash-games.wonderfl.net/static/asdoc/net/wonderfl/game/infinity_tank/model/Command.html
		override public function action():int
		{
            // 発射フラグをセットします。この戦車はいつも弾を撃つ
			var action:int = Command.FIRE;
			// そして、前へ進む
			action |= Command.TANK_MOVE_FORWARD;
			
            // _sceneオブジェクトは現在のステージの状況を保持しています
			// _sceneオブジェクトはBattleSceneクラスのインスタンスです。詳しくは、
			// http://flash-games.wonderfl.net/static/asdoc/net/wonderfl/game/infinity_tank/model/BattleScene.html
            // 敵の現在の位置を取得する
			var enemyPos:b2Vec2 = _scene.enemyTankPosition;
            // 自分の現状の位置を取得する
			var myPos:b2Vec2 = _scene.myTankPosition;
			
            // 自分の位置から見た相手の相対的な位置を計算します
			enemyPos.Subtract(myPos);
            // 自分から見た敵の戦車の方向を計算します
            // これはx軸方向を見て時計回りの角度となります。
			var angle:Number = Math.atan2(enemyPos.y, enemyPos.x);
            // 現在の敵の方向とと主砲の向きとのズレを計算
            // タンクの角度にさらに主砲の角度を足すことを忘れないで下さい
			angle -= (_scene.myGunAngle + _scene.myTankAngle);
			
            // 2πのモジュロを計算します
			angle %= Math.PI * 2;
						
            // 敵の位置が主砲が現在向いている向きより右であれば、
            // Command.GUN_TURN_RIGHT
			if (angle > 0) action |= Command.GUN_TURN_RIGHT;
            // 敵の位置が主砲が現在向いている向きより左であれば、
            // Command.GUN_TURN_LEFT
			else if (angle < 0) action |= Command.GUN_TURN_LEFT;
			
			angle += 3 * Math.PI / 2;
			angle %= Math.PI * 2;
			
			// 戦車の角度も調節することができます
			if (angle > 0) action |= Command.TANK_TURN_LEFT;
			else if (angle < 0) action |= Command.TANK_TURN_RIGHT;
			
			return action;
		}
		
		override public function draw(bitmapData:BitmapData):void
		{
            // _sceneオブジェクトは現在のステージの状況を保持しています
			// _sceneオブジェクトはBattleSceneクラスのインスタンスです。詳しくは、
			// http://flash-games.wonderfl.net/static/asdoc/net/wonderfl/game/infinity_tank/model/BattleScene.html
			// 主砲の角度を計算します。
			// この角度は相対的で戦車の本体から見た角度です。
			_spBattery.rotation = _scene.myGunAngle * 180 / Math.PI;
			
			// ここでは2枚のPNGをGIFアニメのように切り替えています
			if (_i > -1) {
				_i = (_j & 1) ? 1 : 0;
				var bm:Bitmap = _images[_i];
				bm.visible = true;
				_i = 1 - _i;
				bm = _images[_i];
				bm.visible = false;
				_j++;
				_j &= 3;
			}
			// 前回の状態を一旦消す
			bitmapData.colorTransform(bitmapData.rect, _ctfm);
			// _mat = new Matrix(1, 0, 0, 1, 5, 15)なのですが、
			// これは戦車のBitmapDataを戦車のヒットエリアよりやや大きめにしているからです
			// ビットマップのサイズは60 x 60で戦車のヒットエリアは
			// 50 x 30です。右向きを正面とするのがデフォルトの状態です
			// なので、
			// (60 - 50) / 2 = 5
			// (60 - 30) / 2 = 15
			// つまり、戦車本体はビットマップの左上隅の点から少しずれて
			// 左から5ピクセル、上から15ピクセルのところにあります
			bitmapData.draw(_spTank, _mat, null, null, null, true);
		}
		
		// called when a bullet hits this tank
		override public function hit():void {
            // 弾が当たったときに呼ばれます
            // エフェクトをつけてみてください
		}

	}
}