/**
 * Copyright o_healer ( http://wonderfl.net/user/o_healer )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8ueP
 */

/*
　「ライツ・アウト・アクト(LightsOut Act)」
　・ライツアウトを引き起こす弾で進むアクションゲーム
　　・参考：http://ja.wikipedia.org/wiki/%E3%83%A9%E3%82%A4%E3%83%84%E3%82%A2%E3%82%A6%E3%83%88

　操作方法(How to Play)
　・十字キー(Arrow)
　　・移動(Move)＆ジャンプ(Jump)
　・その他のキー(Else)
　　・ショット(Shot)
　　　・ライツアウトを引き起こす
*/


package {
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.*;
    import flash.net.*;
    import flash.system.*;
    import flash.text.*;
 
    [SWF(width="465", height="465", frameRate="30", backgroundColor="0x000000")]
    public class GameMain extends Sprite {

        //==Const==

        //画面の大きさ
        static public const VIEW_W:int = 465;
        static public const VIEW_H:int = 465;

        //マップ
        static public var m_MapIter:int = 0;
        static public const O:int = m_MapIter++;//空白
        static public const W:int = m_MapIter++;//壁
        static public const P:int = m_MapIter++;//プレイヤー
        static public const G:int = m_MapIter++;//ゴール

        static public const MAP:Array = [
            [W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W],
            [W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W],
            [W,O,O,O,O,O,O,O,O,O,O,O,W,W,O,O,O,O,O,O,W,W,W,O,O,O,O,O,O,W,W,W,W,O,O,O,O,O,O,W,W,W,W,W,O,O,O,O,O,O,O,W,W],
            [W,O,O,O,O,O,O,O,O,O,O,O,W,W,O,O,O,O,O,O,W,W,W,O,O,O,O,O,O,W,W,W,W,O,O,O,O,O,O,W,W,W,W,W,O,O,O,O,O,O,O,W,W],
            [W,O,O,O,O,O,O,O,O,O,O,O,W,W,O,O,O,O,O,O,W,W,W,O,O,O,O,O,O,W,W,W,W,O,O,O,O,O,O,W,W,W,W,W,O,O,O,O,O,O,O,W,W],
            [W,O,O,O,O,O,O,O,O,O,O,O,W,W,O,O,O,O,O,O,W,W,W,O,O,O,O,O,O,W,W,W,W,O,O,O,O,O,O,W,W,W,W,W,O,O,O,O,O,O,O,W,W],
            [W,O,O,O,O,O,O,O,O,O,O,O,W,W,O,O,O,O,O,O,W,W,W,O,O,O,O,O,O,W,W,W,W,O,O,O,O,O,O,W,W,W,W,W,O,O,O,O,O,O,O,W,W],
            [W,O,O,O,O,O,O,O,O,O,O,O,W,W,O,O,O,O,O,O,W,W,W,O,O,O,O,O,O,W,W,W,W,O,O,O,O,O,O,W,W,W,W,W,O,O,O,O,O,O,O,W,W],
            [W,O,O,O,O,O,O,O,O,O,O,O,W,W,O,O,O,O,O,O,W,W,W,O,O,O,O,O,O,W,W,W,W,O,O,O,O,O,O,W,W,W,W,W,O,O,O,O,O,O,O,W,W],
            [W,O,O,P,O,O,O,O,O,O,O,O,W,W,O,O,O,O,O,O,W,W,W,O,O,O,O,O,O,W,W,W,W,O,O,O,O,O,O,W,W,W,W,W,O,O,O,O,G,O,O,W,W],
            [W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W],
            [W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W],
            [W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W,W],
        ];

        //１マスの大きさ
        static public const PANEL_LEN:int = 32;

        //マップのサイズ
        static public const MAP_NUM_X:int = MAP[0].length;
        static public const MAP_NUM_Y:int = MAP.length;

        //マップの大きさ
        static public const MAP_W:int = PANEL_LEN * MAP_NUM_X;
        static public const MAP_H:int = PANEL_LEN * MAP_NUM_Y;

        //モード
        static public var ModeIter:int = 0;
        static public const MODE_MAIN:int    = ModeIter++;
        static public const MODE_GOAL:int    = ModeIter++;
        static public const MODE_GAME_OVER:int    = ModeIter++;


        //==Var==

        //Pseudo Singleton
        static public var Instance:GameMain;

        //操作用Map
        public var m_Map:Array;

        //レイヤー
        public var m_Layer_Root:Sprite = new Sprite();
        public var  m_Layer_BG:Sprite = new Sprite();
        public var  m_Layer_Bullet:Sprite = new Sprite();
        public var  m_Layer_Player:Sprite = new Sprite();

        //画像
        public var m_BitmapData_BG:BitmapData   = new BitmapData(MAP_W, MAP_H, false, 0x000000);

        //プレイヤー
        public var m_Player:Player = new Player();

        //ゴール
        public var m_Goal:Goal;

        //テキスト
        public var m_Text:TextField = new TextField();

        //モード
        public var m_Mode:int = MODE_MAIN;


        //==Function==

        //Init
        public function GameMain():void {
            //Pseudo Singleton
            {
                Instance = this;
            }

            //Layer
            {
                //Root
                addChild(m_Layer_Root);

                {
                    //背景
                    m_Layer_Root.addChild(m_Layer_BG);

                    //弾
                    m_Layer_Root.addChild(m_Layer_Bullet);

                    //プレイヤー
                    m_Layer_Root.addChild(m_Layer_Player);
                }
            }

            //背景
            {
                m_Layer_BG.addChild(new Bitmap(m_BitmapData_BG));
            }

            //プレイヤー
            {
                m_Layer_Player.addChild(m_Player);
            }

            //Goal
            {
                m_Goal = new Goal();
                m_Layer_BG.addChild(m_Goal);
            }

            //MAPに応じた処理
            {
                m_Map = new Array(MAP_NUM_Y);
                for(var y:int = 0; y < MAP_NUM_Y; y++){
                    m_Map[y] = new Array(MAP_NUM_X);
                    for(var x:int = 0; x < MAP_NUM_X; x++){

                        var MapIndex:int = MAP[y][x];

                        //各種位置設定
                        var PosX:int = (x+0.5) * PANEL_LEN;
                        var PosY:int = (y+0.5) * PANEL_LEN;
                        switch(MapIndex){
                        case P:
                            //プレイヤーの位置指定
                            m_Player.SetPos(PosX,PosY);
                            MapIndex = O;
                            break;
                        case G:
                            //ゴールの位置指定
                            m_Goal.SetPos(PosX,PosY);
                            MapIndex = O;
                            break;
                        }

                        m_Map[y][x] = MapIndex;
                    }
                }

                RedrawBG();
            }

            //Text
            {
                m_Text.selectable = false;
                m_Text.autoSize = TextFieldAutoSize.LEFT;
                m_Text.defaultTextFormat = new TextFormat('Verdana', 60, 0xFFFF00, true);
                m_Text.text = '';
                m_Text.filters = [new GlowFilter(0xFF0000,1.0, 8,8)];

                addChild(m_Text);
            }

            //Update
            {
                addEventListener(Event.ENTER_FRAME, Update);
            }
        }

        public function RedrawBG():void{
            var rect:Rectangle = new Rectangle(0,0, PANEL_LEN,PANEL_LEN);
            var rect_in:Rectangle = new Rectangle(0,0, PANEL_LEN-2,PANEL_LEN-2);
            for(var y:int = 0; y < MAP_NUM_Y; y++){
                rect.y = y * PANEL_LEN;
                rect_in.y = rect.y+1;
                for(var x:int = 0; x < MAP_NUM_X; x++){
                    rect.x = x * PANEL_LEN;
                    rect_in.x = rect.x+1;

                    var MapIndex:int = m_Map[y][x];

                    switch(MapIndex){
                    case O:
                        //空白
                        m_BitmapData_BG.fillRect(rect, 0xFFFFFFFF);
                        break;
                    case W:
                        //壁
                        m_BitmapData_BG.fillRect(rect, 0xFF222222);
                        m_BitmapData_BG.fillRect(rect_in, 0xFF000000);
                        break;
                    }
                }
            }
        }

        //Update
        public function Update(e:Event=null):void{
            var DeltaTime:Number = 1.0 / stage.frameRate;

            //Player
            {
                m_Player.Update(DeltaTime);
            }

            //Bullet
            {
                var i:int;
                var bullet:Bullet;
                var num:int = m_Layer_Bullet.numChildren;
                for(i = 0; i < num; i++){
                    bullet = m_Layer_Bullet.getChildAt(i) as Bullet;

                    //Update
                    bullet.Update(DeltaTime);

                    //KillCheck
                    if(bullet.m_KillFlag){
                        bullet.parent.removeChild(bullet);
                        num--;//減少
                        i--;//相殺
                    }
                }
            }

            //Goal
            {
                m_Goal.Update();
            }

            //Camera
            {
                Update_Camera();
            }
        }

        //Update : Camera
        public function Update_Camera():void{
            var PlayerX:int = m_Player.x;
            var PlayerY:int = m_Player.y;



            //移動量
            var CameraMoveX:int = 0;
            var CameraMoveY:int = 0;
            {
                //現在のカメラでのプレイヤー相対位置
                var RelPlayerX:Number = PlayerX + m_Layer_Root.x;
                var RelPlayerY:Number = PlayerY + m_Layer_Root.y;

                //中央からの差がそのまま移動量
                CameraMoveX = VIEW_W/2 - RelPlayerX;
                CameraMoveY = VIEW_H/2 - RelPlayerY;
            }

            //目標値
            var RootX:int = m_Layer_Root.x + CameraMoveX;
            var RootY:int = m_Layer_Root.y + CameraMoveY;
            {
                //端制限
                if(RootX < -MAP_W + VIEW_W){
                    RootX = -MAP_W + VIEW_W;
                }
                if(RootX > 0){
                    RootX = 0;
                }
                if(RootY < -MAP_H + VIEW_H){
                    RootY = -MAP_H + VIEW_H;
                }
                if(RootY > 0){
                    RootY = 0;
                }
            }

            m_Layer_Root.x = RootX;
            m_Layer_Root.y = RootY;
        }

        //Goal
        public function OnGoal():void{
            //Mode
            {
                m_Mode = MODE_GOAL;
            }

            //Text
            {
                //Text
                m_Text.text = 'Clear';

                //Centering
                m_Text.x = (stage.stageWidth - m_Text.width) / 2;
                m_Text.y = (stage.stageHeight - m_Text.height) / 2;
            }
        }

        //Game Over : Damage
        public function OnDead_Damage():void{
            //Mode
            {
                m_Mode = MODE_GAME_OVER;
            }

            //Text
            {
                //Text
                m_Text.text = 'Game Over';

                //Centering
                m_Text.x = (stage.stageWidth - m_Text.width) / 2;
                m_Text.y = (stage.stageHeight - m_Text.height) / 2;
            }
        }

        //Game Over : Fall
        public function OnDead_Fall():void{
            //Mode
            {
                m_Mode = MODE_GAME_OVER;
            }

            //Text
            {
                //Text
                m_Text.text = 'Game Over';

                //Centering
                m_Text.x = (stage.stageWidth - m_Text.width) / 2;
                m_Text.y = (stage.stageHeight - m_Text.height) / 2;
            }
        }

        //#IsGameOver
        public function IsEnd():Boolean{
            return (m_Mode != MODE_MAIN);
        }

        //Wall
        public function GetWallVal(in_X:int, in_Y:int):int{
            var IndexX:int = in_X / PANEL_LEN;
            var IndexY:int = in_Y / PANEL_LEN;

            //範囲外は空白とみなす
            {
                if(IndexX < 0){return O;}
                if(MAP_NUM_X <= IndexX){return O;}
                if(IndexY < 0){return O;}
                if(MAP_NUM_Y <= IndexY){return O;}
            }

            //あとはMAPに従う
            return m_Map[IndexY][IndexX];
        }

        public function CrossFlip(in_X:int, in_Y:int):void{
            var IndexX_Base:int = in_X / PANEL_LEN;
            var IndexY_Base:int = in_Y / PANEL_LEN;

            const OffsetX:Array = [
                    0,
                -1,    0,    +1,
                    0,
            ];
            const OffsetY:Array = [
                    -1,
                0,    0,    0,
                    +1,
            ];

            for(var i:int = 0; i < 5; i++){
                var IndexX:int = IndexX_Base + OffsetX[i];
                var IndexY:int = IndexY_Base + OffsetY[i];

                //範囲外は無視
                {
                    if(IndexX < 0){continue;}
                    if(MAP_NUM_X <= IndexX){continue;}
                    if(IndexY < 0){continue;}
                    if(MAP_NUM_Y <= IndexY){continue;}
                }

                if(m_Map[IndexY][IndexX] == O){
                    m_Map[IndexY][IndexX] = W;
                }else{
                    m_Map[IndexY][IndexX] = O;
                }
            }

            RedrawBG();
        }

        //Utility
        static public function Lerp(in_Src:Number, in_Dst:Number, in_Ratio:Number):Number{
            return (in_Src * (1 - in_Ratio)) + (in_Dst * in_Ratio);
        }
    }
}


import flash.display.*;
import flash.events.*;
import flash.filters.*;
import flash.geom.*;
import flash.net.*;
import flash.system.*;
import flash.ui.*;


//#Player
class Player extends Sprite
{
    //==Const==

    //移動速度
    static public const VEL_X:Number = 100.0;

    //ジャンプ速度
    static public const JUMP_VEL:Number = 290.0;

    //重力
    static public const GRAVITY:Number = 500.0;

    //最高下降速度（ロックによって無限落下が可能なので、速度制限してみる）
    static public const FALL_VEL_MIN:Number = 1000.0;


    //==Var==

    //移動まわりのパラメータ
    public var m_Pos:Point = new Point(0,0);
    public var m_Vel:Point = new Point(0,0);

    //入力
    public var m_InputL:Boolean = false;
    public var m_InputR:Boolean = false;
    public var m_InputU:Boolean = false;
    public var m_InputD:Boolean = false;
    public var m_InputShot:Boolean = false;

    //プレイヤーのグラフィック
    public var m_Shape:Shape = new Shape();
    public var m_Graphics:Graphics = m_Shape.graphics;

    //接地フラグ
    public var m_GroundFlag:Boolean = false;

    //死亡フラグ
    public var m_IsDead:Boolean = false;


    //==Function==

    //Init
    public function Player(){
        //Input
        {
            addEventListener(
                Event.ADDED_TO_STAGE,//ステージに追加されたら
                function(e:Event):void{
                    //キー入力を見る
                    stage.addEventListener(KeyboardEvent.KEY_DOWN, OnKeyDown);
                    stage.addEventListener(KeyboardEvent.KEY_UP, OnKeyUp);
                }
            );
        }

        //プレイヤーグラフィック
        {
            addChild(m_Shape);

            Redraw();
        }
    }

    //Init : Pos
    public function SetPos(in_X:int, in_Y:int):void{
        this.x = m_Pos.x = in_X;
        this.y = m_Pos.y = in_Y;
    }

    //Update : Input
    static public const KEY_S:int = 83;
    private function OnKeyDown(event:KeyboardEvent):void{
        if(event.keyCode == Keyboard.LEFT){    m_InputL = true; this.scaleX = -1; return;}
        if(event.keyCode == Keyboard.RIGHT){m_InputR = true; this.scaleX =  1; return;}
        if(event.keyCode == Keyboard.UP){    m_InputU = true; return;}
        if(event.keyCode == Keyboard.DOWN){    m_InputD = true; return;}

        if(!m_InputShot){
            m_InputShot = true;
            GameMain.Instance.m_Layer_Bullet.addChild(new Bullet(this.x, this.y, this.scaleX > 0));
        }
    }
    private function OnKeyUp(event:KeyboardEvent):void{
        if(event.keyCode == Keyboard.LEFT){    m_InputL = false; return;}
        if(event.keyCode == Keyboard.RIGHT){m_InputR = false; return;}
        if(event.keyCode == Keyboard.UP){    m_InputU = false; return;}
        if(event.keyCode == Keyboard.DOWN){    m_InputD = false; return;}

        m_InputShot = false;
    }

    //Draw
    public function Redraw():void{
        var color_in:uint  = 0xFF000000;
        var color_out:uint = 0xFF222222;

        var g:Graphics = m_Graphics;
        g.clear();

        g.lineStyle(2,color_out & 0xFFFFFF, 0.5);
        g.beginFill(color_in & 0xFFFFFF, 1.0);
        g.drawCircle(0,0, GameMain.PANEL_LEN/2);
        g.endFill();

        g.lineStyle(0,0,0);
        g.beginFill(0xFF0000, 1.0);
        g.drawCircle(GameMain.PANEL_LEN/4,-GameMain.PANEL_LEN/5, 2);
        g.endFill();
    }

    //Update
    public function Update(in_DeltaTime:Number):void{
        //死亡・ゴール時は何もしない
        if(GameMain.Instance.IsEnd()){
            return;
        }

        //移動
        Update_Move(in_DeltaTime);

        //グラフィック
        Update_Graphic(in_DeltaTime);

        //死亡チェック
        Check_Dead();
    }

    //Update : Graphic
    public function Update_Graphic(in_DeltaTime:Number):void{
    }

    //Check : Dead
    public function Check_Dead():void{
        //Check
        {
            if(m_IsDead){
                return;
            }
        }

        //マップより下に行っていたら落下死する
        if(this.y > GameMain.MAP_H+GameMain.PANEL_LEN){
            //ゲームオーバー処理
            {
                GameMain.Instance.OnDead_Fall();
            }

            //フラグ
            {
                m_IsDead = true;
            }
        }
    }

    //Update : Move
    public function Update_Move(in_DeltaTime:Number):void{
        //入力
        {
            //X
            {
                var TrgVX:Number = 0.0;
                if(m_InputR){TrgVX =  VEL_X;}
                if(m_InputL){TrgVX = -VEL_X;}

                var ratio:Number = 0.5;
                if(!m_GroundFlag){ratio = 0.2;}//空中では慣性をきかせる
                m_Vel.x = Lerp(m_Vel.x, TrgVX, ratio);
            }

            //Jump
            {
                if(m_InputU && m_GroundFlag){
                    m_Vel.y = -JUMP_VEL;
                }
            }
        }

        //重力
        {
            m_Vel.y += GRAVITY * in_DeltaTime;

            //速度制限
            if(m_Vel.y > FALL_VEL_MIN){
                m_Vel.y = FALL_VEL_MIN;
            }
        }

        //目標位置
        var DstX:Number;
        var DstY:Number;
        {
            DstX = (m_Pos.x) + (m_Vel.x * in_DeltaTime);
            DstY = (m_Pos.y) + (m_Vel.y * in_DeltaTime);
        }

        //移動を試みる
        //・端数制御のためにちょっと特殊なことをしているが、基本的にはただ単にX移動→Y移動してるだけ
        //・壁判定まわりはかなりムダが多い（高速化の余地が多い）が、ひとまずこれで

        //X移動
        {
            var TryX:int = m_Pos.x;
            if(TryX != int(DstX)){
                for(;;){
                    //++
                    if(TryX < DstX){
                        TryX++;
                    }else{
                        TryX--;
                    }

                    //壁があるならその手前で中断
                    if(IsWall(TryX, m_Pos.y)){
                        DstX = m_Pos.x;//壁の手前になるように位置補正（＝端数切捨て）
                        m_Vel.x = 0;
                        break;
                    }

                    //移動できたようなので更新（主に上の位置補正のための記憶用）
                    m_Pos.x = TryX;

                    //Dstまで辿りついたら終了
                    if(TryX == int(DstX)){
                        break;
                    }
                }
            }
            m_Pos.x = DstX;
        }

        //Y移動
        {
            m_GroundFlag = false;//更新のためリセット

            var TryY:int = m_Pos.y;
            if(TryY != int(DstY)){
                for(;;){
                    //++
                    if(TryY < DstY){
                        TryY++;
                    }else{
                        TryY--;
                    }

                    //壁があるならその手前で中断
                    if(IsWall(m_Pos.x, TryY)){
                        if(DstY > m_Pos.y){m_GroundFlag = true;}
                        DstY = m_Pos.y;//壁の手前になるように位置補正（＝端数切捨て）
                        m_Vel.y = 0;
                        break;
                    }

                    //移動できたようなので更新（主に上の位置補正のための記憶用）
                    m_Pos.y = TryY;

                    //Dstまで辿りついたら終了
                    if(TryY == int(DstY)){
                        break;
                    }
                }
            }
            m_Pos.y = DstY;
        }

        //反映
        {
            this.x = m_Pos.x;
            this.y = m_Pos.y;
        }
    }

    //壁があるかどうか
    public function IsWall(in_X:int, in_Y:int):Boolean{
        //プレイヤーを中心とする四角形の四隅が壁にめり込まないようにする
        //・移動方向によって判定を省略して高速化できるはずだが、対応は保留
        //・同じく、Indexが変わらなければ判定をスキップできるはずだが、こちらも保留

        //四角形用のオフセット
        const OffsetX:int = (GameMain.PANEL_LEN-4)/2;
        const OffsetY:int = (GameMain.PANEL_LEN-4)/2;

        for(var i:int = 0; i < 4; i++){
            var PosX:int = in_X + (((i&1)==0)? OffsetX: -OffsetX);
            var PosY:int = in_Y + (((i&2)==0)? OffsetY: -OffsetY);

            if(GameMain.Instance.GetWallVal(PosX, PosY) == GameMain.W){
                return true;//一箇所でもぶつかれば壁があるものとする
            }
        }

        //四隅に壁が見つからなかったら壁はないと判断
        return false;
    }

    //Utility
    public function Lerp(in_Src:Number, in_Dst:Number, in_Ratio:Number):Number{
        return (in_Src * (1 - in_Ratio)) + (in_Dst * in_Ratio);
    }
}


//#Bullet
class Bullet extends Sprite
{
    //=Const=
    static public const VEL:Number = 200;

    //=Var=
    public var m_Vel:Number;

    public var m_KillFlag:Boolean = false;

    //=Function=
    public function Bullet(in_X:int, in_Y:int, in_DirRight:Boolean){
        //Param
        {
            this.x = in_X;
            this.y = in_Y;
            m_Vel = VEL; if(!in_DirRight){m_Vel = -m_Vel;}
        }

        //Graphic
        {
            var shape:Shape = new Shape();
            addChild(shape);

            var g:Graphics = shape.graphics;
            g.lineStyle(0,0,0);
            g.beginFill(0xFF0000, 1.0);
            g.drawCircle(0,0, 8);
            g.endFill();
        }
    }

    public function Update(in_DeltaTime:Number):void{
        //目標位置
        var DstX:Number;
        var DstY:Number;
        {
            DstX = this.x + m_Vel * in_DeltaTime;
            DstY = this.y;
        }

        //移動を試みる
        //・端数制御のためにちょっと特殊なことをしているが、基本的にはただ単にX移動→Y移動してるだけ
        //・壁判定まわりはかなりムダが多い（高速化の余地が多い）が、ひとまずこれで

        //X移動
        {
            var TryX:int = this.x;
            if(TryX != int(DstX)){
                for(;;){
                    //++
                    if(TryX < DstX){
                        TryX++;
                    }else{
                        TryX--;
                    }

                    //壁があるならその手前で中断
                    if(IsWall(TryX, this.y)){
                        //この部分の壁を反転
                        GameMain.Instance.CrossFlip(TryX, this.y);
                        //こいつは消える
                        m_KillFlag = true;
                        break;
                    }

                    //移動できたようなので更新（主に上の位置補正のための記憶用）
                    this.x = TryX;

                    //Dstまで辿りついたら終了
                    if(TryX == int(DstX)){
                        break;
                    }
                }
            }
            this.x = DstX;
        }
    }

    //壁があるかどうか
    public function IsWall(in_X:int, in_Y:int):Boolean{
        return (GameMain.Instance.GetWallVal(in_X, in_Y) == GameMain.W);
    }
}


//#Goal
class Goal extends Sprite
{
    //==Const==

    static public const GOAL_RANGE:int = 16;


    //==Function==

    //Init
    public function Goal(){
        //Graphic
        {
            addChild(ImageManager.CreateGoalGraphic());
        }
    }

    //SetPos
    public function SetPos(in_X:int, in_Y:int):void{
        this.x = in_X;
        this.y = in_Y;
    }

    //Update
    public function Update():void{
        //プレイヤーが一定範囲に来たらゴールとする

        //そもそもすでにゴールしてたら何も処理しない
        {
            if(GameMain.Instance.IsEnd()){
                return;
            }
        }

        //プレイヤーとの距離が一定以上離れていたら何も処理しない
        {
            var GapX:Number = GameMain.Instance.m_Player.x - this.x;
            var GapY:Number = GameMain.Instance.m_Player.y - this.y;

            var Distance:Number = Math.sqrt(GapX*GapX + GapY*GapY);

            if(Distance > GOAL_RANGE){
                return;
            }
        }

        //上のチェックに全てクリアしたらゴールしたものとして処理する
        {
            GameMain.Instance.OnGoal();
        }
    }
}


//#ImageManager
class ImageManager
{
    //Image : Goal
    static public function CreateGoalGraphic():Sprite{
        //
        const W:int = 48;
        const H:int = 64;
        const BLUR_VAL:int = 20;

        //
        var result:Sprite = new Sprite();

        //基本画像
        var bmd:BitmapData = new BitmapData(W, H, true, 0x00000000);
        var bmp:Bitmap = new Bitmap(bmd);
        {
/*
            //白い楕円の上半分を描画
            const RAD_W:int = 12;//W/2-BLUR_VAL;
            const RAD_H:int = 32;//H-BLUR_VAL;

            var shape:Shape = new Shape();
            var g:Graphics = shape.graphics;
            g.lineStyle(0, 0x000000, 0.0);
            g.beginFill(0xFFFFFF, 1.0);
            g.drawEllipse(W/2-RAD_W, H-RAD_H, RAD_W*2, RAD_H*2);
            g.endFill();

//            shape.filters = [new GlowFilter(0xFFFFFF,1.0, 2*BLUR_VAL,2*BLUR_VAL)];
//            shape.filters = [new GlowFilter(0xFFFFFF,1.0, 1,2*BLUR_VAL,255), new GlowFilter(0xFFFFFF,1.0, 2*BLUR_VAL,1,255)];

            bmd.draw(shape);

            shape.filters = [new BlurFilter(BLUR_VAL, BLUR_VAL)];
            bmd.draw(shape);
            bmd.draw(shape);
/*/
            var shape:Shape = new Shape();
            var g:Graphics = shape.graphics;
            g.lineStyle(4, 0xFFFF00, 1.0);
            g.drawCircle(W/2, H - GameMain.PANEL_LEN/2 - 6, GameMain.PANEL_LEN/2);

            shape.filters = [new GlowFilter(0xFF0000,1.0, 6,6)];

            bmd.draw(shape);
//*/

            result.addChild(bmp);
        }

        //発光っぽくする
        {
            //フィルターを追加
//            bmp.filters = [new GlowFilter(0xFFFFFF, 1.0, 2*BLUR_VAL,2*BLUR_VAL)];

            //フィルターで下に広がるのを防止するためのマスク
            var msk:Bitmap = new Bitmap(new BitmapData(W, H, false, 0xFFFFFF));
            result.mask = msk;
            result.addChild(msk);

            //加算化
//            bmp.blendMode = BlendMode.ADD;
        }

        //位置調整
        {
            result.x = -W/2;
            result.y = -H+16;
        }

        return result;
    }
}


