/**
 * Copyright raa ( http://wonderfl.net/user/raa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8u0T
 */

// forked from 178ep3's 17Poker
//17ポーカー
//コードが汚いけどとりあえずアップ。

package
{
    import caurina.transitions.Tweener;
    
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    
    [SWF(backgroundColor=0x009900, frameRate=30)]
    public class Poker17 extends Sprite
    {
        private var _kindList:Array = ["Spade","Clover","Dia","Heart"];
        private var _numList:Array = [1,11,12,13];
        
        private var _patternName:Array = ["5 card","Royal straight Flash","4 card","full house","straight","3 card","2 pair","1 pair"];
        private var _dealerPattern:String;
        private var _myPattern:String;
        
        private var _cardList:Array = [];
        private var _myCard:Array = [];
        private var _dealerCard:Array = [];
        
        private var _cardStg:Sprite;
        private var _dealerStg:Sprite;
        private var _changeBtn:SampleBtn;
        
        private var _jTf:TextField;
        private var _caver:Sprite;
        
        private var _coin:int=100;
        private var _floatCoin:uint=0;
        private var _coinTf:TextField;
        
        public function Poker17()
        {
            if(stage)setup();
            else addEventListener(Event.ADDED_TO_STAGE,setup);
        }
        
        private function setup(e:Event=null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE,init);
            
            _coinTf = addChild(new TextField())as TextField;
            _coinTf.y = 442;
            _coinTf.defaultTextFormat = new TextFormat("_ゴシック",12,0xffffff);
            _coinTf.autoSize = TextFieldAutoSize.LEFT;
            _coinTf.selectable = false;
            _coinTf.text = "POINT : " +_coin.toString();
            init();
        }
        
        private function init(e:Event=null):void
        {
            var i:uint = 0;
            var q:uint = 0;
            for(q=0; q<4; q++)
            {
                for(i=0; i<4; i++)
                {
                    var card:Card = new Card(_kindList[q],_numList[i]);
                    card.x = (320-card.width)*0.5;
                    card.y = (465-card.height)*0.5;
                    _cardList.push(card);
                }
            }
            var joker:Card = new Card("joker",0);
            joker.x = (320-joker.width)*0.5;
            joker.y = (465-joker.height)*0.5;
            _cardList.push(joker);
            
            for(i=0; i<50; i++)
            {
                var sc:Card = _cardList.shift();
                _cardList.splice(Math.random()*17,0,sc);
            }
            
            for(i=0; i<5; i++)
            {
                var mc:Card = _cardList.shift();
                _myCard.push(mc);
                var dc:Card = _cardList.shift();
                dc.offCard();
                _dealerCard.push(dc);
            }
            
            _cardStg = addChild(new Sprite())as Sprite;
            _dealerStg = addChild(new Sprite())as Sprite;
            
            _caver = addChild(new Sprite())as Sprite;
            _caver.graphics.beginFill(0,0);
            _caver.graphics.drawRect(0,0,320,100);
            _caver.graphics.endFill();
            
            _changeBtn = addChild(new SampleBtn("change"))as SampleBtn;
            _changeBtn.x = 160 - _changeBtn.width*0.5;
            _changeBtn.y = 233 - _changeBtn.height*0.5;
            _changeBtn.addEventListener(MouseEvent.CLICK,changeCard);
            _changeBtn.buttonMode = true;
            
            _coinTf.text = "POINT : " +_coin.toString();
            
            addCard();
        }
        
        private function changeCard(e:MouseEvent):void
        {
            _changeBtn.visible = false;
            AI.DealerSelect(_dealerCard);
            var i:uint = 0;
            for(i=0; i<5; i++)
            {
                if(_myCard[i].select)
                {
                    _myCard[i].clear();
                    Tweener.addTween(_myCard[i],{time:0.2,y:500,transition:"linear"});
                    _myCard[i] = _cardList.shift();
                }
                
                if(_dealerCard[i].select)
                {
                    _dealerCard[i].clear();
                    if(_cardList.length>0)
                    {
                        Tweener.addTween(_dealerCard[i],{time:0.2,y:-100,transition:"linear"});
                        _dealerCard[i] = _cardList.shift();
                    }
                }
            }
            Tweener.addTween(this,{time:0.2,onComplete:next});
            
            function next():void
            {
                addCard();
                _myPattern = AI.judge(_myCard);
                _dealerPattern = AI.judge(_dealerCard);
                Tweener.addTween(this,{time:0.7,onComplete:win});
            }
        }
        
        private function addCard():void
        {
            var i:uint;
            if(_cardStg.numChildren>0)
            {
                for(i=0; i<5; i++)
                {
                    _cardStg.removeChildAt(0);
                    _dealerStg.removeChildAt(0);
                }
            }
            
            for(i=0; i<5; i++)
            {
                _cardStg.addChildAt(_myCard[i],0);
                Tweener.addTween(_myCard[i],{delay:0.1*i,time:0.2,x:60*i+10,y:355,transition:"linear"});
                
                _dealerStg.addChildAt(_dealerCard[i],0);
                _dealerCard[i].offCard();
                Tweener.addTween(_dealerCard[i],{delay:0.1*i,time:0.2,x:60*i+10,y:10,transition:"linear"});
            }
        }
        
        private function win():void
        {
            var i:uint;
            for(i=0; i<5; i++)
            {
                var ca:Card = _dealerStg.getChildAt(i)as Card;
                ca.onCard();
            }
            
            var my:uint = _patternName.indexOf(_myPattern);
            var de:uint = _patternName.indexOf(_dealerPattern);
            var winner:String = (my<de)? "YOU WIN" : "YOU LOSE";
            if(_myPattern==_dealerPattern)winner = "DRAW";
            
            if(winner=="YOU WIN")
            {
                _coin += (10+_floatCoin);
                _floatCoin = 0;
            }
            else if(winner=="YOU LOSE")
            {
                _coin-=10;
                _floatCoin=0;
            }
            else
            {
                _coin-=10;
                _floatCoin += 20;
            }
            
            _jTf = addChild(new TextField())as TextField;
            _jTf.selectable = false;
            _jTf.defaultTextFormat = new TextFormat("_ゴシック",20);
            _jTf.autoSize = TextFieldAutoSize.LEFT;
            _jTf.text = "Dealer : " + _dealerPattern + "\n" + 
                        "YOU : " + _myPattern + "\n" + winner;
            _jTf.defaultTextFormat = new TextFormat("_ゴシック",12,0xff0000);
            _jTf.appendText("\nclick to restart!");
            _jTf.x = 160 - _jTf.width*0.5;
            _jTf.y = 233 - _jTf.height*0.5;
            
            if(_coin>0)_jTf.addEventListener(MouseEvent.CLICK,reset);
            else _jTf.text = "GAME OVER...";
        }
        
        private function reset(e:MouseEvent):void
        {
            removeChild(_jTf);
            removeChild(_cardStg);
            removeChild(_dealerStg);
            _dealerStg = null;
            _cardStg = null;
            _jTf = null;
            _myCard = [];
            _dealerCard = [];
            _myPattern = "";
            _dealerPattern = "";
            _cardList = [];
            
            init();
        }
    }
}

    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;

class AI
{
    public function AI(){}
    
    public static function DealerSelect(list:Array):void
    {
        var change:Array = [true,true,true,true,true];
        var i:uint = 0;
        for(i=0; i<5; i++)
        {
            if(list[i].num==0)
            {
                change[i] = false;
                break;
            }
        }
        var useList:Array = list.slice();
        var len:uint = list.length;
        useList.sortOn("num",Array.NUMERIC);
        var iq:Array=[];
        var count:uint=0;
        for(i=0;i<len-1;i++)
        {
            if(useList[i].num == useList[i+1].num)iq.push(i);
        }
        count = iq.length;
        
        for(i=0; i<count; i++)
        {
            var se:uint = list.indexOf(useList[iq[i]]);
            change[se] = false;
            var se2:uint = list.indexOf(useList[iq[i]+1]);
            change[se2] = false;
        }
        for(i=0; i<5; i++)
        {
            if(change[i])list[i].select = true;
        }
    }
    
    public static function judge(list:Array):String
    {
        var pattern:String="";
        var i:uint = 0;
        var j:Boolean = false;
        for(i=0; i<5; i++)
        {
            if(list[i].num==0)
            {
                list.splice(i,1);
                j=true;
                break;
            }
        }
        var len:uint = list.length;
        list.sortOn("num",Array.NUMERIC);
        var iq:Array=[];
        var count:uint=0;
        for(i=0;i<len-1;i++)
        {
            if(list[i].num == list[i+1].num)iq.push(i);
        }
        count = iq.length;
        if(count==1)pattern = "1 pair";
        else if(count==2 && iq[0]+1!=iq[1])pattern = "2 pair";
        else if(count==2)pattern = "3 card";
        else if(count==3 && (iq[0]+2 == iq[2]))pattern = "4 card";
        else if(count==3)pattern = "full house";
        else if(j)
        {
            if(list[0].kind == list[1].kind == list[2].kind == list[3].kind)pattern="Royal straight Flash";
            else pattern="straight";
        }
        if(j && pattern != "Royal straight Flash")
        {
            if(pattern=="1 pair")pattern = "3 card";
            else if(pattern=="2 pair")pattern = "full house";
            else if(pattern=="3 card")pattern = "4 card";
            else if(pattern=="4 card")pattern = "5 card";
            else if(pattern=="")pattern = "1 pair";
        }
        
        return pattern;
    }    
}

class Card extends Sprite
{
    private var _tf:TextField;
    private var _kind:String;
    private var _num:uint;
    private var _select:Boolean = false;
    
    public function Card(kind:String,num:uint)
    {
        _kind = kind;
        _num = num;
        
        this.graphics.beginFill(0xffffff);
        this.graphics.lineStyle(1);
        this.graphics.drawRect(0,0,50,80);
        this.graphics.endFill();
        this.mouseChildren = false;
        
        var color:uint = 0;
        if(_kind=="Dia" || _kind=="Heart")color=0xff0000;
        
        _tf = addChild(new TextField())as TextField;
        _tf.defaultTextFormat = new TextFormat("_ゴシック",12,color);
        _tf.autoSize = TextFieldAutoSize.CENTER;
        _tf.selectable = false;
        
        if(_kind=="joker")_tf.text = _kind;
        _tf.defaultTextFormat =  new TextFormat("_ゴシック",30,color);
        if(_kind=="Spade") _tf.text = "♠ \n";
        else if(_kind=="Clover") _tf.text = "♣ \n";
        else if(_kind=="Dia") _tf.text = "♦ \n";
        else if(_kind=="Heart")_tf.text = "♥ \n";
        _tf.defaultTextFormat =  new TextFormat("_ゴシック",12,color);
        if(_num==1) _tf.appendText("A");
        else if(_num==11) _tf.appendText("XI");
        else if(_num==12) _tf.appendText("XⅡ");
        else if(_num==13) _tf.appendText("XⅢ");
        
        _tf.x = 25 - _tf.width*0.5;
        _tf.y = 40 - _tf.height*0.5;
        
        this.addEventListener(MouseEvent.CLICK,click);
        this.buttonMode = true;
    }
    
    private function click(e:MouseEvent):void
    {
        _select = !_select;
        this.graphics.clear();
        if(_select)this.graphics.beginFill(0x888888);
        else this.graphics.beginFill(0xffffff);
        this.graphics.lineStyle(1);
        this.graphics.drawRect(0,0,50,80);
        this.graphics.endFill();
    }
    
    public function onCard():void
    {
        _tf.visible = true;
    }
    
    public function offCard():void
    {
        _tf.visible = false;
    }
    
    public function get kind():String
    {
        return _kind;
    }
    
    public function get num():uint
    {
        return _num;
    }
    
    public function get select():Boolean
    {
        return _select;
    }
    
    public function set select(value:Boolean):void
    {
        _select = value;
    }
    
    public function clear():void
    {
        this.graphics.clear();
        this.graphics.beginFill(0xffffff);
        this.graphics.lineStyle(1);
        this.graphics.drawRect(0,0,50,80);
        this.graphics.endFill();
    }
}

class SampleBtn extends Sprite
{
    private var _tf:TextField;
        
    public function SampleBtn(value:String="")
    {
        _tf = addChild(new TextField())as TextField;
        _tf.autoSize = TextFieldAutoSize.LEFT;
        _tf.selectable = false;
        _tf.text = value;
        _tf.x = _tf.y = 5;
            
        this.graphics.lineStyle(1);
        this.graphics.beginFill(0xffffff);
        this.graphics.drawRect(0,0,_tf.width+10 , _tf.height+10);
        this.graphics.endFill();
        this.mouseChildren = false;
    }    
}
