/**
 * Copyright Scmiz ( http://wonderfl.net/user/Scmiz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8tg6
 */

package {
    import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;

    public class FlashTest extends Sprite {
		private var _target:Sprite;
		private var _frame:uint;
		
        public function FlashTest() {
			this.graphics.beginFill(0x000000);
			this.graphics.drawRect(0, 0, 465, 465);
			this.graphics.endFill();
			
			_target = new Sprite();
			_target.x = 232.5;
			_target.y = 232.5;
			
			_frame = 0;
			
			this.addChild(_target);
			
			this.addEventListener(Event.ENTER_FRAME, proc);
        }
		
		private function proc(e:Event):void {
			++_frame;
			if (_frame > 2) {
				createBullet();
				_frame = 0;
			}
		}
		
		private function createBullet():void {
			var start:Number = Math.random() * Math.PI * 2;
			var bullet:Bullet = new Bullet(
				600 * Math.cos(start),
				600 * Math.sin(start),
				600 * Math.random(),
				600 * Math.random(),
				_target.x,
				_target.y);
			this.addChild(bullet);
		}
    }
}

import flash.display.Sprite;
import flash.events.Event;
import caurina.transitions.Tweener;

class Bullet extends Sprite
{
	private var _startX:Number;
	private var _startY:Number;
	private var _controlX:Number;
	private var _controlY:Number;
	private var _targetX:Number;
	private var _targetY:Number;
	private var _frame:uint;
	
	public function Bullet(startX:Number, startY:Number, controlX:Number, controlY:Number, targetX:Number, targetY:Number) {
		_startX = startX;
		_startY = startY;
		_controlX = controlX;
		_controlY = controlY;
		_targetX = targetX;
		_targetY = targetY;
		_frame = 0;
		
		this.x = _startX;
		this.y = _startY;
		
		var rnd:Function = function():uint { return 128 + (128 * Math.random()); }
		var color:uint = (rnd() << 16) + (rnd() << 8) + (rnd() << 0);
		
		this.graphics.beginFill(color);
		this.graphics.drawCircle(0, 0, 1 + (Math.random() * 9));
		this.graphics.endFill();
		
		this.addEventListener(Event.ENTER_FRAME, proc);
	}
	
	private function proc(e:Event):void {
		++_frame;
		var maxFrame:uint = 60;
		var t:Number = Number(_frame) / maxFrame;
		
		var sin:Number = Math.sin(t * Math.PI * 0.5);
		var baseX:Number = (_startX * (1.0 - sin)) + (_targetX * sin);
		var baseY:Number = (_startY * (1.0 - sin)) + (_targetY * sin);
		
		var g:Number = 0;
		var border:Number = 0.5;
		if (t <= border) {
			g = t / border;
		}
		else {
			g = 1.0 - ((t - border) / (1.0 - border));
		}
		g = 1.0 - Math.sin(g * Math.PI * 0.5);
		g = g * g;
		g = 1.0 - g;
		
		g = g * 0.6; // 強度

		this.x = (baseX * (1.0 - g)) + (_controlX * g);
		this.y = (baseY * (1.0 - g)) + (_controlY * g);
		
		if (_frame == maxFrame) {
			dead();
		}
	}
	
	private function dead():void {
		this.removeEventListener(Event.ENTER_FRAME, proc);
		
		this.x = _targetX;
		this.y = _targetY;
		
		Tweener.addTween(this, {
			alpha:0,
			scaleX:1.5,
			scaleY:1.5,
			time:10,
			useFrames:true,
			onComplete:function():void {
				parent.removeChild(this);
			}
		});
	}
	
	private function equals(a1:Number, a2:Number):Boolean {
		return Math.abs(a1 - a2) < 0.0001;
	}
}