/**
 * Copyright shimo3651 ( http://wonderfl.net/user/shimo3651 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8teB
 */

package
{
    import flash.display.BitmapData;
    import flash.display.GraphicsBitmapFill;
    import flash.display.GraphicsEndFill;
    import flash.display.GraphicsTrianglePath;
    import flash.display.IGraphicsData;
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;

    public class Test002 extends MovieClip
    {
        private var _graphicsTrianglePath:GraphicsTrianglePath;
        private var _sprite:Sprite;
        private var _apex:Array;
        private var _apexNum:int = 0;
        private var _vertices:Vector.<Number>;
        private var _indices:Vector.<int>;
        private var _uvtData:Vector.<Number>;
        private var _bitmapData:BitmapData;
        public function Test002(){
            // write as3 code here..
            addEventListener(Event.ADDED_TO_STAGE,addStageHandler);
            
        }
        private function addStageHandler(event:Event):void{
            
            _bitmapData = new BitmapData(100,100);
            _bitmapData.noise(Math.random() * int.MAX_VALUE);
            
            _vertices = new Vector.<Number>();
            _indices = new Vector.<int>();
            _uvtData = new Vector.<Number>();
            
            var halfWidth:int = (stage.stageWidth - 100)/2;
            var halfHeight:int = (stage.stageHeight - 100)/2;
            
            _vertices.push(halfWidth,halfHeight);
            _vertices.push(halfWidth,halfHeight + 100);
            _vertices.push(halfWidth + 100,halfHeight);
            _vertices.push(halfWidth + 100,halfHeight + 100);
            
            _uvtData.push(0,0);
            _uvtData.push(0,1);
            _uvtData.push(1,0);
            _uvtData.push(1,1);
            
            _indices.push(0,1,2);
            _indices.push(1,2,3);
            
            var graphicsData:Vector.<IGraphicsData> = new Vector.<IGraphicsData>();
            graphicsData.push(new GraphicsBitmapFill(_bitmapData));
            graphicsData.push(_graphicsTrianglePath = new GraphicsTrianglePath(_vertices, _indices, _uvtData));
            graphicsData.push(new GraphicsEndFill());
            
            _sprite = new Sprite();
            _sprite.graphics.drawGraphicsData(graphicsData);
            addChild(_sprite);
            
            _apex = new Array();
            for(var i:int = 0;i<4;i++){
                _apex[i] = new Sprite();
                _apex[i].graphics.lineStyle(0x000000);
                _apex[i].graphics.beginFill(0xffffff);
                _apex[i].graphics.drawCircle(0,0,5);
                _apex[i].x = _vertices[i*2];
                _apex[i].y = _vertices[i*2+1];
                _apex[i].addEventListener(MouseEvent.MOUSE_DOWN,mouseDownHandler);
                addChild(_apex[i]);
            }
            addEventListener(MouseEvent.MOUSE_UP,mouseUpHandler);
        }
        private function mouseDownHandler(event:MouseEvent):void{
            if(event.target == _apex[0])_apexNum = 0;
            else if(event.target == _apex[1])_apexNum = 1;
            else if(event.target == _apex[2])_apexNum = 2;
            else if(event.target == _apex[3])_apexNum = 3;
            
            _apex[_apexNum].graphics.lineStyle(0x000000);
            _apex[_apexNum].graphics.beginFill(0xff0000);
            _apex[_apexNum].graphics.drawCircle(0,0,5);

            addEventListener(Event.ENTER_FRAME,mouseMoveHandler);
        }
        private function mouseUpHandler(event:MouseEvent):void{
            _apex[_apexNum].graphics.lineStyle(0x000000);
            _apex[_apexNum].graphics.beginFill(0xffffff);
            _apex[_apexNum].graphics.drawCircle(0,0,5);
            
            removeEventListener(Event.ENTER_FRAME,mouseMoveHandler);
        }
        private function mouseMoveHandler(event:Event):void{
            _apex[_apexNum].x = mouseX;
            _apex[_apexNum].y = mouseY;
            //trace(_vertices.length);
            _vertices[_apexNum*2] = mouseX;
            _vertices[_apexNum*2 + 1] = mouseY;
            
            var graphicsData:Vector.<IGraphicsData> = new Vector.<IGraphicsData>();
            graphicsData.push(new GraphicsBitmapFill(_bitmapData));
            graphicsData.push(_graphicsTrianglePath = new GraphicsTrianglePath(_vertices, _indices, _uvtData));
            graphicsData.push(new GraphicsEndFill());
            
            _sprite.graphics.clear();
            _sprite.graphics.drawGraphicsData(graphicsData);
        }

    }
}