/**
 * Copyright DOYA005 ( http://wonderfl.net/user/DOYA005 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8tC3
 */

// forked from shmdmoto's forked from: 海亀様と遊ぼう（改）
// forked from DOYA005's 海亀様と遊ぼう（改）
// forked from shmdmoto's forked from: 海亀様と遊ぼう（改）
// forked from DOYA005's 海亀様と遊ぼう（改）
// forked from shmdmoto's forked from: 海亀様と遊ぼう
// forked from DOYA005's 海亀様と遊ぼう
// forked from shmdmoto's 最終課題「海亀様と遊ぼう」
package 
{
    import flash.display.AVM1Movie;
    import flash.ui.Keyboard;
    import flash.events.KeyboardEvent;
    import flash.display.Loader;
    import flash.net.URLRequest;
    import frocessing.display.F5MovieClip2D;
    /**
     * 画像ファイルの表示
     * @author shmdmoto
     */
    public class miniGame1 extends F5MovieClip2D
    {
        public var isContLeft:Boolean;
        public var isContRight:Boolean;
        public var isContUp:Boolean;
        public var isContDown:Boolean;
        public var imgHaikei:Loader; // 背景の画像
        public var imgHammer:Loader; // ハンマーの画像
        public var imgTaiyaki:Loader; // たいやきの画像
        public var imgAitemu:Loader; // アイテム持ちたいやき
        public var imgUmigamesama:Loader; // 海亀様
        public var imgCulia:Loader; // クリアの画像
        public var lfoX:LFO;
        public var countTaiyakiHit:int; // 鯛焼きをたたいた回数
        public var countAitemuHit:int; //  アイテム持ちをたたいた回数
        public var countUmigamesamaHit:int; //　海亀様をたたいた回数
        public function miniGame1() {
             Wonderfl.disable_capture();
             super(false);
        }
         public function setup() : void
        {
            imgHaikei = new Loader(); 
            imgHaikei.load( new URLRequest("http://www.motoike.net/wonderfl/haikei.png") );
            addChild(imgHaikei);
            imgHammer = new Loader();
            imgHammer.load( new URLRequest("http://www.motoike.net/wonderfl/hanmar.png") );
            imgHammer.visible = true; 
            addChild(imgHammer);
            countTaiyakiHit = 0; //　たたいた回数を0に初期化            
            imgTaiyaki = new Loader(); 
            imgTaiyaki.load( new URLRequest("http://www.motoike.net/wonderfl/taiyaki.png") ); 
            addChild(imgTaiyaki); 
            countAitemuHit = 0; //　たたいた回数を初期化
            imgAitemu = new Loader();
            imgAitemu.load( new URLRequest("http://www.motoike.net/wonderfl/aitemu.png") );
            addChild(imgAitemu);
            countUmigamesamaHit = 0; // たたいた回数を初期化
            imgUmigamesama = new Loader();
            imgUmigamesama.load( new URLRequest("http://www.motoike.net/wonderfl/umigamesama.png") );
            addChild(imgUmigamesama);
            imgCulia = new Loader();
            imgCulia.load( new URLRequest("http://www.motoike.net/wonderfl/culia.png") );
            addChild(imgCulia);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
            stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
            // 動かない画像の位置設定
            imgTaiyaki.x = 125;
            imgTaiyaki.y = 125;
            imgAitemu.x = 90;
            imgAitemu.y = 90;
            // 画像を動かすためのLFOの設定
            lfoX = new LFO(3,100);
       }
        public function onKeyDown(event:KeyboardEvent):void 
        {
            if( event.keyCode == Keyboard.LEFT ) {
                isContLeft = true;
            }
            if( event.keyCode == Keyboard.RIGHT ) {
                isContRight = true;
            }
            if( event.keyCode == Keyboard.UP ) {
                isContUp = true;
            }
            if( event.keyCode == Keyboard.DOWN ) {
                isContDown = true;
            } 
        }
        public function onKeyUp(event:KeyboardEvent):void 
        {
            if( event.keyCode == Keyboard.LEFT ) {
                isContLeft = false;
            }
            if( event.keyCode == Keyboard.RIGHT ) {
                isContRight = false;   
            }
            if( event.keyCode == Keyboard.UP ) {
                isContUp = false;
            }
            if( event.keyCode == Keyboard.DOWN ) {
                isContDown = false;
            }
            if( event.keyCode == Keyboard.SPACE ) {// スペースキーが放されたら
                 if( imgHammer.hitTestObject(imgTaiyaki) ) { // 鯛焼きと当たり判定
                 　　countTaiyakiHit += 3;　// たたいた回数を0に初期化
                    imgTaiyaki.visible = false; // 鯛焼きの上ならば鯛焼きを消す。
                 }
                 if( imgHammer.hitTestObject(imgAitemu) ) { // アイテム付き鯛焼きと当たり判定
                 　　countAitemuHit += 2; 　// たたいた回数を0に初期化
                    imgAitemu.visible = false; // アイテム付き鯛焼きの上ならばアイテム付き鯛焼きを消す。
                 }      
                 if( imgHammer.hitTestObject(imgUmigamesama) ) { // 海亀様と当たり判定
                 　　countUmigamesamaHit += 1;  // たたいた回数を0に初期化　
                    imgUmigamesama.visible = false; // 海亀様の上ならば海亀様を消す。 
                 }
                  if( imgHammer.hitTestObject(imgCulia) ) { 
                    imgCulia.visible = false;   
                    imgCulia.visible = true;    
                }

            }

        }
        public function draw() : void
        {
            if( isContLeft ) // ←が押し続けられている
              imgHammer.x -= 3;
            if( isContRight ) // →が押し続けられている
              imgHammer.x += 3; 
            if( isContUp ) // ↑が押し続けられている
              imgHammer.y -= 3;
            if( isContDown ) // ↓が押し続けられている
              imgHammer.y += 3;  
            //
            imgUmigamesama.x = lfoX.val();
        }
    }
}

// 以下は，動きを記述するためのクラスですので，編集しないでください．
import flash.utils.getTimer;
import frocessing.math.PerlinNoise;
/**
 * Interpolate:指定した時間で，開始値から終値までの過渡的を
 *             記述するクラス
 */
class Interpolate
{
    private static const NOINIT  :int = 1;
    private static const RUNNING :int = 2;
    private static const WAITING :int = 3;
    private static const STOPPED :int = 4;
    private var duration  :Number;
    private var begin     :Number;
    private var end       :Number;
    private var pow       :Number;
    private var tOffset   :Number;
    private var tElapsed  :Number;
    private var prevVal   :Number;
    private var tRestart  :Number;
    public  var status    :int = NOINIT;
    public function Interpolate( t:Number, s:Number, f:Number,
                                 p:Number = 1) {
        begin = prevVal = s;
        end = f;
        duration = t;
        pow = p;
        tOffset = 0;
        tElapsed = 0;
    }
    public function val() :Number {
        var t :Number;
        if( status == NOINIT){
            tOffset = getTimer()/1000;
            prevVal = begin;
            status = RUNNING;
        } else if( status == RUNNING ) {
            t = getTimer()/1000;
            tElapsed = t -tOffset;
            if( tElapsed < duration ) {
                prevVal = begin + ( end - begin )*Math.pow(tElapsed/duration,pow);
            } else {
                prevVal = end;
                status = STOPPED;
            }
        } else if( status == WAITING){
            t = getTimer()/1000;
            if( t >= tRestart) {
                status = RUNNING;
                tOffset = t - tElapsed;        
            }
        }
        return prevVal;
    }
    public function pause() :void
    {
        status = STOPPED;
    }
    public function cont() :void
    {
        status = RUNNING;
        tOffset = getTimer()/1000-tElapsed;        
    }
    public function start() :void
    {
        status = RUNNING;
        tOffset = getTimer()/1000;                
    }
    public function wait( waitTime :Number ) :void
    {
        status = WAITING;
        tRestart = getTimer() + waitTime;
    }
    
    public function isRunning() :Boolean
    {
        if( status == RUNNING ) {
            return true;
        } else {
            return false;
        }
    }
    public function isStopped() :Boolean
    {
        if( status == STOPPED ) {
            return true;
        } else {
            return false;
        }
    }
    public function isEnd() :Boolean
    {
        if( prevVal >= end) {
            return true;
        } else {
            return false;
        }
    }
}
/**
 * LFO:指定した時間での周期的変動を記述するクラス
 */
class LFO {
    public static const SIN    :int = 1;
    public static const COS    :int = 2;
    public static const SAW    :int = 3;
    public static const TRI    :int = 4;
    public static const SQR    :int = 5;
    public static const ABSSIN :int = 6;
    public static const NOISE  :int = 7;
    private static const NOINIT  :int = 1;
    private static const RUNNING :int = 2;
    private static const WAITING :int = 3;
    private static const STOPPED :int = 4;
    private var period    :Number;
    private var amplitude :Number;
    private var phase     :Number;
    private var offset    :Number;
    private var type      :int = SIN;
    private var isStart   :Boolean;
    private var t_offset  :Number;
    private var status    :int = NOINIT;
    
    public function LFO( prd :Number, amp :Number,
                         of :Number = 0, ph :Number = 0)
    {
        period    = prd;
        amplitude = amp;
        offset    = of;
        phase     = ph;
    }
    public function setPeak( min :Number, max :Number) :void
    {
        offset = (min + max) / 2;
        if( min < max ) {
            amplitude    = (max - min) / 2;
        } else {
            amplitude    = (min - max) / 2;
        }        
    }
    public function setType( t :int ) :void
    {
        type = t;
    }
    public function val( mul :Number=1.0 ) :Number {
        if(status == NOINIT) {
            status = RUNNING;
            t_offset = getTimer() / 1000.0;
            return val();
        } else if(status == RUNNING　) {
            var t :Number = getTimer() / 1000.0 - t_offset;
            var temp :Number;
            switch(type) {
                case SIN :
                    return  offset + mul * amplitude * 
                    Math.sin(2.0 * Math.PI *( t/period + phase) );
                case COS :
                    return  offset + mul * amplitude *
                    Math.cos(2.0 * Math.PI *( t/period + phase) );
                case SAW :
                    temp = t / period + 0.5 + phase - 
                    Math.floor( t / period + 0.5 + phase ) - 0.5;
                    return  offset + 2.0 * mul * amplitude * temp;
                case TRI :
                    temp = t / period + phase - 
                    Math.floor (t / period + phase );
                    if( 0.0 <= temp && temp < 0.25 ) {
                        return offset + mul * amplitude * 4.0 * temp;
                    } else if( temp < 0.75 ) {
                        return offset + mul * amplitude * (  2.0 - 4.0 * temp);
                    } else {
                        return offset + mul * amplitude * ( -4.0 + 4.0 * temp);
                    }
                case SQR :
                    temp = t/period + phase - 
                    Math.floor( t / period + phase);
                    if( temp < 0.5 ){
                        return offset + mul * amplitude;
                    } else {
                        return offset - mul * amplitude;
                    }
                case ABSSIN :
                    return  offset + 
                    Math.abs(mul * amplitude * Math.sin(2.0*Math.PI *( t/period + phase)));
                case NOISE :
                    var p :PerlinNoise = new PerlinNoise(); 
                    return offset -mul * amplitude + 2.0 * mul * amplitude * p.noise(t/period+phase,1);
                default :
                    return 0.0;
            }
        } else {
            return 0.0;
        }        
    }
}