/**
 * Copyright tktr90755 ( http://wonderfl.net/user/tktr90755 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/8t6n
 */

package  
{
	import com.flashdynamix.utils.SWFProfiler;
	import flash.display.Shape;
	import flash.display.Sprite;
	import gs.easing.Quart;
	import gs.TweenMax;
	[SWF(backgroundColor = 0x000000, frameRate = 60)]
	public class Index extends Sprite
	{
		private var homing1:Homing;
		private var homing2:Homing;
		private var homing3:Homing;
		private var homing4:Homing;
		private var homing5:Homing;
		//private var homing6:Homing;
		//private var homing7:Homing;
		//private var homing8:Homing;
		//private var homing9:Homing;
		//private var homing10:Homing;
		private var homing11:Homing;
		
		private var shape1:Shape;
		private var shape2:Shape;
		
		public function Index() 
		{
			SWFProfiler.init(this);
			
			homing1 = new Homing(stage);
			homing2 = new Homing(stage);
			homing3 = new Homing(stage);
			homing4 = new Homing(stage);
			homing5 = new Homing(stage);
			//homing6 = new Homing(stage);
			//homing7 = new Homing(stage);
			//homing8 = new Homing(stage);
			//homing9 = new Homing(stage);
			//homing10 = new Homing(stage);
			homing11 = new Homing(stage);
			
			shape1 = new Shape();
			shape1.graphics.beginFill(0x007ad1, 1);
			shape1.graphics.drawRect( -5, -5, 10, 10);
			addChild(shape1);
			move1();
			
			shape2 = new Shape();
			shape2.graphics.beginFill(0x007ad1, 1);
			shape2.graphics.drawCircle( 0, 0, 5);
			addChild(shape2);
			move2();
		}
		
		private function move1():void 
		{
			var w:uint = Math.random() * stage.stageWidth;
			var h:uint = Math.random() * stage.stageHeight;
			var bw:uint = Math.random() * stage.stageWidth;
			var bh:uint = Math.random() * stage.stageHeight;
			TweenMax.to
			(
				shape1, 
				0.5, 
				{
					x				:w, 
					y				:h, 
					bezierThrough	:[ { x:bw, y:bh } ],
					orientToBezier	:true, 
					ease				:Quart.easeInOut,
					onComplete		:move1,
					onUpdate			:function():void
					{ 
						homing1.to(shape1.x, shape1.y, "square", 0xFFFFFF, 2, 15, 10); 
						homing2.to(shape1.x, shape1.y, "square", 0xFFFFFF, 2, 15, 15);  
						homing3.to(shape1.x, shape1.y, "square", 0xFFFFFF, 2, 15, 20); 
						homing4.to(shape1.x, shape1.y, "square", 0xFFFFFF, 2, 15, 25); 
						homing5.to(shape1.x, shape1.y, "square", 0xFFFFFF, 2, 15, 30); 
						//homing6.to(shape1.x, shape1.y, "square", 0xFFFFFF, 2, 15, 35); 
						//homing7.to(shape1.x, shape1.y, "square", 0xFFFFFF, 2, 15, 40); 
						//homing8.to(shape1.x, shape1.y, "square", 0xFFFFFF, 2, 15, 45); 
						//homing9.to(shape1.x, shape1.y, "square", 0xFFFFFF, 2, 15, 50); 
						//homing10.to(shape1.x, shape1.y, "square", 0xFFFFFF, 2, 15, 55); 
					}
				}
			);
		}
		private function move2():void 
		{
			var w:uint = Math.random() * stage.stageWidth;
			var h:uint = Math.random() * stage.stageHeight;
			var bw:uint = Math.random() * stage.stageWidth;
			var bh:uint = Math.random() * stage.stageHeight;
			TweenMax.to
			(
				shape2, 
				1, 
				{
					x				:w, 
					y				:h, 
					bezierThrough	:[ { x:bw, y:bh } ],
					orientToBezier	:true, 
					ease				:Quart.easeInOut,
					onComplete		:move2,
					onUpdate			:function():void 
					{ 
						homing11.to(shape2.x, shape2.y, "circle", 0xFFFFFF, 1, 8, 25); 
					}
					
				}
			);
		}
	}
}

import flash.display.DisplayObjectContainer;
import flash.display.Shape;
import flash.events.Event;
class Homing
{
	private var container	:DisplayObjectContainer;
	private var oldX		:Number;
	private var oldY		:Number;
	private var currentX	:Number;
	private var currentY	:Number;
	
	/**
	 * @param container 		ターゲットコンテナ
	 */
	public function Homing(_container:DisplayObjectContainer)
	{
		container = _container;
	}
	
	/**
	 * @param positionX 		ポジションX
	 * @param positionY 		ポジションY
	 * @param type 			"square"か"circle"か
	 * @param color 			色
	 * @param minSize 		パーティクルの最小サイズ
	 * @param maxSize 		パーティクルの最大サイズ
	 * @param disperse 		パーティクルの散らばり具合
	 * @param speed 			パーティクルの進行方向へのスピード
	 * @param distanceLimit 	古いポジションと新しいポジションとの距離間の許容値
	 */
	
	public function to( 
		positionX:uint, 
		positionY:uint, 
		type:String 			= "square", 
		color:int 			= 0xFFFFFF, 
		minSize:int 			= 2, 
		maxSize:int 			= 15, 
		disperse:int 		= 15, 
		speed:int 			= 50,
		distanceLimit:int 	= 10
	):void
	{
		//移動前のポジション
		oldX = currentX;
		oldY = currentY;
		//移動後のポジション
		currentX = positionX;
		currentY = positionY;
		//移動前に対して移動後への方向をもとめる
		var angle:Number = Math.atan2 (currentY - oldY, currentX - oldX);
		var distanceX:Number = Math.cos (angle);
		var distanceY:Number = Math.sin (angle);
		//移動前と移動後との距離をもとめる
		var distance:int = int(Math.sqrt ((currentY - oldY) * (currentY - oldY) + (currentX - oldX) * (currentX - oldX)));
		//古いポジションと新しいポジションとの距離間が10以上ならばパーティクルを出す（シャッとしたら出す）
		if (distance >= distanceLimit)
		{
			//大きさ
			var radius:int = int(Math.random () * (maxSize - minSize)) + minSize;
			//散りぐあい
			var disperse:int;
			if ((Math.random() * 2 >> 0) == 1) { disperse = int(Math.random () * disperse) * ( -1); } else { disperse = int(Math.random () * disperse) * 1; };
			//目的地
			var targetX:int = currentX + disperse + speed * distanceX;
			var targetY:int = currentY + disperse + speed * distanceY;
			//ターゲットプロパティ
			var targetScaleX:int = 1;
			var targetScaleY:int = 1;
			//速度(2～5)
			var speed:int = (Math.random() * 4 >> 0) + 2;
			//登退退場切り替えジャッジ
			var judge:int = 1;
			//登場済みかどうか
			var isEmerged:Boolean = false;
			//シェイプ生成
			var shape:Shape = new Shape();
			shape.x = currentX;
			shape.y = currentY;
			shape.graphics.beginFill(color, 1);
			if (type == "circle") { shape.graphics.drawCircle( 0, 0, radius); };
			if (type == "square") { shape.graphics.drawRect( -radius / 2, -radius / 2, radius, radius); };
			//初期プロパティ
			shape.scaleX = 0;
			shape.scaleY = 0;
			shape.alpha = Math.random();
			//addする
			container.addChild(shape);
			//動き
			shape.addEventListener
			(
				Event.ENTER_FRAME,
				function(e:Event):void 
				{ 
					//rotation(上に行ったら右回転下に行ったら左回転)
					shape.rotation -= ((targetY - shape.y) * speed) / 5;
					//x
					if (int(Math.abs(targetX - shape.x)) > judge) { shape.x += (targetX - shape.x) / 10; } else { shape.x = targetX; };
					//y
					if (int(Math.abs(targetY - shape.y)) > judge) { shape.y += (targetY - shape.y) / 10; } else { shape.y = targetY; };
					//scale
					if (Math.abs(targetScaleX - shape.scaleX) * 100 > judge && Math.abs(targetScaleY - shape.scaleY) * 100 > judge)
					{
						shape.scaleX += (targetScaleX - shape.scaleX) / speed;
						shape.scaleY += (targetScaleY - shape.scaleY) / speed;
					}
					else
					{
						shape.scaleX = targetScaleX;
						shape.scaleY = targetScaleY;
						//退場アニメーションへ移行
						isEmerged = true;
					}
					//退場アニメーションへ
					if (isEmerged)
					{
						targetScaleY = 0;
						targetScaleX = 0;
					}
					//登場済みで退場アニメーションが終わっていたら終了処理
					if (isEmerged && shape.scaleX === targetScaleX && shape.scaleY === targetScaleY)
					{
						e.target.removeEventListener(Event.ENTER_FRAME, arguments.callee);
						//removeする
						shape.graphics.clear();
						container.removeChild(shape);
					}
				} 
			);
		}
	}
}